/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.network;

import appeng.api.storage.data.IAEStack;
import appeng.core.AELog;
import appeng.util.item.AEFluidStack;
import appeng.util.item.AEItemStack;
import com.asdflj.ae2thing.network.SPacketMEItemInvUpdate;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public abstract class SPacketMEBaseInvUpdate
implements IMessage {
    protected static final int UNCOMPRESSED_PACKET_BYTE_LIMIT = 0x1000000;
    protected static final int OPERATION_BYTE_LIMIT = 2048;
    protected static final int TEMP_BUFFER_SIZE = 1024;
    protected static final int STREAM_MASK = 255;
    @Nullable
    protected GZIPOutputStream compressFrame;
    protected int writtenBytes = 0;
    protected final ByteBuf data = Unpooled.buffer((int)2048);
    protected byte ref = 0;
    protected final List<IAEStack<?>> list = new ArrayList();

    public SPacketMEBaseInvUpdate() {
    }

    public SPacketMEBaseInvUpdate(byte b) {
        this.setRef(b);
    }

    protected void compress() throws IOException, BufferOverflowException {
        for (IAEStack<?> is : this.getList()) {
            ByteBuf tmp = Unpooled.buffer((int)2048);
            is.writeToPacket(tmp);
            assert (this.compressFrame != null);
            this.compressFrame.flush();
            if (this.writtenBytes + tmp.readableBytes() > 0x1000000) {
                throw new BufferOverflowException();
            }
            this.writtenBytes += tmp.readableBytes();
            this.compressFrame.write(tmp.array(), 0, tmp.readableBytes());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.getRef());
        try {
            this.compressFrame = new GZIPOutputStream(new OutputStream(){

                @Override
                public void write(int value) {
                    SPacketMEBaseInvUpdate.this.data.writeByte(value);
                }
            });
            this.compress();
            this.compressFrame.finish();
            buf.writeBytes(this.data);
            this.compressFrame.close();
        }
        catch (IOException io) {
            AELog.error((Throwable)io);
        }
    }

    public void fromBytes(final ByteBuf buf) {
        this.ref = buf.readByte();
        try {
            GZIPInputStream gzReader = new GZIPInputStream(new InputStream(){

                @Override
                public int read() {
                    if (buf.readableBytes() <= 0) {
                        return -1;
                    }
                    return buf.readByte() & 0xFF;
                }
            });
            ByteBuf uncompressed = Unpooled.buffer((int)buf.readableBytes());
            byte[] tmp = new byte[1024];
            while (gzReader.available() != 0) {
                int bytes = gzReader.read(tmp);
                if (bytes <= 0) continue;
                uncompressed.writeBytes(tmp, 0, bytes);
            }
            gzReader.close();
            while (uncompressed.readableBytes() > 0) {
                if (this instanceof SPacketMEItemInvUpdate) {
                    this.loadItemStackFromPacket(uncompressed);
                    continue;
                }
                this.loadFluidStackFromPacket(uncompressed);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static long getPacketValue(byte type, ByteBuf tag) {
        if (type == 0) {
            long l = tag.readByte();
            return l -= -128L;
        }
        if (type == 1) {
            long l = tag.readShort();
            return l -= -32768L;
        }
        if (type == 2) {
            long l = tag.readInt();
            return l -= Integer.MIN_VALUE;
        }
        return tag.readLong();
    }

    private void loadFluidStackFromPacket(ByteBuf data) throws IOException {
        byte mask = data.readByte();
        byte stackType = (byte)((mask & 0xC) >> 2);
        byte countReqType = (byte)((mask & 0x30) >> 4);
        boolean isCraftable = (mask & 0x40) > 0;
        boolean hasTagCompound = (mask & 0x80) > 0;
        NBTTagCompound d = new NBTTagCompound();
        byte len2 = data.readByte();
        byte[] name = new byte[len2];
        data.readBytes(name, 0, (int)len2);
        d.func_74778_a("FluidName", new String(name, StandardCharsets.UTF_8));
        d.func_74774_a("Count", (byte)0);
        if (hasTagCompound) {
            int len = data.readInt();
            byte[] bd = new byte[len];
            data.readBytes(bd);
            DataInputStream di = new DataInputStream(new ByteArrayInputStream(bd));
            d.func_74782_a("tag", (NBTBase)CompressedStreamTools.func_74794_a((DataInputStream)di));
        }
        long stackSize = SPacketMEBaseInvUpdate.getPacketValue(stackType, data);
        long countRequestable = SPacketMEBaseInvUpdate.getPacketValue(countReqType, data);
        byte mask2 = data.readByte();
        byte countReqMadeType = (byte)(mask2 & 3);
        byte usedPercentType = (byte)((mask2 & 0xC) >> 2);
        long countRequestableCrafts = SPacketMEBaseInvUpdate.getPacketValue(countReqMadeType, data);
        long longUsedPercent = SPacketMEBaseInvUpdate.getPacketValue(usedPercentType, data);
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)d);
        if (fluidStack == null) {
            AELog.warn((String)String.format("fluid is null, name:%s count:%s", new String(name, StandardCharsets.UTF_8), stackSize), (Object[])new Object[0]);
            return;
        }
        AEFluidStack fluid = AEFluidStack.create((Object)fluidStack);
        fluid.setStackSize(stackSize);
        fluid.setCountRequestable(countRequestable);
        fluid.setCraftable(isCraftable);
        fluid.setCountRequestableCrafts(countRequestableCrafts);
        fluid.setUsedPercent((float)longUsedPercent / 10000.0f);
        this.getList().add((IAEStack<?>)fluid);
    }

    private void loadItemStackFromPacket(ByteBuf data) throws IOException {
        byte mask = data.readByte();
        byte stackType = (byte)((mask & 0xC) >> 2);
        byte countReqType = (byte)((mask & 0x30) >> 4);
        boolean isCraftable = (mask & 0x40) > 0;
        boolean hasTagCompound = (mask & 0x80) > 0;
        NBTTagCompound d = new NBTTagCompound();
        d.func_74777_a("id", data.readShort());
        d.func_74777_a("Damage", data.readShort());
        d.func_74774_a("Count", (byte)0);
        if (hasTagCompound) {
            int len = data.readInt();
            byte[] bd = new byte[len];
            data.readBytes(bd);
            ByteArrayInputStream di = new ByteArrayInputStream(bd);
            d.func_74782_a("tag", (NBTBase)CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(di)));
        }
        long stackSize = SPacketMEBaseInvUpdate.getPacketValue(stackType, data);
        long countRequestable = SPacketMEBaseInvUpdate.getPacketValue(countReqType, data);
        byte mask2 = data.readByte();
        byte countReqMadeType = (byte)(mask2 & 3);
        byte usedPercentType = (byte)((mask2 & 0xC) >> 2);
        long countRequestableCrafts = SPacketMEBaseInvUpdate.getPacketValue(countReqMadeType, data);
        long longUsedPercent = SPacketMEBaseInvUpdate.getPacketValue(usedPercentType, data);
        ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)d);
        if (itemstack == null) {
            String id = String.valueOf(d.func_74765_d("id"));
            short damage = d.func_74765_d("Damage");
            AELog.warn((String)String.format("itemstack is null, id:%s count:%s damage:%s", id, stackSize, (int)damage), (Object[])new Object[0]);
            return;
        }
        AEItemStack item = AEItemStack.create((ItemStack)itemstack);
        item.setStackSize(stackSize);
        item.setCountRequestable(countRequestable);
        item.setCraftable(isCraftable);
        item.setCountRequestableCrafts(countRequestableCrafts);
        item.setUsedPercent((float)longUsedPercent / 10000.0f);
        this.getList().add((IAEStack<?>)item);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public List<IAEStack<?>> getList() {
        return this.list;
    }

    public byte getRef() {
        return this.ref;
    }

    public void setRef(byte ref) {
        this.ref = ref;
    }
}

