/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.network;

import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import com.asdflj.ae2thing.client.gui.GuiWirelessConnectorTerminal;
import com.asdflj.ae2thing.util.Info;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.bdew.ae2stuff.machines.wireless.BlockWireless;
import net.bdew.ae2stuff.machines.wireless.TileWireless;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import scala.Option;

public class SPacketWirelessConnectorUpdate
implements IMessage {
    private final List<TileWireless> tiles = new ArrayList<TileWireless>();
    private final List<Info> infos = new ArrayList<Info>();

    public SPacketWirelessConnectorUpdate() {
    }

    public SPacketWirelessConnectorUpdate(List<TileWireless> list) {
        this.tiles.addAll(list.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public void fromBytes(ByteBuf buf) {
        try {
            int size = buf.readShort();
            ByteArrayInputStream bytes = new ByteArrayInputStream(buf.readBytes(buf.readableBytes()).array());
            NBTTagCompound comp = CompressedStreamTools.func_74796_a((InputStream)bytes);
            if (comp != null) {
                for (int x = 0; x < size; ++x) {
                    NBTTagCompound tag = (NBTTagCompound)comp.func_74781_a("#" + x);
                    DimensionalCoord a = DimensionalCoord.readFromNBT((NBTTagCompound)tag);
                    String name = tag.func_74779_i("name");
                    AEColor color = AEColor.values()[tag.func_74762_e("color")];
                    boolean is_linked = tag.func_74767_n("is_linked");
                    int used = tag.func_74762_e("used");
                    this.infos.add(new Info(a, tag.func_74764_b("link") ? DimensionalCoord.readFromNBT((NBTTagCompound)((NBTTagCompound)tag.func_74781_a("link"))) : null, name, color, is_linked, used));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            buf.writeShort(this.tiles.size());
            NBTTagCompound tag = new NBTTagCompound();
            int count = 0;
            for (TileWireless tile : this.tiles) {
                NBTTagCompound data = new NBTTagCompound();
                tile.getLocation().writeToNBT(data);
                data.func_74778_a("name", tile.hasCustomName() ? tile.getCustomName() : BlockWireless.getLocalizedName());
                data.func_74768_a("color", tile.getColor().ordinal());
                data.func_74757_a("is_linked", tile.isLinked());
                data.func_74768_a("used", tile.connection() != null ? tile.connection().getUsedChannels() : 0);
                if (tile.isLinked()) {
                    NBTTagCompound t = new NBTTagCompound();
                    Option other = tile.getLink();
                    if (!other.isEmpty()) {
                        ((TileWireless)other.get()).getLocation().writeToNBT(t);
                        data.func_74782_a("link", (NBTBase)t);
                    }
                }
                tag.func_74782_a("#" + count, (NBTBase)data);
                ++count;
            }
            ByteBuf data = Unpooled.buffer();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(bytes);
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)outputStream);
            data.writeBytes(bytes.toByteArray());
            data.capacity(data.readableBytes());
            buf.writeBytes(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Handler
    implements IMessageHandler<SPacketWirelessConnectorUpdate, IMessage> {
        @Nullable
        public IMessage onMessage(SPacketWirelessConnectorUpdate message, MessageContext ctx) {
            GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
            if (gs instanceof GuiWirelessConnectorTerminal) {
                ((GuiWirelessConnectorTerminal)gs).postUpdate(message.infos);
            }
            return null;
        }
    }
}

