/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.network;

import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import com.github.shyiko.mysql.binlog.io.ByteArrayOutputStream;
import com.github.shyiko.mysql.binlog.network.AuthenticationException;
import com.github.shyiko.mysql.binlog.network.protocol.ErrorPacket;
import com.github.shyiko.mysql.binlog.network.protocol.GreetingPacket;
import com.github.shyiko.mysql.binlog.network.protocol.PacketChannel;
import com.github.shyiko.mysql.binlog.network.protocol.command.AuthenticateNativePasswordCommand;
import com.github.shyiko.mysql.binlog.network.protocol.command.AuthenticateSHA2Command;
import com.github.shyiko.mysql.binlog.network.protocol.command.AuthenticateSHA2RSAPasswordCommand;
import com.github.shyiko.mysql.binlog.network.protocol.command.AuthenticateSecurityPasswordCommand;
import com.github.shyiko.mysql.binlog.network.protocol.command.ByteArrayCommand;
import com.github.shyiko.mysql.binlog.network.protocol.command.Command;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Authenticator {
    private final GreetingPacket greetingPacket;
    private String scramble;
    private final PacketChannel channel;
    private final String schema;
    private final String username;
    private final String password;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final String SHA2_PASSWORD = "caching_sha2_password";
    private final String MYSQL_NATIVE = "mysql_native_password";
    private AuthMethod authMethod = AuthMethod.NATIVE;

    public Authenticator(GreetingPacket greetingPacket, PacketChannel channel, String schema, String username, String password) {
        this.greetingPacket = greetingPacket;
        this.scramble = greetingPacket.getScramble();
        this.channel = channel;
        this.schema = schema;
        this.username = username;
        this.password = password;
    }

    public void authenticate() throws IOException {
        Command authenticateCommand;
        this.logger.log(Level.FINE, "Begin auth for " + this.username);
        int collation = this.greetingPacket.getServerCollation();
        if ("caching_sha2_password".equals(this.greetingPacket.getPluginProvidedData())) {
            this.authMethod = AuthMethod.CACHING_SHA2;
            authenticateCommand = new AuthenticateSHA2Command(this.schema, this.username, this.password, this.scramble, collation);
        } else {
            this.authMethod = AuthMethod.NATIVE;
            authenticateCommand = new AuthenticateSecurityPasswordCommand(this.schema, this.username, this.password, this.scramble, collation);
        }
        this.channel.write(authenticateCommand);
        this.readResult();
        this.logger.log(Level.FINE, "Auth complete " + this.username);
    }

    private void readResult() throws IOException {
        byte[] authenticationResult = this.channel.read();
        switch (authenticationResult[0]) {
            case 0: {
                return;
            }
            case -1: {
                byte[] bytes = Arrays.copyOfRange(authenticationResult, 1, authenticationResult.length);
                ErrorPacket errorPacket = new ErrorPacket(bytes);
                throw new AuthenticationException(errorPacket.getErrorMessage(), errorPacket.getErrorCode(), errorPacket.getSqlState());
            }
            case -2: {
                this.switchAuthentication(authenticationResult);
                return;
            }
        }
        if (this.authMethod == AuthMethod.NATIVE) {
            throw new AuthenticationException("Unexpected authentication result (" + authenticationResult[0] + ")");
        }
        this.processCachingSHA2Result(authenticationResult);
    }

    private void processCachingSHA2Result(byte[] authenticationResult) throws IOException {
        if (authenticationResult.length < 2) {
            throw new AuthenticationException("caching_sha2_password response too short!");
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(authenticationResult);
        stream.readPackedInteger();
        switch (stream.read()) {
            case 3: {
                this.logger.log(Level.FINE, "cached sha2 auth successful");
                this.readResult();
                return;
            }
            case 4: {
                this.logger.log(Level.FINE, "cached sha2 auth not successful, moving to full auth path");
                this.continueCachingSHA2Authentication();
            }
        }
    }

    private void continueCachingSHA2Authentication() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        if (!this.channel.isSSL()) {
            buffer.write(2);
            this.channel.write(new ByteArrayCommand(buffer.toByteArray()));
            ByteArrayInputStream stream = new ByteArrayInputStream(this.channel.read());
            int result = stream.read();
            switch (result) {
                case 1: {
                    byte[] rsaKey = new byte[stream.available()];
                    stream.read(rsaKey);
                    this.logger.log(Level.FINE, "received RSA key: " + rsaKey);
                    AuthenticateSHA2RSAPasswordCommand c = new AuthenticateSHA2RSAPasswordCommand(new String(rsaKey), this.password, this.scramble);
                    this.channel.write(c);
                    this.readResult();
                    return;
                }
            }
            throw new AuthenticationException("Unkown response fetching RSA key in caching_sha2_pasword auth: " + result);
        }
        buffer.writeZeroTerminatedString(this.password);
        ByteArrayCommand c = new ByteArrayCommand(buffer.toByteArray());
        this.channel.write(c);
        this.readResult();
    }

    private void switchAuthentication(byte[] authenticationResult) throws IOException {
        ByteArrayInputStream buffer = new ByteArrayInputStream(authenticationResult);
        buffer.read(1);
        String authName = buffer.readZeroTerminatedString();
        if ("mysql_native_password".equals(authName)) {
            this.authMethod = AuthMethod.NATIVE;
            this.scramble = buffer.readZeroTerminatedString();
            AuthenticateNativePasswordCommand switchCommand = new AuthenticateNativePasswordCommand(this.scramble, this.password);
            this.channel.write(switchCommand);
        } else if ("caching_sha2_password".equals(authName)) {
            this.authMethod = AuthMethod.CACHING_SHA2;
            this.scramble = buffer.readZeroTerminatedString();
            AuthenticateSHA2Command authCommand = new AuthenticateSHA2Command(this.scramble, this.password);
            this.channel.write(authCommand);
        } else {
            throw new AuthenticationException("unsupported authentication method: " + authName);
        }
        this.readResult();
    }

    private static enum AuthMethod {
        NATIVE,
        CACHING_SHA2;

    }
}

