/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source;

import io.debezium.relational.RelationalDatabaseConnectorConfig;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.annotation.VisibleForTesting;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.source.DataSource;
import org.apache.flink.cdc.common.source.EventSourceProvider;
import org.apache.flink.cdc.common.source.FlinkSourceProvider;
import org.apache.flink.cdc.common.source.MetadataAccessor;
import org.apache.flink.cdc.common.source.SupportedMetadataColumn;
import org.apache.flink.cdc.connectors.mysql.source.MySqlEventDeserializer;
import org.apache.flink.cdc.connectors.mysql.source.MySqlMetadataAccessor;
import org.apache.flink.cdc.connectors.mysql.source.MySqlSource;
import org.apache.flink.cdc.connectors.mysql.source.OpTsMetadataColumn;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfigFactory;
import org.apache.flink.cdc.connectors.mysql.source.reader.MySqlPipelineRecordEmitter;
import org.apache.flink.cdc.connectors.mysql.table.MySqlReadableMetadata;
import org.apache.flink.cdc.debezium.table.DebeziumChangelogMode;

@Internal
public class MySqlDataSource
implements DataSource {
    private final MySqlSourceConfigFactory configFactory;
    private final MySqlSourceConfig sourceConfig;
    private List<MySqlReadableMetadata> readableMetadataList;

    public MySqlDataSource(MySqlSourceConfigFactory configFactory) {
        this(configFactory, new ArrayList<MySqlReadableMetadata>());
    }

    public MySqlDataSource(MySqlSourceConfigFactory configFactory, List<MySqlReadableMetadata> readableMetadataList) {
        this.configFactory = configFactory;
        this.sourceConfig = configFactory.createConfig(0);
        this.readableMetadataList = readableMetadataList;
    }

    public EventSourceProvider getEventSourceProvider() {
        boolean includeComments = this.sourceConfig.getDbzConfiguration().getBoolean(RelationalDatabaseConnectorConfig.INCLUDE_SCHEMA_COMMENTS.name(), false);
        MySqlEventDeserializer deserializer = new MySqlEventDeserializer(DebeziumChangelogMode.ALL, this.sourceConfig.isIncludeSchemaChanges(), this.readableMetadataList, includeComments, this.sourceConfig.isTreatTinyInt1AsBoolean());
        MySqlSource<Event> source = new MySqlSource<Event>(this.configFactory, deserializer, (sourceReaderMetrics, sourceConfig) -> new MySqlPipelineRecordEmitter(deserializer, sourceReaderMetrics, sourceConfig));
        return FlinkSourceProvider.of(source);
    }

    public MetadataAccessor getMetadataAccessor() {
        return new MySqlMetadataAccessor(this.sourceConfig);
    }

    @VisibleForTesting
    public MySqlSourceConfig getSourceConfig() {
        return this.sourceConfig;
    }

    public SupportedMetadataColumn[] supportedMetadataColumns() {
        return new SupportedMetadataColumn[]{new OpTsMetadataColumn()};
    }

    public boolean isParallelMetadataSource() {
        return false;
    }
}

