/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.debezium.table;

import java.io.Serializable;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.apache.flink.cdc.debezium.table.MetadataConverter;
import org.apache.flink.cdc.debezium.table.RowDataMetadataConverter;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;

@Internal
public final class AppendMetadataCollector
implements Collector<RowData>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MetadataConverter[] metadataConverters;
    public transient SourceRecord inputRecord;
    public transient Collector<RowData> outputCollector;
    private final boolean appendOnly;

    public AppendMetadataCollector(MetadataConverter[] metadataConverters) {
        this(metadataConverters, false);
    }

    public AppendMetadataCollector(MetadataConverter[] metadataConverters, boolean appendOnly) {
        this.metadataConverters = metadataConverters;
        this.appendOnly = appendOnly;
    }

    public void collect(RowData physicalRow) {
        GenericRowData metaRow = new GenericRowData(this.metadataConverters.length);
        for (int i = 0; i < this.metadataConverters.length; ++i) {
            MetadataConverter metadataConverter = this.metadataConverters[i];
            Object meta = metadataConverter instanceof RowDataMetadataConverter ? ((RowDataMetadataConverter)metadataConverter).read(physicalRow) : metadataConverter.read(this.inputRecord);
            metaRow.setField(i, meta);
        }
        JoinedRowData outRow = this.appendOnly ? new JoinedRowData(RowKind.INSERT, physicalRow, (RowData)metaRow) : new JoinedRowData(physicalRow.getRowKind(), physicalRow, (RowData)metaRow);
        this.outputCollector.collect((Object)outRow);
    }

    public void close() {
    }
}

