/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.gui.combined.impl;

import com.mentalfrostbyte.jello.util.client.render.Resources;
import com.mentalfrostbyte.jello.util.client.render.theme.ClientColors;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil2;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LoadingGui;
import net.minecraft.resources.IAsyncReloader;
import net.minecraft.util.Util;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.opengl.Texture;

public class LoadingScreen
extends LoadingGui {
    private final Minecraft client;
    private final IAsyncReloader reloadMonitor;
    private final Consumer<Optional<Throwable>> exceptionHandler;
    private final boolean reloading;
    public static Texture sigmaLogo;
    public static Texture back;
    public static Texture background;
    private float progress;
    private long applyCompleteTime = -1L;
    private long prepareCompleteTime = -1L;

    public LoadingScreen(Minecraft client, IAsyncReloader monitor, Consumer<Optional<Throwable>> exceptionHandler, boolean reloading) {
        this.client = client;
        this.reloadMonitor = monitor;
        this.exceptionHandler = exceptionHandler;
        this.reloading = reloading;
        sigmaLogo = Resources.loadTexture("com/mentalfrostbyte/gui/resources/sigma/logo.png");
        back = Resources.loadTexture("com/mentalfrostbyte/gui/resources/loading/back.png");
        background = Resources.createScaledAndProcessedTexture2("com/mentalfrostbyte/gui/resources/loading/back.png", 0.25f, 25);
    }

    @Override
    public void render(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        long var9 = Util.milliTime();
        if (this.reloading && (this.reloadMonitor.asyncPartDone() || this.client.currentScreen != null) && this.prepareCompleteTime == -1L) {
            this.prepareCompleteTime = var9;
        }
        float var11 = this.applyCompleteTime > -1L ? (float)(var9 - this.applyCompleteTime) / 200.0f : -1.0f;
        float var12 = this.prepareCompleteTime > -1L ? (float)(var9 - this.prepareCompleteTime) / 100.0f : -1.0f;
        float var13 = 1.0f;
        float var16 = this.reloadMonitor.estimateExecutionSpeed();
        this.progress = this.progress * 0.95f + var16 * 0.050000012f;
        GL11.glPushMatrix();
        float var17 = 1111.0f;
        if (this.client.getMainWindow().getWidth() != 0) {
            var17 = this.client.getMainWindow().getFramebufferWidth() / this.client.getMainWindow().getWidth();
        }
        float var18 = (float)this.client.getMainWindow().calcGuiScale(this.client.gameSettings.guiScale, this.client.getForceUnicodeFont()) * var17;
        GL11.glScalef((float)(1.0f / var18), (float)(1.0f / var18), (float)0.0f);
        LoadingScreen.xd(var13, this.progress);
        GL11.glPopMatrix();
        if (var11 >= 2.0f) {
            this.client.setLoadingGui(null);
        }
        if (this.applyCompleteTime == -1L && this.reloadMonitor.fullyDone() && (!this.reloading || var12 >= 2.0f)) {
            try {
                this.reloadMonitor.join();
                this.exceptionHandler.accept(Optional.empty());
            }
            catch (Throwable var20) {
                this.exceptionHandler.accept(Optional.of(var20));
            }
            this.applyCompleteTime = Util.milliTime();
            if (this.client.currentScreen != null) {
                this.client.currentScreen.init(this.client, this.client.getMainWindow().getScaledWidth(), this.client.getMainWindow().getScaledHeight());
            }
        }
    }

    public static void xd(float bgOpacity, float var1) {
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        RenderUtil.drawImage(0.0f, 0.0f, (float)Minecraft.getInstance().getMainWindow().getWidth(), (float)Minecraft.getInstance().getMainWindow().getHeight(), background, bgOpacity);
        RenderUtil.drawRoundedRect2(0.0f, 0.0f, Minecraft.getInstance().getMainWindow().getWidth(), Minecraft.getInstance().getMainWindow().getHeight(), RenderUtil2.applyAlpha(0, 0.75f));
        int var4 = 455;
        int var5 = 78;
        int var6 = (Minecraft.getInstance().getMainWindow().getWidth() - var4) / 2;
        int var7 = Math.round((float)((Minecraft.getInstance().getMainWindow().getHeight() - var5) / 2) - 14.0f * bgOpacity);
        float var8 = 0.75f + bgOpacity * bgOpacity * bgOpacity * bgOpacity * 0.25f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(Minecraft.getInstance().getMainWindow().getWidth() / 2), (float)(Minecraft.getInstance().getMainWindow().getHeight() / 2), (float)0.0f);
        GL11.glScalef((float)var8, (float)var8, (float)0.0f);
        GL11.glTranslatef((float)(-Minecraft.getInstance().getMainWindow().getWidth() / 2), (float)(-Minecraft.getInstance().getMainWindow().getHeight() / 2), (float)0.0f);
        RenderUtil.drawImage((float)var6, (float)var7, (float)var4, (float)var5, sigmaLogo, RenderUtil2.applyAlpha(ClientColors.LIGHT_GREYISH_BLUE.getColor(), bgOpacity));
        float var9 = Math.min(1.0f, var1 * 1.02f);
        float var11 = 80.0f;
        if (bgOpacity == 1.0f) {
            RenderUtil.drawRoundedRect((float)var6, (float)(var7 + var5) + var11, (float)var4, 20.0f, 10.0f, RenderUtil2.applyAlpha(ClientColors.LIGHT_GREYISH_BLUE.getColor(), 0.3f * bgOpacity));
            RenderUtil.drawRoundedRect((float)(var6 + 1), (float)(var7 + var5) + var11 + 1.0f, (float)(var4 - 2), 18.0f, 9.0f, RenderUtil2.applyAlpha(ClientColors.DEEP_TEAL.getColor(), bgOpacity));
        }
        RenderUtil.drawRoundedRect((float)(var6 + 2), (float)(var7 + var5) + var11 + 2.0f, (float)((int)((float)(var4 - 4) * var9)), 16.0f, 8.0f, RenderUtil2.applyAlpha(ClientColors.LIGHT_GREYISH_BLUE.getColor(), 0.9f * bgOpacity));
        GL11.glPopMatrix();
    }
}

