/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.gui.impl.jello.viamcp;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.managers.GuiManager;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import de.florianmichael.vialoadingbase.ViaLoadingBase;
import de.florianmichael.viamcp.protocolinfo.ProtocolInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.util.text.StringTextComponent;

public class JelloPortalScreen
extends MultiplayerScreen {
    private Widget versionSelectorWidget;

    public JelloPortalScreen(Screen parentScreen) {
        super(parentScreen);
    }

    @Override
    public void init() {
        super.init();
        SliderPercentageOption versionSelector = new SliderPercentageOption("jello.portaloption", 0.0, this.getAvailableVersions().size() - 1, 1.0f, var1 -> this.getCurrentVersionIndex(), this::onSliderChange, (settings, slider) -> new StringTextComponent(this.getVersion(this.getCurrentVersionIndex()).getName()));
        this.versionSelectorWidget = this.addButton(versionSelector.createWidget(this.minecraft.gameSettings, this.width / 2 + 40, 7, 114));
    }

    private void onSliderChange(GameSettings settings, Double aDouble) {
        int newIndex = aDouble.intValue();
        if (newIndex >= 0 && newIndex < this.getAvailableVersions().size()) {
            ViaLoadingBase.getInstance().reload(this.getVersion(newIndex));
            Client.currentVersionIndex = newIndex;
        }
    }

    @Override
    public void render(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        super.render(matrices, mouseX, mouseY, delta);
        RenderUtil.drawBlurredBackground(0, 0, Minecraft.getInstance().getMainWindow().getWidth(), (int)(30.0 * Minecraft.getInstance().getMainWindow().getGuiScaleFactor() / (double)GuiManager.scaleFactor));
        this.renderBackground(matrices);
        RenderUtil.restoreScissor();
        this.versionSelectorWidget.render(matrices, mouseX, mouseY, delta);
        JelloPortalScreen.drawString(matrices, this.font, this.getTitle().getString(), this.width / 2 - 146, 13, 0xFFFFFF);
        this.minecraft.fontRenderer.drawStringWithShadow(matrices, "Jello Portal:", (float)this.width / 2.0f - 30.0f, 13.0f, -1);
    }

    private int getCurrentVersionIndex() {
        return Client.currentVersionIndex;
    }

    private List<ProtocolVersion> getAvailableVersions() {
        ArrayList<ProtocolVersion> availableVersions = new ArrayList<ProtocolVersion>();
        for (ProtocolInfo version : ProtocolInfo.PROTOCOL_INFOS) {
            availableVersions.add(version.getProtocolVersion());
        }
        return availableVersions;
    }

    private ProtocolVersion getVersion(int index) {
        List<ProtocolVersion> availableVersions = this.getAvailableVersions();
        if (index < 0 || index >= availableVersions.size()) {
            return ProtocolInfo.R1_16_4.getProtocolVersion();
        }
        return availableVersions.get(index);
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }
}

