/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.gui.impl.others;

import com.mentalfrostbyte.jello.managers.util.account.microsoft.Account;
import com.mentalfrostbyte.jello.managers.util.account.microsoft.sorting.AccountCompareType;
import com.mentalfrostbyte.jello.managers.util.account.microsoft.sorting.impl.AccountBanDateComparator;
import com.mentalfrostbyte.jello.managers.util.account.microsoft.sorting.impl.AccountDateAddedComparator;
import com.mentalfrostbyte.jello.managers.util.account.microsoft.sorting.impl.AccountLastUsedComparator;
import com.mentalfrostbyte.jello.managers.util.account.microsoft.sorting.impl.AccountNameComparator;
import com.mentalfrostbyte.jello.managers.util.account.microsoft.sorting.impl.AccountUsageCountComparator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AccountSorter {
    public static List<Account> sortByInputAltAccounts(List<Account> var0, AccountCompareType compareType, String serverIP, String input) {
        List<Account> sortedAccounts = AccountSorter.sortAltAccounts(var0, compareType, serverIP);
        if (!(input = input.toLowerCase()).isEmpty()) {
            ArrayList<Account> matchedAccounts = new ArrayList<Account>();
            Iterator<Account> accountIterator = sortedAccounts.iterator();
            while (accountIterator.hasNext()) {
                Account account = accountIterator.next();
                if (!account.getKnownName().toLowerCase().startsWith(input)) continue;
                matchedAccounts.add(account);
                accountIterator.remove();
            }
            Iterator<Account> accountIterator2 = sortedAccounts.iterator();
            while (accountIterator2.hasNext()) {
                Account account = accountIterator2.next();
                if (!account.getKnownName().toLowerCase().contains(input)) continue;
                matchedAccounts.add(account);
                accountIterator2.remove();
            }
            matchedAccounts.addAll(sortedAccounts);
            return matchedAccounts;
        }
        return sortedAccounts;
    }

    public static List<Account> sortAltAccounts(List<Account> accountList, AccountCompareType compareType, String serverIP) {
        ArrayList<Account> sortedList = new ArrayList<Account>(accountList);
        switch (compareType) {
            case Alphabetical: {
                sortedList.sort(new AccountNameComparator());
                break;
            }
            case Bans: {
                sortedList.sort(new AccountBanDateComparator(serverIP));
                break;
            }
            case DateAdded: {
                sortedList.sort(new AccountDateAddedComparator());
                break;
            }
            case LastUsed: {
                sortedList.sort(new AccountLastUsedComparator());
                break;
            }
            case UseCount: {
                sortedList.sort(new AccountUsageCountComparator());
            }
        }
        return sortedList;
    }
}

