/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.managers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRender2DCustom;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRender2DOffset;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRenderChat;
import com.mentalfrostbyte.jello.event.impl.player.EventUpdate;
import com.mentalfrostbyte.jello.managers.data.Manager;
import com.mentalfrostbyte.jello.managers.util.Thumbnails;
import com.mentalfrostbyte.jello.managers.util.notifs.Notification;
import com.mentalfrostbyte.jello.util.client.ClientMode;
import com.mentalfrostbyte.jello.util.client.music.JavaFFT;
import com.mentalfrostbyte.jello.util.client.network.youtube.YoutubeContentType;
import com.mentalfrostbyte.jello.util.client.network.youtube.YoutubeUtil;
import com.mentalfrostbyte.jello.util.client.network.youtube.YoutubeVideoData;
import com.mentalfrostbyte.jello.util.client.render.ResourceRegistry;
import com.mentalfrostbyte.jello.util.client.render.theme.ClientColors;
import com.mentalfrostbyte.jello.util.game.MinecraftUtil;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil2;
import com.mentalfrostbyte.jello.util.system.math.MathHelper;
import com.mentalfrostbyte.jello.util.system.network.ImageUtil;
import com.mentalfrostbyte.jello.util.system.sound.AudioRepeatMode;
import com.mentalfrostbyte.jello.util.system.sound.BasicAudioProcessor;
import com.mentalfrostbyte.jello.util.system.sound.MusicStream;
import com.sapher.youtubedl.YoutubeDL;
import com.sapher.youtubedl.YoutubeDLException;
import com.sapher.youtubedl.YoutubeDLRequest;
import com.sapher.youtubedl.YoutubeDLResponse;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Util;
import net.sourceforge.jaad.aac.Decoder;
import net.sourceforge.jaad.aac.SampleBuffer;
import net.sourceforge.jaad.mp4.MP4Container;
import net.sourceforge.jaad.mp4.api.AudioTrack;
import net.sourceforge.jaad.mp4.api.Frame;
import net.sourceforge.jaad.mp4.api.Movie;
import net.sourceforge.jaad.mp4.api.Track;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.util.BufferedImageUtil;
import team.sdhq.eventBus.annotations.EventTarget;

public class MusicManager
extends Manager
implements MinecraftUtil {
    public BufferedImage scaledThumbnail;
    public String songTitle = "";
    public List<double[]> visualizerData = new ArrayList<double[]>();
    public ArrayList<Double> amplitudes = new ArrayList();
    public SourceDataLine sourceDataLine;
    private boolean playing = false;
    private Thumbnails videoManager;
    private int volume = 50;
    private long duration = -1L;
    private Texture notificationImage;
    private BufferedImage thumbnailImage;
    private Texture songThumbnail;
    private boolean processing = false;
    private volatile transient Thread audioThread = null;
    private int currentVideoIndex2;
    private long totalDuration = 0L;
    private int currentVideoIndex;
    private YoutubeVideoData currentVideo;
    private boolean spectrum = true;
    private AudioRepeatMode repeat = AudioRepeatMode.REPEAT;
    private boolean finished = false;
    private double field32168;
    private boolean field32169 = false;
    private double field32170 = 0.0;

    @Override
    public void init() {
        super.init();
        try {
            this.loadSettings();
        }
        catch (JsonParseException e) {
            Client.logger.error((Object)e);
        }
        if (!this.doesYTDLPExist()) {
            this.setupDownloadThread();
        }
        this.finished = false;
    }

    public void saveMusicSettings() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("volume", (Number)this.volume);
        jsonObject.addProperty("spectrum", Boolean.valueOf(this.spectrum));
        jsonObject.addProperty("repeat", (Number)this.repeat.type);
        Client.getInstance().config.add("music", (JsonElement)jsonObject);
    }

    private void loadSettings() throws JsonParseException {
        JsonObject jsonObject;
        if (Client.getInstance().config.has("music") && (jsonObject = Client.getInstance().config.getAsJsonObject("music")) != null) {
            if (jsonObject.has("volume")) {
                this.volume = Math.max(0, Math.min(100, jsonObject.get("volume").getAsInt()));
            }
            if (jsonObject.has("spectrum")) {
                this.spectrum = jsonObject.get("spectrum").getAsBoolean();
            }
            if (jsonObject.has("repeat")) {
                this.repeat = AudioRepeatMode.parseRepeat(jsonObject.get("repeat").getAsInt());
            }
        }
    }

    @EventTarget
    public void onRender2D(EventRender2DOffset event) {
        if (Client.getInstance().clientMode == ClientMode.JELLO && this.playing && !this.visualizerData.isEmpty()) {
            double[] var4 = this.visualizerData.get(0);
            if (this.amplitudes.isEmpty()) {
                for (double v : var4) {
                    if (this.amplitudes.size() >= 1024) continue;
                    this.amplitudes.add(v);
                }
            }
            float fps = 60.0f / (float)Minecraft.getFps();
            for (int i = 0; i < var4.length; ++i) {
                double var7 = this.amplitudes.get(i) - var4[i];
                boolean var9 = !(this.amplitudes.get(i) < Double.MAX_VALUE);
                this.amplitudes.set(i, Math.min(2.256E7, Math.max(0.0, this.amplitudes.get(i) - var7 * (double)Math.min(0.335f * fps, 1.0f))));
                if (!var9) continue;
                this.amplitudes.set(i, 0.0);
            }
        }
    }

    @EventTarget
    public void onRenderChat(EventRenderChat eventRenderChat) {
        if (this.isPlayingSong()) {
            eventRenderChat.addOffset(-45);
        }
    }

    @EventTarget
    public void onRender2D(EventRender2DCustom event) {
        if (this.playing && !this.visualizerData.isEmpty() && this.spectrum) {
            this.renderSpectrum();
        }
    }

    private void renderSpectrum() {
        if (!this.visualizerData.isEmpty() && this.notificationImage != null && !this.amplitudes.isEmpty()) {
            float maxWidth = 114.0f;
            float width = (float)Math.ceil((float)mc.getMainWindow().getWidth() / maxWidth);
            int i = 0;
            while ((float)i < maxWidth) {
                float alphaValue = 1.0f - (float)(i + 1) / maxWidth;
                float heightRatio = (float)mc.getMainWindow().getHeight() / 1080.0f;
                float height = ((float)(Math.sqrt(this.amplitudes.get(i)) / 12.0) - 5.0f) * heightRatio;
                RenderUtil.drawRoundedRect2((float)i * width, (float)mc.getMainWindow().getHeight() - height, width, height, RenderUtil2.applyAlpha(ClientColors.MID_GREY.getColor(), 0.2f * alphaValue));
                ++i;
            }
            RenderUtil.initStencilBuffer();
            i = 0;
            while ((float)i < maxWidth) {
                float heightRatio = (float)mc.getMainWindow().getHeight() / 1080.0f;
                float height = ((float)(Math.sqrt(this.amplitudes.get(i)) / 12.0) - 5.0f) * heightRatio;
                RenderUtil.drawRoundedRect2((float)i * width, (float)mc.getMainWindow().getHeight() - height, width, height, ClientColors.LIGHT_GREYISH_BLUE.getColor());
                ++i;
            }
            RenderUtil.configureStencilTest();
            if (this.notificationImage != null && this.songThumbnail != null) {
                RenderUtil.drawImage(0.0f, 0.0f, (float)mc.getMainWindow().getWidth(), (float)mc.getMainWindow().getHeight(), this.songThumbnail, 0.4f);
            }
            RenderUtil.restorePreviousStencilBuffer();
            double var9 = 0.0;
            float var16 = 4750.0f;
            for (int i2 = 0; i2 < 3; ++i2) {
                var9 = Math.max(var9, Math.sqrt(this.amplitudes.get(i2)) - 1000.0);
            }
            float scale = 1.0f + (float)Math.round((float)(var9 / (double)(var16 - 1000.0f)) * 0.14f * 75.0f) / 75.0f;
            GL11.glPushMatrix();
            GL11.glTranslated((double)60.0, (double)(mc.getMainWindow().getHeight() - 55), (double)0.0);
            GL11.glScalef((float)scale, (float)scale, (float)0.0f);
            GL11.glTranslated((double)-60.0, (double)(-(mc.getMainWindow().getHeight() - 55)), (double)0.0);
            RenderUtil.drawImage(10.0f, mc.getMainWindow().getHeight() - 110, 100.0f, 100.0f, this.notificationImage);
            RenderUtil.drawRoundedRect(10.0f, (float)(mc.getMainWindow().getHeight() - 110), 100.0f, 100.0f, 14.0f, 0.3f);
            GL11.glPopMatrix();
            String[] titleSplit = this.songTitle.split(" - ");
            if (titleSplit.length <= 1) {
                RenderUtil.drawString(ResourceRegistry.JelloLightFont18_1, 130.0f, mc.getMainWindow().getHeight() - 70, titleSplit[0], RenderUtil2.applyAlpha(ClientColors.DEEP_TEAL.getColor(), 0.5f));
                RenderUtil.drawString(ResourceRegistry.JelloLightFont18, 130.0f, mc.getMainWindow().getHeight() - 70, titleSplit[0], RenderUtil2.applyAlpha(ClientColors.LIGHT_GREYISH_BLUE.getColor(), 0.7f));
            } else {
                RenderUtil.drawString(ResourceRegistry.JelloMediumFont20_1, 130.0f, mc.getMainWindow().getHeight() - 81, titleSplit[0], RenderUtil2.applyAlpha(ClientColors.DEEP_TEAL.getColor(), 0.4f));
                RenderUtil.drawString(ResourceRegistry.JelloLightFont18_1, 130.0f, mc.getMainWindow().getHeight() - 56, titleSplit[1], RenderUtil2.applyAlpha(ClientColors.DEEP_TEAL.getColor(), 0.5f));
                RenderUtil.drawString(ResourceRegistry.JelloLightFont18, 130.0f, mc.getMainWindow().getHeight() - 56, titleSplit[1], RenderUtil2.applyAlpha(ClientColors.LIGHT_GREYISH_BLUE.getColor(), 0.7f));
                RenderUtil.drawString(ResourceRegistry.JelloMediumFont20, 130.0f, mc.getMainWindow().getHeight() - 81, titleSplit[0], RenderUtil2.applyAlpha(ClientColors.LIGHT_GREYISH_BLUE.getColor(), 0.6f));
            }
        }
    }

    @EventTarget
    public void onTick(EventUpdate event) {
        if (!this.playing) {
            this.visualizerData.clear();
            this.amplitudes.clear();
        }
        try {
            if (this.processing && this.thumbnailImage != null && this.scaledThumbnail != null && this.currentVideo == null && !mc.isGamePaused()) {
                if (this.songThumbnail != null) {
                    this.songThumbnail.release();
                }
                if (this.notificationImage != null) {
                    this.notificationImage.release();
                }
                this.songThumbnail = BufferedImageUtil.getTexture("picture", this.thumbnailImage);
                this.notificationImage = BufferedImageUtil.getTexture("picture", this.scaledThumbnail);
                Client.getInstance().notificationManager.send(new Notification("Now Playing", this.songTitle, 7000, this.notificationImage));
                this.processing = false;
            }
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
        if (!this.processing) {
            this.startProcessingVideoThumbnail();
        }
    }

    private void startProcessingVideoThumbnail() {
        if (this.currentVideo != null) {
            this.visualizerData.clear();
            new Thread(() -> this.processVideoThumbnail(this.currentVideo)).start();
        }
    }

    private void initializeAudioPlayback() {
        this.visualizerData.clear();
        if (this.videoManager != null) {
            while (this.audioThread != null && this.audioThread.isAlive()) {
                this.audioThread.interrupt();
            }
            this.audioThread = new Thread(() -> {
                if (this.currentVideoIndex < 0 || this.currentVideoIndex >= this.videoManager.videoList.size()) {
                    this.currentVideoIndex = 0;
                }
                for (int index = this.currentVideoIndex; index < this.videoManager.videoList.size(); ++index) {
                    URL songUrl = YoutubeUtil.getVideoStreamURL(this.videoManager.videoList.get((int)index).videoId);
                    this.currentVideoIndex2 = index;
                    this.currentVideo = this.videoManager.videoList.get(index);
                    this.visualizerData.clear();
                    while (!this.playing) {
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        double[] var6 = new double[]{};
                        this.visualizerData.clear();
                        if (!Thread.interrupted()) continue;
                        if (this.sourceDataLine != null) {
                            this.sourceDataLine.close();
                        }
                        return;
                    }
                    try {
                        URL url = this.resolveAudioStream(songUrl);
                        if (url != null) {
                            URLConnection connection = url.openConnection();
                            connection.setConnectTimeout(14000);
                            connection.setReadTimeout(14000);
                            connection.setUseCaches(true);
                            connection.setDoOutput(true);
                            connection.setRequestProperty("Connection", "Keep-Alive");
                            InputStream iS = connection.getInputStream();
                            MusicStream mS = new MusicStream(iS, new BasicAudioProcessor());
                            MP4Container container = new MP4Container(mS);
                            Movie movie = container.getMovie();
                            List<Track> tracks = movie.getTracks();
                            AudioTrack var13 = (AudioTrack)movie.getTracks().get(1);
                            AudioFormat var14 = new AudioFormat(var13.getSampleRate(), var13.getSampleSize(), var13.getChannelCount(), true, true);
                            this.sourceDataLine = AudioSystem.getSourceDataLine(var14);
                            this.sourceDataLine.open();
                            this.sourceDataLine.start();
                            this.duration = (long)movie.getDuration();
                            if (this.duration > 1300L) {
                                mS.close();
                                Client.getInstance().notificationManager.send(new Notification("Now Playing", "Music is too long."));
                            }
                            Decoder var15 = new Decoder(var13.getDecoderSpecificInfo());
                            SampleBuffer var16 = new SampleBuffer();
                            while (var13.hasMoreFrames()) {
                                while (!this.playing) {
                                    Thread.sleep(300L);
                                    this.visualizerData.clear();
                                    if (!Thread.interrupted()) continue;
                                    this.sourceDataLine.close();
                                    return;
                                }
                                Frame var18 = var13.readNextFrame();
                                var15.decodeFrame(var18.getData(), var16);
                                byte[] pcmBufferData = var16.getData();
                                this.sourceDataLine.write(pcmBufferData, 0, pcmBufferData.length);
                                float[] var29 = MathHelper.convertToPCMFloatArray(var16.getData(), var14);
                                JavaFFT var19 = new JavaFFT(var29.length);
                                float[][] var20 = var19.transform(var29);
                                float[] var21 = var20[0];
                                float[] var22 = var20[1];
                                this.visualizerData.add(MathHelper.calculateAmplitudes(var21, var22));
                                if (this.visualizerData.size() > 18) {
                                    this.visualizerData.remove(0);
                                }
                                this.adjustAudioVolume(this.sourceDataLine, this.volume);
                                if (!Thread.interrupted()) {
                                    this.totalDuration = Math.round(var13.getNextTimeStamp());
                                    this.field32170 = var13.method23326();
                                    if (this.field32169) {
                                        var13.seek(this.field32168);
                                        this.totalDuration = (long)this.field32168;
                                        this.field32169 = false;
                                    }
                                }
                                if (!var13.hasMoreFrames() && (this.repeat == AudioRepeatMode.LOOP_CURRENT || this.repeat == AudioRepeatMode.REPEAT && this.videoManager.videoList.size() == 1)) {
                                    var13.seek(0.0);
                                    this.totalDuration = 0L;
                                }
                                if (!Thread.interrupted()) continue;
                                this.sourceDataLine.close();
                                return;
                            }
                            this.sourceDataLine.close();
                            mS.close();
                        } else {
                            Thread.sleep(1000L);
                        }
                    }
                    catch (IOException exc) {
                        if (exc.getMessage() != null && exc.getMessage().contains("403")) {
                            System.out.println("installing");
                            this.download();
                        }
                    }
                    catch (InterruptedException | LineUnavailableException exc) {
                        throw new RuntimeException(exc);
                    }
                    if (this.repeat == AudioRepeatMode.LOOP_CURRENT) {
                        --index;
                    } else if (this.repeat == AudioRepeatMode.REPEAT && index == this.videoManager.videoList.size() - 1) {
                        index = -1;
                    } else if (this.repeat == AudioRepeatMode.NO_REPEAT) {
                        return;
                    }
                    if (index < this.videoManager.videoList.size()) continue;
                    index = 0;
                }
            });
            this.audioThread.start();
        }
    }

    public void setRepeat(AudioRepeatMode repeatMode) {
        this.repeat = repeatMode;
        this.saveMusicSettings();
    }

    public AudioRepeatMode getRepeat() {
        return this.repeat;
    }

    public void processVideoThumbnail(YoutubeVideoData videoData) {
        try {
            this.processing = true;
            BufferedImage buffImage = ImageIO.read(new URL(videoData.fullUrl));
            this.thumbnailImage = ImageUtil.applyBlur(buffImage, 15);
            this.thumbnailImage = this.thumbnailImage.getSubimage(0, (int)((float)this.thumbnailImage.getHeight() * 0.75f), this.thumbnailImage.getWidth(), (int)((float)this.thumbnailImage.getHeight() * 0.2f));
            this.songTitle = videoData.title;
            this.scaledThumbnail = buffImage.getHeight() != buffImage.getWidth() ? (this.songTitle.contains("[NCS Release]") ? buffImage.getSubimage(1, 3, 170, 170) : buffImage.getSubimage(70, 0, 180, 180)) : buffImage;
            this.currentVideo = null;
        }
        catch (IOException | NumberFormatException var5) {
            throw new RuntimeException(var5);
        }
    }

    public void setPlaying(boolean playing) {
        if (!playing && this.sourceDataLine != null) {
            this.sourceDataLine.flush();
        }
        this.playing = playing;
    }

    public void setVolume(int var1) {
        this.volume = var1;
        this.saveMusicSettings();
    }

    public void setSpectrum(boolean var1) {
        this.spectrum = var1;
        this.saveMusicSettings();
    }

    public boolean isSpectrum() {
        return this.spectrum;
    }

    public int getVolume() {
        return this.volume;
    }

    public void playPreviousSong() {
        if (this.videoManager != null) {
            this.currentVideoIndex = this.currentVideoIndex2 - 1;
            this.totalDuration = 0L;
            this.field32170 = 0.0;
            this.initializeAudioPlayback();
        }
    }

    public void playNextSong() {
        if (this.videoManager != null) {
            this.currentVideoIndex = this.currentVideoIndex2 + 1;
            this.totalDuration = 0L;
            this.field32170 = 0.0;
            this.initializeAudioPlayback();
        }
    }

    public void playSong(Thumbnails vidManager, YoutubeVideoData videoData) {
        if (vidManager == null) {
            vidManager = new Thumbnails("temp", "temp", YoutubeContentType.PLAYLIST);
            vidManager.videoList.add(videoData);
        }
        this.videoManager = vidManager;
        this.playing = true;
        this.totalDuration = 0L;
        this.field32170 = 0.0;
        for (int i = 0; i < vidManager.videoList.size(); ++i) {
            if (vidManager.videoList.get(i) != videoData) continue;
            this.currentVideoIndex = i;
        }
        this.initializeAudioPlayback();
    }

    public boolean isPlayingSong() {
        return this.playing;
    }

    public long getDuration() {
        return this.totalDuration;
    }

    public double method24322() {
        return this.field32170;
    }

    public URL resolveAudioStream(URL songURL) {
        String songURLString = songURL.toString();
        String userHomeDir = System.getProperty("user.home");
        YoutubeDLRequest request = new YoutubeDLRequest(songURLString, userHomeDir);
        request.setOption("get-url");
        request.setOption("no-check-certificate", " ");
        request.setOption("rm-cache-dir", " ");
        request.setOption("retries", 10);
        request.setOption("format", 18);
        try {
            YoutubeDL.setExecutablePath((String)this.prepareYtDlpExecutable());
            YoutubeDLResponse response = YoutubeDL.execute((YoutubeDLRequest)request);
            String responseString = response.getOut();
            return new URL(responseString);
        }
        catch (YoutubeDLException exception) {
            if (exception.getMessage() != null && exception.getMessage().contains("ERROR: This video contains content from") && exception.getMessage().contains("who has blocked it in your country on copyright grounds")) {
                Client.getInstance().notificationManager.send(new Notification("Now Playing", "Not available in your region."));
            } else {
                exception.printStackTrace();
                this.download();
            }
        }
        catch (MalformedURLException exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public String getSongTitle() {
        return this.songTitle;
    }

    public Texture getSongThumbnail() {
        return this.songThumbnail;
    }

    public Texture getNotificationImage() {
        return this.notificationImage;
    }

    public int getDurationInt() {
        return (int)this.duration;
    }

    private void adjustAudioVolume(SourceDataLine var1, int var2) {
        try {
            FloatControl var5 = (FloatControl)var1.getControl(FloatControl.Type.MASTER_GAIN);
            BooleanControl var6 = (BooleanControl)var1.getControl(BooleanControl.Type.MUTE);
            if (var2 == 0) {
                var6.setValue(true);
            } else {
                var6.setValue(false);
                var5.setValue((float)(Math.log((double)var2 / 100.0) / Math.log(10.0) * 20.0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDuration(double duration) {
        this.field32168 = duration;
        this.totalDuration = (long)this.field32168;
        this.field32169 = true;
    }

    public boolean doesYTDLPExist() {
        File targetFile = new File(String.valueOf(Client.getInstance().file) + "/music/yt-dlp");
        if (Util.getOSType() == Util.OS.WINDOWS) {
            targetFile = new File(String.valueOf(Client.getInstance().file) + "/music/yt-dlp.exe");
        }
        return targetFile.exists();
    }

    public void setupDownloadThread() {
        new Thread(this::download).start();
    }

    public void download() {
        if (!this.finished) {
            block41: {
                File musicDir = new File(String.valueOf(Client.getInstance().file) + "/music/");
                musicDir.mkdirs();
                if (Util.getOSType() == Util.OS.WINDOWS) {
                    try {
                        File targetFile = new File(String.valueOf(Client.getInstance().file) + "/music/yt-dlp.exe");
                        CloseableHttpClient client = HttpClients.createDefault();
                        try (CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet("https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp.exe"));){
                            HttpEntity entity = response.getEntity();
                            if (entity == null) break block41;
                            try (FileOutputStream outputStream = new FileOutputStream(targetFile);){
                                entity.writeTo((OutputStream)outputStream);
                            }
                        }
                    }
                    catch (IOException exc) {
                        exc.printStackTrace();
                    }
                } else {
                    try {
                        File targetFile = new File(String.valueOf(Client.getInstance().file) + "/music/yt-dlp");
                        CloseableHttpClient client = HttpClients.createDefault();
                        try (CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet("https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp"));){
                            HttpEntity entity = response.getEntity();
                            if (entity == null) break block41;
                            try (FileOutputStream outputStream = new FileOutputStream(targetFile);){
                                entity.writeTo((OutputStream)outputStream);
                            }
                        }
                    }
                    catch (IOException exc) {
                        exc.printStackTrace();
                    }
                }
            }
            System.out.println("done");
            this.finished = true;
        }
    }

    public String prepareYtDlpExecutable() {
        String fileName = Client.getInstance().file.getAbsolutePath() + "/music/yt-dlp";
        if (Util.getOSType() != Util.OS.WINDOWS) {
            File targetFile = new File(fileName);
            targetFile.setExecutable(true);
        } else {
            fileName = fileName + ".exe";
        }
        return fileName;
    }

    public boolean hasPython() {
        String[][] commands;
        if (Util.getOSType() == Util.OS.WINDOWS) {
            return true;
        }
        for (String[] cmd : commands = new String[][]{{"python3", "-V"}, {"python", "-V"}}) {
            try {
                String version;
                Process process = new ProcessBuilder(cmd).start();
                BufferedReader inputReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((version = inputReader.readLine()) != null || (version = errorReader.readLine()) != null) {
                    if (!version.contains("Python")) continue;
                    return true;
                }
            }
            catch (IOException exc) {
                Client.logger.error("No Python version found!", (Throwable)exc);
            }
        }
        return false;
    }

    public boolean hasVCRedist() {
        String[] redistKeys;
        if (Util.getOSType() != Util.OS.WINDOWS) {
            return true;
        }
        for (String key : redistKeys = new String[]{"SOFTWARE\\WOW6432Node\\Microsoft\\VisualStudio\\10.0\\VC\\VCRedist\\x86", "SOFTWARE\\Microsoft\\VisualStudio\\10.0\\VC\\VCRedist\\x86", "SOFTWARE\\WOW6432Node\\Microsoft\\VisualStudio\\14.0\\VC\\Runtimes\\x86", "SOFTWARE\\Microsoft\\VisualStudio\\14.0\\VC\\Runtimes\\x86", "SOFTWARE\\WOW6432Node\\Microsoft\\VisualStudio\\14.0\\VC\\Runtimes\\x64", "SOFTWARE\\Microsoft\\VisualStudio\\14.0\\VC\\Runtimes\\x64", "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{D992A37A-AF08-45C4-9E49-D50EA5F46A16}_is1", "SOFTWARE\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{D992A37A-AF08-45C4-9E49-D50EA5F46A16}_is1"}) {
            try {
                if (!Advapi32Util.registryKeyExists((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)key)) continue;
                if (Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)key, (String)"Installed")) {
                    int installed = Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)key, (String)"Installed");
                    if (installed != 1) continue;
                    return true;
                }
                return true;
            }
            catch (Exception exc) {
                Client.logger.warn("Failed to check key: " + key, (Throwable)exc);
            }
        }
        return false;
    }
}

