/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.managers.util.profile.Profile;
import com.mentalfrostbyte.jello.module.data.ModuleSettingInitializr;
import com.mentalfrostbyte.jello.util.client.ClientMode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class ProfileManager {
    private final List<Profile> savedConfigs = new ArrayList<Profile>();
    private Profile currentConfigs;
    private static final String configFolder = "/profiles/";
    private static final String configFileExtension = ".profile";

    public void saveConfig(Profile config) {
        try {
            this.savedConfigs.add(0, config);
            File configItself = new File(String.valueOf(Client.getInstance().file) + configFolder + config.profileName + configFileExtension);
            if (configItself.getParentFile() != null) {
                configItself.getParentFile().mkdirs();
            }
            JsonObject jsonConfig = config.saveToJson(new JsonObject());
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String prettyJson = gson.toJson(new JsonParser().parse(jsonConfig.toString()));
            Files.write(configItself.toPath(), prettyJson.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save config: " + config.profileName, e);
        }
    }

    public void listOnly(Profile config) {
        this.savedConfigs.add(config);
    }

    public void removeConfig(Profile config) {
        this.savedConfigs.remove(config);
    }

    public boolean checkConfig(Profile config) {
        if (Client.getInstance().clientMode == ClientMode.CLASSIC && config.profileName.equals("Classic")) {
            return false;
        }
        if (this.savedConfigs.size() <= 1) {
            return false;
        }
        this.savedConfigs.remove(config);
        if (config == this.currentConfigs) {
            this.loadConfig(this.savedConfigs.get(0));
        }
        return true;
    }

    public boolean removeConfig(String configName) {
        for (Profile var5 : this.savedConfigs) {
            if (!var5.profileName.equals(configName) || !this.checkConfig(var5)) continue;
            return true;
        }
        return false;
    }

    public Profile getConfigByName(String var1) {
        for (Profile var5 : this.savedConfigs) {
            if (!var5.profileName.equalsIgnoreCase(var1)) continue;
            return var5;
        }
        return null;
    }

    public void loadProfile(String name) throws IOException {
        File[] configsFound;
        File configFolderFolder = new File(String.valueOf(Client.getInstance().file) + configFolder);
        if (!configFolderFolder.exists()) {
            configFolderFolder.mkdirs();
        }
        for (File config : configsFound = configFolderFolder.listFiles((var0, var1x) -> var1x.toLowerCase().endsWith(configFileExtension))) {
            try {
                String jsonContent = IOUtils.toString((InputStream)Files.newInputStream(config.toPath(), new OpenOption[0]), (Charset)StandardCharsets.UTF_8);
                JsonObject object = JsonParser.parseString((String)jsonContent).getAsJsonObject();
                Profile profile = new Profile().loadFromJson(object);
                profile.profileName = config.getName().substring(0, config.getName().length() - configFileExtension.length());
                this.savedConfigs.add(profile);
                if (!profile.profileName.equalsIgnoreCase(name)) continue;
                this.currentConfigs = profile;
            }
            catch (JsonParseException var12) {
                System.err.println("Unable to load profile from " + config.getName());
            }
        }
        if (this.savedConfigs.isEmpty() || this.currentConfigs == null) {
            if (name == null || name.isEmpty()) {
                name = "Default";
            }
            this.currentConfigs = new Profile(name, new JsonObject());
            this.savedConfigs.add(this.currentConfigs);
        }
        Client.getInstance().moduleManager.load(this.currentConfigs.moduleConfig);
    }

    public boolean getConfigByCaseInsensitiveName(String name) {
        for (Profile config : this.savedConfigs) {
            if (!config.profileName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public void saveAndReplaceConfigs() throws IOException {
        File[] configs;
        this.currentConfigs.moduleConfig = Client.getInstance().moduleManager.loadCurrentConfig(new JsonObject());
        File configFolderFolder = new File(String.valueOf(Client.getInstance().file) + configFolder);
        if (!configFolderFolder.exists()) {
            configFolderFolder.mkdirs();
        }
        for (File configItself : configs = configFolderFolder.listFiles((var0, var1) -> var1.toLowerCase().endsWith(configFileExtension))) {
            configItself.delete();
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        for (Profile savedConfig : this.savedConfigs) {
            File configItself;
            configItself = new File(String.valueOf(Client.getInstance().file) + configFolder + savedConfig.profileName + configFileExtension);
            if (!configItself.exists()) {
                configItself.createNewFile();
            }
            String json = gson.toJson((JsonElement)savedConfig.saveToJson(new JsonObject()));
            try (FileOutputStream outputStream = new FileOutputStream(configItself);){
                IOUtils.write((String)json, (OutputStream)outputStream, (String)"UTF-8");
            }
        }
    }

    public Profile getCurrentConfig() {
        return this.currentConfigs;
    }

    public void loadConfig(Profile config) {
        Client.getInstance().saveClientData();
        ModuleSettingInitializr.modOffsetMap = new HashMap();
        if (Client.getInstance().clientMode != ClientMode.CLASSIC) {
            this.currentConfigs.moduleConfig = Client.getInstance().moduleManager.loadCurrentConfig(new JsonObject());
            this.currentConfigs = config;
            Client.getInstance().config.addProperty("profile", config.profileName);
        } else {
            this.currentConfigs.moduleConfig = config.getDefaultConfig();
            Client.getInstance().config.addProperty("profile", "Classic");
        }
        Client.getInstance().moduleManager.load(config.moduleConfig);
        Client.getInstance().saveClientData();
    }

    public List<Profile> getAllConfigs() {
        return this.savedConfigs;
    }
}

