/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.managers.util.account.microsoft;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.event.impl.game.network.EventReceivePacket;
import com.mentalfrostbyte.jello.managers.util.account.microsoft.Account;
import com.mentalfrostbyte.jello.managers.util.account.microsoft.Ban;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.login.server.SDisconnectLoginPacket;
import net.minecraft.network.login.server.SLoginSuccessPacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SDisconnectPacket;
import team.sdhq.eventBus.annotations.EventTarget;

public class BanListener {
    public Minecraft mc = Minecraft.getInstance();

    @EventTarget
    public void onPacketReceive(EventReceivePacket event) {
        if (this.mc.getCurrentServerData() != null) {
            Ban ban;
            IPacket<?> account;
            Object banMessages;
            IPacket<IClientPlayNetHandler> packet;
            IPacket<?> iPacket = event.packet;
            if (iPacket instanceof SChatPacket) {
                packet = (SChatPacket)iPacket;
                banMessages = new ArrayList<String>(Arrays.asList("You are permanently banned from MinemenClub. ", "Your connection to the server leu-practice has been prevented due to you being associated to a blacklisted player.", "You are blacklisted from MinemenClub. "));
                if (!((SChatPacket)packet).getChatComponent().getSiblings().isEmpty() && ((ArrayList)banMessages).contains(((SChatPacket)packet).getChatComponent().getString()) && ((SChatPacket)packet).getChatComponent().getSiblings().get(0).getStyle().getColor().toString().equalsIgnoreCase("red") && (account = Client.getInstance().accountManager.containsAccount()) != null) {
                    ban = new Ban(this.mc.getCurrentServerData().serverIP, new Date(Long.MAX_VALUE));
                    ((Account)((Object)account)).registerBan(ban);
                    Client.getInstance().accountManager.updateAccount((Account)((Object)account));
                    Client.getInstance().accountManager.saveAlts();
                }
            }
            if (!((banMessages = event.packet) instanceof SDisconnectLoginPacket)) {
                account = event.packet;
                if (!(account instanceof SDisconnectPacket)) {
                    if (event.packet instanceof SLoginSuccessPacket) {
                        long currentTimeMillis = System.currentTimeMillis();
                        if (this.mc.getCurrentServerData() == null) {
                            return;
                        }
                        Ban ban2 = new Ban(this.mc.getCurrentServerData().serverIP, new Date(currentTimeMillis));
                        Account account2 = Client.getInstance().accountManager.containsAccount();
                        if (account2 != null) {
                            account2.registerBan(ban2);
                            Client.getInstance().accountManager.updateAccount(account2);
                            Client.getInstance().accountManager.saveAlts();
                        }
                    }
                } else {
                    SDisconnectPacket packet2 = (SDisconnectPacket)account;
                    long banDur = this.calculateBanDuration(packet2.getReason().getString());
                    if (banDur == 0L) {
                        return;
                    }
                    Ban ban3 = new Ban(this.mc.getCurrentServerData().serverIP, new Date(banDur));
                    Account account3 = Client.getInstance().accountManager.containsAccount();
                    if (account3 != null) {
                        account3.registerBan(ban3);
                        Client.getInstance().accountManager.updateAccount(account3);
                        Client.getInstance().accountManager.saveAlts();
                    }
                }
            } else {
                packet = (SDisconnectLoginPacket)banMessages;
                long banDur = this.calculateBanDuration(((SDisconnectLoginPacket)packet).getReason().getString());
                if (banDur == 0L) {
                    return;
                }
                ban = new Ban(this.mc.getCurrentServerData().serverIP, new Date(banDur));
                Account account4 = Client.getInstance().accountManager.containsAccount();
                if (account4 != null) {
                    account4.registerBan(ban);
                    Client.getInstance().accountManager.updateAccount(account4);
                    Client.getInstance().accountManager.saveAlts();
                }
            }
        }
    }

    private long calculateBanDuration(String message) {
        if ((message = message.toLowerCase()).contains("security") && message.contains("alert")) {
            return 0x7FFFFFFFFFFFFFFEL;
        }
        if (message.contains("permanent") || message.contains("your account has been suspended from") || message.contains("tu cuenta ha sido suspendida. al reconectarte, tendr") || message.contains("gebannt")) {
            return Long.MAX_VALUE;
        }
        if (message.contains("compromised")) {
            return 0x7FFFFFFFFFFFFFFEL;
        }
        long days = TimeUnit.DAYS.toMillis(this.extractDays(message));
        long hours = TimeUnit.HOURS.toMillis(this.extractHours(message));
        long minutes = TimeUnit.MINUTES.toMillis(this.extractMinutes(message));
        long seconds = TimeUnit.SECONDS.toMillis(this.extractSeconds(message));
        if (message.contains("vous avez \u00e9t\u00e9 banni") && days == 0L && hours == 0L && minutes == 0L && seconds == 0L) {
            return Long.MAX_VALUE;
        }
        return System.currentTimeMillis() + days + hours + minutes + seconds;
    }

    private int extractDays(String var1) {
        String[] dayKeywords;
        for (String keyword : dayKeywords = new String[]{"day", "jour", "tage", "d\u00eda", "dia"}) {
            Pattern pattern = Pattern.compile("([0-9]+)(?:d| " + keyword + "s|" + keyword + "s| " + keyword + "|" + keyword + ")[ |\\n]");
            Matcher matcher = pattern.matcher(var1);
            if (!matcher.find()) continue;
            return Integer.parseInt(matcher.group(1));
        }
        return 0;
    }

    private int extractHours(String input) {
        String[] hourKeywords;
        for (String keyword : hourKeywords = new String[]{"hour", "heure", "uhr", "hora"}) {
            Pattern pattern = Pattern.compile("([0-9]+)(?:h| " + keyword + "s|" + keyword + "s| " + keyword + "|" + keyword + ")[ |\\n]");
            Matcher matcher = pattern.matcher(input);
            if (!matcher.find()) continue;
            return Integer.parseInt(matcher.group(1));
        }
        return 0;
    }

    private int extractMinutes(String input) {
        String[] minuteKeywords;
        for (String keyword : minuteKeywords = new String[]{"minute", "min", "minuto", "m\u00ednuto"}) {
            Pattern pattern = Pattern.compile("([0-9]+)(?:m| " + keyword + "s|" + keyword + "s| " + keyword + "|" + keyword + ")[ |\\n]");
            Matcher matcher = pattern.matcher(input);
            if (!matcher.find()) continue;
            return Integer.parseInt(matcher.group(1));
        }
        return 0;
    }

    private int extractSeconds(String input) {
        String[] secondKeywords;
        for (String keyword : secondKeywords = new String[]{"second", "sec", "seconde", "sekunde", "segundo"}) {
            Pattern pattern = Pattern.compile("([0-9]+)(?:s| " + keyword + "s|" + keyword + "s| " + keyword + "|" + keyword + ")[ |\\n]");
            Matcher matcher = pattern.matcher(input);
            if (!matcher.find()) continue;
            return Integer.parseInt(matcher.group(1));
        }
        return 0;
    }
}

