/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.combat;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.event.impl.player.EventKeepSprint;
import com.mentalfrostbyte.jello.event.impl.player.EventRunLoop;
import com.mentalfrostbyte.jello.event.impl.player.EventUpdate;
import com.mentalfrostbyte.jello.event.impl.player.movement.EventMotion;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.impl.combat.killaura.ClickDelayCalculator;
import com.mentalfrostbyte.jello.module.impl.movement.BlockFly;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanSetting;
import com.mentalfrostbyte.jello.module.settings.impl.ModeSetting;
import com.mentalfrostbyte.jello.module.settings.impl.NumberSetting;
import com.mentalfrostbyte.jello.util.game.player.PlayerUtil;
import com.mentalfrostbyte.jello.util.game.player.constructor.Rotation;
import com.mentalfrostbyte.jello.util.game.player.rotation.util.RotationUtils;
import com.mentalfrostbyte.jello.util.game.world.EntityUtil;
import com.mentalfrostbyte.jello.util.system.math.counter.Counter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import team.sdhq.eventBus.annotations.EventTarget;
import team.sdhq.eventBus.annotations.priority.HighestPriority;

public class NewAura
extends Module {
    private final ModeSetting sortMode = new ModeSetting("Sort mode", "In what order should entities be sorted in?", 0, "Range", "Health", "Armor", "Ticks");
    private final ClickDelayCalculator delayCalculator = new ClickDelayCalculator(9.0, 11.0);
    private final ModeSetting clickMode = new ModeSetting("Click mode", "What should be the clicking mode?", 0, "CPS", "1.9");
    private final NumberSetting<Long> minCPS = new NumberSetting<Long>("Min CPS", "Minimal CPS?", 10.0f, 1.0f, 20.0f, 1.0f){

        @Override
        public boolean isHidden() {
            return NewAura.this.clickMode.getCurrentValue().equals("1.9");
        }
    };
    private final NumberSetting<Long> maxCPS = new NumberSetting<Long>("Max CPS", "Maximal CPS?", 11.0f, 2.0f, 21.0f, 1.0f){

        @Override
        public boolean isHidden() {
            return NewAura.this.clickMode.getCurrentValue().equals("1.9");
        }
    };
    private final BooleanSetting delayPatterns = new BooleanSetting("Delay patterns", "", false){

        @Override
        public boolean isHidden() {
            return NewAura.this.clickMode.getCurrentValue().equals("1.9");
        }
    };
    private final NumberSetting<Double> delayPattern1 = new NumberSetting<Double>("Delay pattern 1", "", 90.0f, 0.0f, 700.0f, 1.0f){

        @Override
        public boolean isHidden() {
            return NewAura.this.clickMode.getCurrentValue().equals("1.9") && NewAura.this.delayPatterns.getCurrentValue() != false;
        }
    };
    private final NumberSetting<Double> delayPattern2 = new NumberSetting<Double>("Delay pattern 2", "", 110.0f, 0.0f, 700.0f, 1.0f){

        @Override
        public boolean isHidden() {
            return NewAura.this.clickMode.getCurrentValue().equals("1.9") && NewAura.this.delayPatterns.getCurrentValue() != false;
        }
    };
    private final NumberSetting<Double> delayPattern3 = new NumberSetting<Double>("Delay pattern 3", "", 130.0f, 0.0f, 700.0f, 1.0f){

        @Override
        public boolean isHidden() {
            return NewAura.this.clickMode.getCurrentValue().equals("1.9") && NewAura.this.delayPatterns.getCurrentValue() != false;
        }
    };
    private final NumberSetting<Float> searchRange = new NumberSetting("Search range", "What should be the search range for entities?", 4.0f, 1.0f, 7.0f, 0.1f);
    private final NumberSetting<Float> attackRange = new NumberSetting("Attack range", "What should be the attack range for entities?", 3.4f, 1.0f, 6.0f, 0.1f);
    private final BooleanSetting players = new BooleanSetting("Players", "Should aura attack players?", true);
    private final BooleanSetting monsters = new BooleanSetting("Monsters", "Should aura target monsters?", false);
    private final BooleanSetting animals = new BooleanSetting("Animals", "Should aura target animals?", false);
    private final BooleanSetting invisibles = new BooleanSetting("Invisibles", "Should aura target invisible entities?", false);
    private final BooleanSetting throughWalls = new BooleanSetting("Through walls", "Should aura attack entities through walls?", false);
    private final BooleanSetting raycast = new BooleanSetting("Raycast", "Should aura raycast a line to each target?", true);
    private final BooleanSetting keepSprint = new BooleanSetting("Keep sprint", "Should aura keep sprinting while attacking?", false);
    private final BooleanSetting sprintFix = new BooleanSetting("Sprint fix", "Should sprint be fixed? (disables Keep sprint)", true);
    private final Counter attackCounter = new Counter();
    private LivingEntity target;
    private List<LivingEntity> targets = new ArrayList<LivingEntity>();
    private Rotation rots;

    public NewAura() {
        super(ModuleCategory.COMBAT, "NewAura", "Attacks entities.");
        this.minCPS.addObserver(a -> {
            NumberSetting setting = (NumberSetting)a;
            if (((Float)this.minCPS.getCurrentValue()).floatValue() >= ((Float)this.maxCPS.getCurrentValue()).floatValue()) {
                this.minCPS.setCurrentValue((Long)((Object)((Float)this.maxCPS.getCurrentValue())));
            }
            this.delayCalculator.minCPS = ((Float)setting.getCurrentValue()).floatValue();
        });
        this.maxCPS.addObserver(a -> {
            NumberSetting setting = (NumberSetting)a;
            if (((Float)this.maxCPS.getCurrentValue()).floatValue() <= ((Float)this.minCPS.getCurrentValue()).floatValue()) {
                this.maxCPS.setCurrentValue((Long)((Object)((Float)this.minCPS.getCurrentValue())));
            }
            this.delayCalculator.maxCPS = ((Float)setting.getCurrentValue()).floatValue();
        });
        this.delayPatterns.addObserver(a -> {
            this.delayCalculator.patternEnabled = (Boolean)a.currentValue;
        });
        this.delayPattern1.addObserver(a -> {
            NumberSetting setting = (NumberSetting)a;
            this.delayCalculator.delayPattern1 = ((Float)setting.getCurrentValue()).floatValue();
        });
        this.delayPattern2.addObserver(a -> {
            NumberSetting setting = (NumberSetting)a;
            this.delayCalculator.delayPattern2 = ((Float)setting.getCurrentValue()).floatValue();
        });
        this.delayPattern3.addObserver(a -> {
            NumberSetting setting = (NumberSetting)a;
            this.delayCalculator.delayPattern3 = ((Float)setting.getCurrentValue()).floatValue();
        });
        this.registerSetting(this.sortMode, this.clickMode, this.minCPS, this.maxCPS, this.delayPatterns, this.delayPattern1, this.delayPattern2, this.delayPattern3, this.searchRange, this.attackRange, this.players, this.monsters, this.animals, this.invisibles, this.throughWalls, this.raycast, this.keepSprint, this.sprintFix);
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.target = null;
        this.attackCounter.reset();
        this.rots = new Rotation(NewAura.mc.player.rotationYaw, NewAura.mc.player.rotationPitch);
    }

    @Override
    public void onDisable() {
        this.rots = null;
        this.target = null;
        this.attackCounter.reset();
    }

    @EventTarget
    @HighestPriority
    public void onUpdate(EventUpdate event) {
        if (Client.getInstance().moduleManager.getModuleByClass(BlockFly.class).enabled) {
            return;
        }
        if (this.target != null && (!this.target.isAlive() || this.target.getDistance(NewAura.mc.player) > ((Float)this.searchRange.getCurrentValue()).floatValue())) {
            this.target = null;
        }
        if (this.sprintFix.getCurrentValue().booleanValue() && this.target != null) {
            NewAura.mc.player.setSprinting(false);
        }
        this.targets.clear();
        for (Entity entity : PlayerUtil.getAllEntitiesInWorld()) {
            double distance;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            boolean valid = false;
            if (((Boolean)this.players.currentValue).booleanValue() && entity instanceof PlayerEntity) {
                valid = true;
            }
            if (((Boolean)this.animals.currentValue).booleanValue() && (entity instanceof AnimalEntity || entity instanceof VillagerEntity)) {
                valid = true;
            }
            if (((Boolean)this.monsters.currentValue).booleanValue() && entity instanceof MonsterEntity) {
                valid = true;
            }
            if (!valid || (distance = (double)NewAura.mc.player.getDistance(entity)) > (double)((Float)this.searchRange.currentValue).floatValue() || !living.isAlive() || entity == NewAura.mc.player || !((Boolean)this.invisibles.currentValue).booleanValue() && entity.isInvisible() || entity.getName() == null || entity.getDisplayName() == null || Client.getInstance().friendManager.isFriend(entity) || Client.getInstance().botManager.isBot(entity)) continue;
            this.targets.add(living);
        }
        if (!this.targets.isEmpty()) {
            this.targets.sort(EntityUtil.sortEntities((String)this.sortMode.currentValue));
            this.target = this.targets.get(0);
            Rotation calculatedRot = RotationUtils.getAdvancedRotation(this.target, (Boolean)this.raycast.currentValue == false);
            if (calculatedRot != null) {
                float yawDifference = MathHelper.wrapAngleTo180_float(calculatedRot.yaw - this.rots.yaw);
                float pitchDifference = calculatedRot.pitch - this.rots.pitch;
                float distanceFactor = (float)Math.pow(Math.min(1.0f, 3.0f / this.target.getDistance(NewAura.mc.player)), 1.3);
                float baseSpeed = 8.0f + distanceFactor * 7.0f;
                float randomFactor = 0.85f + (float)(Math.random() * (double)0.3f);
                if (Math.random() > 0.7) {
                    randomFactor *= 0.92f + (float)(Math.random() * (double)0.16f);
                }
                float yawSpeed = Math.min(baseSpeed * randomFactor, Math.abs(yawDifference) * (0.4f + (float)(Math.random() * (double)0.2f)));
                float pitchSpeed = Math.min(baseSpeed * 0.8f * randomFactor, Math.abs(pitchDifference) * (0.4f + (float)(Math.random() * (double)0.2f)));
                yawSpeed = Math.min(yawSpeed, 19.0f);
                pitchSpeed = Math.min(pitchSpeed, 19.0f);
                if (Math.abs(yawDifference) > 0.1f) {
                    float appliedYaw = Math.signum(yawDifference) * yawSpeed;
                    if (Math.random() > 0.8) {
                        appliedYaw *= 0.94f + (float)(Math.random() * (double)0.12f);
                    }
                    this.rots.yaw += appliedYaw;
                }
                if (Math.abs(pitchDifference) > 0.1f) {
                    float appliedPitch = Math.signum(pitchDifference) * pitchSpeed;
                    if (Math.random() > 0.8) {
                        appliedPitch *= 0.94f + (float)(Math.random() * (double)0.12f);
                    }
                    this.rots.pitch += appliedPitch;
                }
                this.rots.pitch = MathHelper.clamp(this.rots.pitch, -90.0f, 90.0f);
            }
        } else {
            this.target = null;
        }
    }

    @EventTarget
    @HighestPriority
    public void onMotion(EventMotion event) {
        if (Client.getInstance().moduleManager.getModuleByClass(BlockFly.class).enabled) {
            return;
        }
        if (this.target != null) {
            float[] fixedRotations = RotationUtils.gcdFix(new float[]{this.rots.yaw, this.rots.pitch}, new float[]{NewAura.mc.player.rotationYaw, NewAura.mc.player.rotationPitch});
            event.setYaw(fixedRotations[0]);
            event.setPitch(fixedRotations[1]);
        }
    }

    @EventTarget
    public void onSprint(EventKeepSprint event) {
        if (this.keepSprint.getCurrentValue().booleanValue()) {
            event.greater = false;
        }
    }

    @EventTarget
    @HighestPriority
    public void onRun(EventRunLoop event) {
        if (Client.getInstance().moduleManager.getModuleByClass(BlockFly.class).enabled) {
            return;
        }
        if (NewAura.mc.player == null) {
            return;
        }
        if (this.target != null && this.target.getDistance(NewAura.mc.player) <= ((Float)this.attackRange.currentValue).floatValue()) {
            if (((Boolean)this.throughWalls.currentValue).booleanValue() && !NewAura.mc.player.canEntityBeSeen(this.target)) {
                return;
            }
            switch ((String)this.clickMode.currentValue) {
                case "CPS": {
                    if (!this.attackCounter.hasElapsed(this.delayCalculator.getClickDelay(), true)) break;
                    this.attackEntity(this.target);
                    break;
                }
                case "1.9": {
                    if (!(NewAura.mc.player.getCooledAttackStrength(0.0f) >= 1.0f)) break;
                    this.attackEntity(this.target);
                }
            }
        }
    }

    private void attackEntity(LivingEntity entity) {
        NewAura.mc.player.swingArm(Hand.MAIN_HAND);
        NewAura.mc.playerController.attackEntity(NewAura.mc.player, entity);
    }
}

