/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.gui.jello;

import com.mentalfrostbyte.jello.event.impl.game.render.EventRender2DOffset;
import com.mentalfrostbyte.jello.event.impl.player.EventUpdate;
import com.mentalfrostbyte.jello.gui.base.animations.Animation;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.util.client.render.FontSizeAdjust;
import com.mentalfrostbyte.jello.util.client.render.ResourceRegistry;
import com.mentalfrostbyte.jello.util.client.render.theme.ClientColors;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil2;
import com.mentalfrostbyte.jello.util.system.math.smoothing.EasingFunctions;
import com.mentalfrostbyte.jello.util.system.math.smoothing.QuadraticEasing;
import org.lwjgl.opengl.GL11;
import team.sdhq.eventBus.annotations.EventTarget;
import team.sdhq.eventBus.annotations.priority.LowestPriority;

public class Coords
extends Module {
    private final Animation coordinateAnimation = new Animation(1500, 1500, Animation.Direction.BACKWARDS);
    private double playerX;
    private double playerY;
    private double playerZ;

    public Coords() {
        super(ModuleCategory.GUI, "Coords", "Displays coordinates");
    }

    @EventTarget
    public void onPlayerTick(EventUpdate event) {
        if (this.isEnabled()) {
            boolean shouldAnimate;
            boolean hasMoved = this.playerX != Coords.mc.player.getPosX() || this.playerY != Coords.mc.player.getPosY() || this.playerZ != Coords.mc.player.getPosZ();
            this.playerX = Coords.mc.player.getPosX();
            this.playerY = Coords.mc.player.getPosY();
            this.playerZ = Coords.mc.player.getPosZ();
            boolean bl = shouldAnimate = hasMoved || !Coords.mc.player.isOnGround() || Coords.mc.player.isSneaking();
            if (!shouldAnimate) {
                if (this.coordinateAnimation.calcPercent() == 1.0f && this.coordinateAnimation.getDirection() == Animation.Direction.FORWARDS) {
                    this.coordinateAnimation.changeDirection(Animation.Direction.BACKWARDS);
                }
            } else {
                this.coordinateAnimation.changeDirection(Animation.Direction.FORWARDS);
            }
        }
    }

    @EventTarget
    @LowestPriority
    public void onRender2D(EventRender2DOffset event) {
        if (this.isEnabled() && Coords.mc.player != null && !Coords.mc.gameSettings.showDebugInfo && !Coords.mc.gameSettings.hideGUI) {
            float animationScale = Math.min(1.0f, 0.6f + this.coordinateAnimation.calcPercent() * 2.0f);
            String coordinatesText = String.format("%.0f %.0f %.0f", Coords.mc.player.getPosX(), Coords.mc.player.getPosY(), Coords.mc.player.getPosZ());
            float textX = 85.0f;
            int textY = event.getYOffset();
            float maxTextWidth = 150.0f;
            float textWidth = ResourceRegistry.JelloLightFont18.getWidth(coordinatesText);
            float scaleFactor = Math.min(1.0f, maxTextWidth / textWidth);
            scaleFactor = this.coordinateAnimation.getDirection() != Animation.Direction.FORWARDS ? (scaleFactor *= 0.9f + QuadraticEasing.easeInQuad(Math.min(1.0f, this.coordinateAnimation.calcPercent() * 8.0f), 0.0f, 1.0f, 1.0f) * 0.1f) : (scaleFactor *= 0.9f + EasingFunctions.easeOutBack(Math.min(1.0f, this.coordinateAnimation.calcPercent() * 7.0f), 0.0f, 1.0f, 1.0f) * 0.1f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)textX, (float)(textY + 10), (float)0.0f);
            GL11.glScalef((float)scaleFactor, (float)scaleFactor, (float)1.0f);
            GL11.glTranslatef((float)(-textX), (float)(-textY - 10), (float)0.0f);
            RenderUtil.drawString(ResourceRegistry.JelloLightFont18_1, textX, textY, coordinatesText, RenderUtil2.applyAlpha(-16777216, 0.5f * animationScale), FontSizeAdjust.NEGATE_AND_DIVIDE_BY_2, FontSizeAdjust.field14488);
            RenderUtil.drawString(ResourceRegistry.JelloLightFont18, textX, textY, coordinatesText, RenderUtil2.applyAlpha(ClientColors.LIGHT_GREYISH_BLUE.getColor(), 0.8f * animationScale), FontSizeAdjust.NEGATE_AND_DIVIDE_BY_2, FontSizeAdjust.field14488);
            GL11.glPopMatrix();
        }
    }
}

