/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.misc;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.event.impl.player.EventUpdate;
import com.mentalfrostbyte.jello.managers.util.notifs.Notification;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.data.ModuleWithModuleSettings;
import com.mentalfrostbyte.jello.module.impl.misc.gameplay.CubecraftGamePlay;
import com.mentalfrostbyte.jello.module.impl.misc.gameplay.FuncraftGameplay;
import com.mentalfrostbyte.jello.module.impl.misc.gameplay.HypixelGamePlay;
import com.mentalfrostbyte.jello.module.impl.misc.gameplay.JartexGamePlay;
import com.mentalfrostbyte.jello.module.impl.misc.gameplay.MineplexGamePlay;
import com.mentalfrostbyte.jello.module.impl.misc.gameplay.MinibloxGamePlay;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanSetting;
import com.mentalfrostbyte.jello.module.settings.impl.InputSetting;
import com.mentalfrostbyte.jello.module.settings.impl.ModeSetting;
import com.mentalfrostbyte.jello.module.settings.impl.NumberSetting;
import com.mentalfrostbyte.jello.util.client.logger.TimedMessage;
import com.mentalfrostbyte.jello.util.client.spam.AutoLData;
import com.mentalfrostbyte.jello.util.game.MinecraftUtil;
import com.mentalfrostbyte.jello.util.system.math.counter.TimerUtil;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.gui.screen.ChatScreen;
import team.sdhq.eventBus.annotations.EventTarget;

public class GamePlay
extends ModuleWithModuleSettings {
    public ArrayList<String> autoLQueue = new ArrayList();
    public final ArrayList<String> autoLMessages = new ArrayList();
    public TimedMessage timedMessage;
    public final TimerUtil timer;
    public int seconds;

    public GamePlay() {
        super(ModuleCategory.MISC, "GamePlay", "Manage your gameplay experience just for you.", new HypixelGamePlay(), new CubecraftGamePlay(), new MineplexGamePlay(), new MinibloxGamePlay(), new FuncraftGameplay(), new JartexGamePlay());
        this.registerSetting((Setting)new BooleanSetting("AutoL", "Automatically says L when you kill a player", true));
        this.registerSetting(new ModeSetting("AutoL Mode", "AutoL Mode", 0, "Basic", "Miniblox", "Sigmeme", "Penshen").addObserver(var1 -> this.autoLQueue.clear()));
        this.registerSetting((Setting)new InputSetting("First character", "The characters your sentences will start with.", ""));
        this.registerSetting((Setting)new BooleanSetting("AutoGG", "Automatically say gg at the end of the game", true));
        this.registerSetting((Setting)new BooleanSetting("Auto Join", "Automatically joins another game", true));
        this.registerSetting((Setting)new NumberSetting("Auto Join delay", "Seconds before joining a new game", 4.0f, 1.0f, 10.0f, 1.0f));
        this.timer = new TimerUtil();
    }

    @Override
    public void onEnable() {
        if (!this.timer.isEnabled()) {
            this.timer.start();
        }
        this.timedMessage = null;
        this.autoLQueue.clear();
        this.autoLMessages.clear();
    }

    @Override
    public void onDisable() {
        this.timer.reset();
        this.timer.stop();
        this.timedMessage = null;
    }

    @EventTarget
    public void onTick(EventUpdate event) {
        if (this.isEnabled()) {
            if (this.timedMessage != null) {
                if (GamePlay.mc.currentScreen instanceof ChatScreen) {
                    this.updateTimedMessage(null);
                    Client.getInstance().notificationManager.send(new Notification("Auto Join", "Auto join was canceled.", 2500));
                } else if (this.timedMessage.hasExpired()) {
                    MinecraftUtil.sendChatMessage(this.timedMessage.getMessage());
                    this.updateTimedMessage(null);
                } else if ((int)(this.timedMessage.getRemainingTime() / 1000L) + 1 < this.seconds) {
                    this.seconds = (int)(this.timedMessage.getRemainingTime() / 1000L) + 1;
                    Client.getInstance().notificationManager.send(new Notification("Auto Join", "Joining a new game in " + this.seconds + " second" + (this.seconds > 1 ? "s" : "") + ".", 2000));
                }
            }
            if (!this.timer.isEnabled()) {
                this.timer.start();
            }
            if (!this.autoLMessages.isEmpty()) {
                String type = this.getStringSettingValueByName("Type");
                if (GamePlay.mc.player.ticksExisted <= 3) {
                    this.autoLMessages.clear();
                }
                long var5 = 3200L;
                if (!type.equalsIgnoreCase("Hypixel")) {
                    var5 = 0L;
                }
                if (type.equalsIgnoreCase("Mineplex")) {
                    var5 = 300L;
                }
                if (type.equalsIgnoreCase("Funcraft")) {
                    var5 = 1000L;
                }
                if (type.equalsIgnoreCase("Jartex")) {
                    var5 = 3200L;
                }
                if (this.timer.getElapsedTime() > var5 && !this.autoLMessages.isEmpty()) {
                    this.timer.reset();
                    String message = this.autoLMessages.get(0);
                    MinecraftUtil.sendChatMessage(message);
                    this.autoLMessages.remove(0);
                }
            }
        }
    }

    public void updateTimedMessage(TimedMessage timedMessage) {
        this.timedMessage = timedMessage;
        if (timedMessage != null) {
            this.seconds = (int)(timedMessage.getRemainingTime() / 1000L) + 1;
        }
    }

    public void initializeAutoL() {
        this.autoLMessages.add("gg");
    }

    public void processAutoLMessage(String input) {
        String[] parts = input.split(" ");
        String playerName = parts[0];
        String serverType = this.getStringSettingValueByName("Type");
        if ("Mineplex".equals(serverType) || "Funcraft".equals(serverType)) {
            playerName = parts[1];
        }
        switch (this.getStringSettingValueByName("AutoL Mode")) {
            case "Basic": {
                this.autoLMessages.add(this.getStringSettingValueByName("First character") + "L " + playerName);
                break;
            }
            case "Sigmeme": 
            case "Miniblox": 
            case "Penshen": {
                if (this.autoLQueue.isEmpty()) {
                    switch (this.getStringSettingValueByName("AutoL Mode")) {
                        case "Sigmeme": {
                            this.autoLQueue = new ArrayList<String>(AutoLData.SIGMEME_QUOTES);
                            break;
                        }
                        case "Miniblox": {
                            this.autoLQueue = new ArrayList<String>(AutoLData.MINIBLOX_QUOTES);
                            break;
                        }
                        case "Penshen": {
                            this.autoLQueue = new ArrayList<String>(AutoLData.PENSHEN_QUOTES);
                        }
                    }
                    Collections.shuffle(this.autoLQueue);
                }
                Object autoLMessage = this.autoLQueue.get(0);
                if ("Cubecraft".equals(serverType)) {
                    autoLMessage = ((String)autoLMessage).replaceAll("sigma", "\uff33\uff29\uff27\uff2d\uff21").replaceAll("Sigma", "\uff33\uff29\uff27\uff2d\uff21");
                }
                if ("Miniblox".equals(serverType)) {
                    autoLMessage = ((String)autoLMessage).replaceAll("suck", "s\u200buck");
                }
                autoLMessage = this.getStringSettingValueByName("First character") + (String)autoLMessage;
                this.autoLMessages.add((String)autoLMessage);
                this.autoLQueue.remove(0);
            }
        }
    }
}

