/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.misc.gameplay;

import com.mentalfrostbyte.jello.event.impl.game.network.EventReceivePacket;
import com.mentalfrostbyte.jello.event.impl.game.world.EventLoadWorld;
import com.mentalfrostbyte.jello.event.impl.player.LivingDeathEvent;
import com.mentalfrostbyte.jello.event.impl.player.movement.EventMotion;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.impl.misc.GamePlay;
import com.mentalfrostbyte.jello.module.impl.misc.gameplay.miniblox.AutoBuy;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanSetting;
import com.mentalfrostbyte.jello.module.settings.impl.InputSetting;
import com.mentalfrostbyte.jello.module.settings.impl.ModeSetting;
import com.mentalfrostbyte.jello.util.client.logger.TimedMessage;
import com.mentalfrostbyte.jello.util.game.MinecraftUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.event.ClickEvent;
import team.sdhq.eventBus.annotations.EventTarget;

public class MinibloxGamePlay
extends Module {
    private final ModeSetting autoVoteMode;
    private final BooleanSetting autoVote;
    private final BooleanSetting autoBuy;
    private final BooleanSetting oldTranslationLayerCompat;
    private final InputSetting username;
    private final BooleanSetting useCustomUsername;
    private GamePlay parentModule;

    public MinibloxGamePlay() {
        super(ModuleCategory.MISC, "Miniblox", "Gameplay for Miniblox");
        this.registerSetting((Setting)new BooleanSetting("FriendAccept", "Automatically accept friend requests", false));
        this.autoVote = new BooleanSetting("AutoVote", "Automatically vote on the skywars gamemode poll", true);
        this.registerSetting((Setting)this.autoVote);
        this.oldTranslationLayerCompat = new BooleanSetting("Compatibility", "Makes GamePlay compatible with the archived Miniblox Translation Layer by 7GrandDadPGN", false);
        this.registerSetting((Setting)this.oldTranslationLayerCompat);
        this.useCustomUsername = new BooleanSetting("Use custom username", "Check this custom username instead of your session/Minecraft account's username?", false);
        this.registerSetting((Setting)this.useCustomUsername);
        this.username = new InputSetting("Username (if custom username enabled)", "Your Miniblox username", "");
        this.registerSetting((Setting)this.username);
        this.autoVoteMode = new ModeSetting("Mode", "Mode to vote on Skywars", "Insane (2)", "Normal (1)", "Insane (2)");
        this.registerSetting((Setting)this.autoVoteMode);
        this.autoBuy = new BooleanSetting("AutoBuy", "Automatically buys stuff", false);
        this.registerSetting((Setting)this.autoBuy);
        this.registerSetting(AutoBuy.armor, AutoBuy.chainmailArmor, AutoBuy.ironArmor, AutoBuy.diamondArmor);
        this.registerSetting(AutoBuy.sword, AutoBuy.stoneSword, AutoBuy.ironSword, AutoBuy.diamondSword);
        this.registerSetting(AutoBuy.doUpgrades, AutoBuy.sharpnessUpgrade, AutoBuy.protectionUpgrade, AutoBuy.hasteUpgrade, AutoBuy.healPoolUpgrade, AutoBuy.forgeUpgrade);
    }

    @Override
    public void initialize() {
        this.parentModule = (GamePlay)this.access();
    }

    @EventTarget
    public void onWorldEvent(EventLoadWorld e) {
        if (!((Boolean)this.autoBuy.currentValue).booleanValue()) {
            return;
        }
        AutoBuy.onWorldEvent(e);
    }

    @EventTarget
    public void onUpdateEvent(EventMotion e) {
        if (!((Boolean)this.autoBuy.currentValue).booleanValue()) {
            return;
        }
        AutoBuy.onUpdateEvent(e);
    }

    @EventTarget
    public void onLivingDeath(LivingDeathEvent e) {
        if (!((Boolean)this.autoBuy.currentValue).booleanValue()) {
            return;
        }
        AutoBuy.onLivingDeathEvent(e);
    }

    @EventTarget
    public void onReceive(EventReceivePacket event) {
        IPacket<?> packet;
        if (MinibloxGamePlay.mc.player != null && (packet = event.packet) instanceof SChatPacket) {
            ClickEvent clickEvent;
            String lowerCaseText;
            SChatPacket chatPacket = (SChatPacket)packet;
            String text = chatPacket.getChatComponent().getString().replaceAll("\u00a7.", "");
            if (((Boolean)this.oldTranslationLayerCompat.currentValue).booleanValue() && chatPacket.getType() != ChatType.SYSTEM) {
                return;
            }
            String playerName = ((Boolean)this.useCustomUsername.currentValue != false ? (String)this.username.currentValue : MinibloxGamePlay.mc.player.getName().getString()).toLowerCase();
            if (((Boolean)this.autoVote.currentValue).booleanValue() && text.equals("Poll started: Choose a gamemode")) {
                switch ((String)this.autoVoteMode.currentValue) {
                    case "Normal (1)": {
                        MinecraftUtil.sendChatMessage("/vote 1");
                        break;
                    }
                    case "Insane (2)": {
                        MinecraftUtil.sendChatMessage("/vote 2");
                    }
                }
            }
            if (this.parentModule.getBooleanValueFromSettingName("AutoL") && ((lowerCaseText = text.toLowerCase()).contains("was slain by " + playerName) || lowerCaseText.contains("has been eliminated by") && lowerCaseText.endsWith(playerName + "!") || lowerCaseText.contains("burned to death while fighting " + playerName) || lowerCaseText.contains("was shot by " + playerName) || lowerCaseText.contains("burnt to a crisp while fighting " + playerName) || lowerCaseText.contains("couldn't fly while escaping " + playerName) || lowerCaseText.contains("thought they could survive in the void while escaping " + playerName) || lowerCaseText.contains("fell to their death while escaping " + playerName) || lowerCaseText.contains("died in the void while escaping " + playerName))) {
                this.parentModule.processAutoLMessage(text);
            }
            if (this.getBooleanValueFromSettingName("FriendAccept") && text.contains("[ACCEPT] - [DENY] - [IGNORE]")) {
                for (ITextComponent textCom : chatPacket.getChatComponent().getSiblings()) {
                    clickEvent = textCom.getStyle().getClickEvent();
                    if (clickEvent == null || clickEvent.getAction() != ClickEvent.Action.RUN_COMMAND || !clickEvent.getValue().contains("/f accept")) continue;
                    MinecraftUtil.sendChatMessage(clickEvent.getValue());
                }
            }
            if (!text.contains("The game is currently in progress. Please wait for the next game to start.") || this.parentModule.getBooleanValueFromSettingName("Auto Join")) {
                // empty if block
            }
            if (text.contains("Click here to play again")) {
                if (this.parentModule.getBooleanValueFromSettingName("Auto Join")) {
                    for (ITextComponent textCom : chatPacket.getChatComponent().getSiblings()) {
                        clickEvent = textCom.getStyle().getClickEvent();
                        if (clickEvent == null || clickEvent.getAction() != ClickEvent.Action.RUN_COMMAND) continue;
                        this.parentModule.updateTimedMessage(new TimedMessage(clickEvent.getValue(), (long)this.parentModule.getNumberValueBySettingName("Auto Join delay") * 1000L));
                    }
                }
                if (this.parentModule.getBooleanValueFromSettingName("AutoGG")) {
                    this.parentModule.initializeAutoL();
                }
            }
        }
    }
}

