/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.render;

import com.mentalfrostbyte.jello.event.impl.game.network.EventReceivePacket;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRender3D;
import com.mentalfrostbyte.jello.event.impl.game.world.EventLoadWorld;
import com.mentalfrostbyte.jello.event.impl.player.EventUpdate;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.impl.render.search.ChunkRegion;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanListSetting;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanSetting;
import com.mentalfrostbyte.jello.module.settings.impl.ColorSetting;
import com.mentalfrostbyte.jello.module.settings.impl.NumberSetting;
import com.mentalfrostbyte.jello.util.client.render.theme.ClientColors;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mentalfrostbyte.jello.util.game.world.BoundingBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SMultiBlockChangePacket;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import team.sdhq.eventBus.annotations.EventTarget;

public class Search
extends Module {
    private final BooleanSetting showHolesSetting;
    private final NumberSetting<Integer> tickDelay;
    private final NumberSetting<Float> chunkRangeSetting;
    private final BooleanListSetting blocksToRenderSetting;
    private final ColorSetting renderColorSetting;
    private final List<ChunkRegion> chunkRegions = new ArrayList<ChunkRegion>();
    private final Set<ChunkPos> processedChunks = new HashSet<ChunkPos>();
    private int tickCounter = 0;
    private final ExecutorService executorService = Executors.newFixedThreadPool(4);

    public Search() {
        super(ModuleCategory.RENDER, "Search", "Searches blocks through the world");
        this.chunkRangeSetting = new NumberSetting("Chunk Range", "Range at which search scans blocks", 5.0f, 1.0f, 12.0f, 1.0f);
        this.registerSetting((Setting)this.chunkRangeSetting);
        this.tickDelay = new NumberSetting("Tick Delay", "Delay between each refresh (greatly increases performance)", 50.0f, 0.0f, 500.0f, 50.0f);
        this.registerSetting((Setting)this.tickDelay);
        this.showHolesSetting = new BooleanSetting("Holes", "Shows 1x1 explosion protection holes", false);
        this.registerSetting((Setting)this.showHolesSetting);
        this.renderColorSetting = new ColorSetting("Color", "The rendered block color", ClientColors.MID_GREY.getColor(), true);
        this.registerSetting((Setting)this.renderColorSetting);
        this.blocksToRenderSetting = new BooleanListSetting("Blocks", "Blocks to render", true, new String[0]);
        this.registerSetting((Setting)this.blocksToRenderSetting);
        this.blocksToRenderSetting.addObserver(event -> this.chunkRegions.clear());
        this.chunkRangeSetting.addObserver(event -> this.chunkRegions.clear());
        this.showHolesSetting.addObserver(event -> this.chunkRegions.clear());
    }

    @EventTarget
    public void onPacketReceive(EventReceivePacket event) {
        if (this.isEnabled()) {
            IPacket<IClientPlayNetHandler> packet;
            IPacket<?> iPacket = event.packet;
            if (iPacket instanceof SChangeBlockPacket) {
                packet = (SChangeBlockPacket)iPacket;
                this.updateChunkPosition(Search.mc.world.getChunkAt(((SChangeBlockPacket)packet).getPos()).getPos());
            }
            if ((iPacket = event.packet) instanceof SMultiBlockChangePacket) {
                packet = (SMultiBlockChangePacket)iPacket;
                this.updateChunkPosition(new ChunkPos(((SMultiBlockChangePacket)packet).getSectionPos().x, ((SMultiBlockChangePacket)packet).getSectionPos().z));
            }
            if ((iPacket = event.packet) instanceof SChunkDataPacket) {
                packet = (SChunkDataPacket)iPacket;
                if (Minecraft.getInstance().world != null) {
                    this.updateChunkPosition(new ChunkPos(((SChunkDataPacket)packet).getChunkX(), ((SChunkDataPacket)packet).getChunkZ()));
                }
            }
        }
    }

    public void updateChunkPosition(ChunkPos chunkPos) {
        for (ChunkRegion region : this.chunkRegions) {
            if (!region.isSameChunk(chunkPos)) continue;
            this.processedChunks.add(region.getChunkPosition());
        }
    }

    @EventTarget
    public void onWorldLoad(EventLoadWorld event) {
        this.chunkRegions.clear();
        this.processedChunks.clear();
    }

    public List<BlockPos> getBlocksInChunk(ChunkPos chunkPos) {
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        int chunkStartX = chunkPos.x * 16;
        int chunkStartZ = chunkPos.z * 16;
        int chunkEndX = chunkStartX + 15;
        int chunkEndZ = chunkStartZ + 15;
        Chunk chunk = Search.mc.world.getChunk(chunkPos.x, chunkPos.z);
        for (int x = chunkStartX; x <= chunkEndX; ++x) {
            for (int z = chunkStartZ; z <= chunkEndZ; ++z) {
                int height = chunk.getHeightmap(Heightmap.Type.WORLD_SURFACE).getHeight(x - chunk.getPos().getXStart(), z - chunk.getPos().getZStart());
                for (int y = -64; y <= height; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (Search.mc.world == null || Search.mc.world.getBlockState(pos).isAir()) continue;
                    blockPositions.add(pos);
                }
            }
        }
        return blockPositions;
    }

    public List<BlockPos> getFilteredBlocksInChunk(ChunkPos chunkPos) {
        if (chunkPos == null) {
            return Collections.emptyList();
        }
        List<BlockPos> blocksInChunk = this.getBlocksInChunk(chunkPos);
        HashSet blocksToRender = new HashSet((Collection)this.blocksToRenderSetting.currentValue);
        ArrayList<BlockPos> filteredPositions = new ArrayList<BlockPos>();
        for (BlockPos pos : blocksInChunk) {
            String blockName = Registry.BLOCK.getKey(Search.mc.world.getBlockState(pos).getBlock()).toString();
            if (!blocksToRender.contains(blockName)) continue;
            filteredPositions.add(pos);
        }
        if (((Boolean)this.showHolesSetting.currentValue).booleanValue()) {
            for (BlockPos pos : blocksInChunk) {
                if (!Search.mc.world.getBlockState(pos).isAir()) continue;
                boolean isProtected = true;
                for (Direction direction : Direction.values()) {
                    Block block;
                    if (direction == Direction.UP || (block = Search.mc.world.getBlockState(pos.offset(direction)).getBlock()) == Blocks.OBSIDIAN || block == Blocks.BEDROCK) continue;
                    isProtected = false;
                    break;
                }
                if (!isProtected) continue;
                filteredPositions.add(pos.down());
            }
        }
        return filteredPositions;
    }

    @EventTarget
    public void onPlayerTick(EventUpdate event) {
        if (!this.isEnabled()) {
            return;
        }
        if (Search.mc.player.ticksExisted < 20) {
            this.chunkRegions.clear();
            return;
        }
        ++this.tickCounter;
        if ((float)this.tickCounter % ((Float)this.tickDelay.currentValue).floatValue() != 0.0f) {
            return;
        }
        Set<ChunkPos> nearbyChunks = this.getNearbyChunks();
        Iterator<ChunkRegion> iterator = this.chunkRegions.iterator();
        while (iterator.hasNext()) {
            ChunkRegion region = iterator.next();
            if (nearbyChunks.contains(region.getChunkPosition())) continue;
            iterator.remove();
        }
        for (ChunkPos chunkPos : nearbyChunks) {
            if (this.processedChunks.contains(chunkPos)) continue;
            this.executorService.submit(() -> {
                List<BlockPos> filteredBlocks = this.getFilteredBlocksInChunk(chunkPos);
                if (!filteredBlocks.isEmpty()) {
                    List<ChunkRegion> list = this.chunkRegions;
                    synchronized (list) {
                        this.chunkRegions.add(new ChunkRegion(chunkPos.x, chunkPos.z, filteredBlocks));
                    }
                }
            });
        }
    }

    @NotNull
    private Set<ChunkPos> getNearbyChunks() {
        int chunkRange = ((Float)this.chunkRangeSetting.currentValue).intValue();
        ChunkPos playerChunk = new ChunkPos(Search.mc.player.chunkCoordX, Search.mc.player.chunkCoordZ);
        HashSet<ChunkPos> nearbyChunks = new HashSet<ChunkPos>();
        for (int xOffset = -chunkRange; xOffset <= chunkRange; ++xOffset) {
            for (int zOffset = -chunkRange; zOffset <= chunkRange; ++zOffset) {
                ChunkPos chunkPos = new ChunkPos(playerChunk.x + xOffset, playerChunk.z + zOffset);
                nearbyChunks.add(chunkPos);
            }
        }
        return nearbyChunks;
    }

    @Override
    public void onEnable() {
        this.chunkRegions.clear();
        this.processedChunks.clear();
    }

    @EventTarget
    public void onRender3D(EventRender3D event) {
        if (this.isEnabled()) {
            this.renderChunkRegions();
        }
    }

    public void renderChunkRegions() {
        int color = RenderUtil.applyAlpha((Integer)this.renderColorSetting.currentValue, 0.14f);
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        for (ChunkRegion region : this.chunkRegions) {
            for (BlockPos pos : region.blockPositions) {
                double offsetX = (double)pos.getX() - Search.mc.gameRenderer.getActiveRenderInfo().getPos().getX();
                double offsetY = (double)pos.getY() - Search.mc.gameRenderer.getActiveRenderInfo().getPos().getY();
                double offsetZ = (double)pos.getZ() - Search.mc.gameRenderer.getActiveRenderInfo().getPos().getZ();
                BoundingBox boundingBox = new BoundingBox(offsetX, offsetY, offsetZ, offsetX + 1.0, offsetY + 1.0, offsetZ + 1.0);
                RenderUtil.renderWireframeBox(boundingBox, color);
            }
        }
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }
}

