/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.render.jello.nametags;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.module.impl.render.jello.nametags.RecipeReloadListener;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.AirItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.profiler.EmptyProfiler;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.Util;

public class FurnaceTracker {
    public int windowId;
    public float smeltProgress;
    public float smeltTime;
    public int cooldown;
    public int smeltDelay;
    public ItemStack inputStack;
    public ItemStack fuelStack;
    public ItemStack outputStack;

    public FurnaceTracker(int windowId) {
        this.windowId = windowId;
    }

    public void updateSmelting() {
        boolean canSmelt;
        this.refreshOutput();
        boolean hasFuel = this.fuelStack != null && this.fuelStack.count > 0;
        boolean hasInput = this.inputStack != null && this.inputStack.count > 0;
        boolean bl = canSmelt = this.getSmeltingResult() != null && this.getSmeltingResult().equals(this.outputStack.getItem()) && this.outputStack != null && this.outputStack.count < 64;
        if (this.smeltTime < this.smeltProgress && hasInput && canSmelt && this.smeltDelay > 0) {
            this.smeltTime += Client.getInstance().playerTracker.getPing();
        }
        if (this.smeltDelay > 0) {
            --this.smeltDelay;
        }
        if (this.smeltDelay == 0) {
            if (hasFuel && hasInput) {
                --this.fuelStack.count;
                this.smeltDelay = this.cooldown;
            } else {
                this.smeltTime = 0.0f;
            }
        }
        if (this.smeltTime >= this.smeltProgress && this.smeltProgress != 0.0f) {
            if (hasInput) {
                --this.inputStack.count;
            }
            this.smeltTime = 0.0f;
            if (this.outputStack != null) {
                ItemStack result = this.getSmeltingResultStack();
                this.outputStack.count += result.count;
            }
        }
        if (this.inputStack != null && this.inputStack.count == 0) {
            this.inputStack = null;
        }
    }

    public ItemStack getSmeltingResultStack() {
        ItemStack result;
        Optional<FurnaceRecipe> recipe;
        if (this.inputStack == null) {
            return null;
        }
        if (!Minecraft.getInstance().getConnection().getRecipeManager().getRecipes(IRecipeType.SMELTING, new Inventory(new ItemStack(Items.COBBLESTONE)), Minecraft.getInstance().world).isEmpty()) {
            SimpleReloadableResourceManager resourceManager = new SimpleReloadableResourceManager(ResourcePackType.SERVER_DATA);
            for (IResourcePack pack : Minecraft.getInstance().getResourcePackList().getEnabledPacks().stream().map(ResourcePackInfo::getResourcePack).collect(Collectors.toList())) {
                resourceManager.addResourcePack(pack);
            }
            Minecraft.getInstance().getConnection().getRecipeManager().reload(new RecipeReloadListener(this), resourceManager, EmptyProfiler.INSTANCE, EmptyProfiler.INSTANCE, Util.getServerExecutor(), Minecraft.getInstance());
        }
        if ((recipe = Minecraft.getInstance().getConnection().getRecipeManager().getRecipe(IRecipeType.SMELTING, new Inventory(this.inputStack), Minecraft.getInstance().world)).isPresent() && !(result = recipe.get().getRecipeOutput()).isEmpty()) {
            return result.copy();
        }
        return null;
    }

    public Item getSmeltingResult() {
        ItemStack resultStack = this.getSmeltingResultStack();
        return resultStack == null ? null : resultStack.getItem();
    }

    public ItemStack refreshOutput() {
        if (this.outputStack != null && this.outputStack.getItem() instanceof AirItem) {
            this.outputStack = null;
        }
        if (this.inputStack != null && this.inputStack.getItem() instanceof AirItem) {
            this.inputStack = null;
        }
        if (this.fuelStack != null && this.fuelStack.getItem() instanceof AirItem) {
            this.fuelStack = null;
        }
        if (this.outputStack == null) {
            if (this.inputStack != null) {
                ItemStack result = this.getSmeltingResultStack();
                if (result != null) {
                    result.count = 0;
                }
                this.outputStack = result;
                return this.outputStack;
            }
            return null;
        }
        return this.outputStack;
    }
}

