/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.world;

import com.mentalfrostbyte.jello.event.impl.game.network.EventReceivePacket;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRender3D;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.util.client.render.theme.ClientColors;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mentalfrostbyte.jello.util.game.world.BoundingBox;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.util.math.ChunkPos;
import org.lwjgl.opengl.GL11;
import team.sdhq.eventBus.annotations.EventTarget;

public class NewChunks
extends Module {
    private final ArrayList<ChunkPos> newChunks = new ArrayList();
    private final ArrayList<ChunkPos> updatedChunks = new ArrayList();

    public NewChunks() {
        super(ModuleCategory.WORLD, "NewChunks", "Detects new chunks on non vanilla servers");
    }

    @EventTarget
    public void onReceivePacket(EventReceivePacket event) {
        IPacket<?> iPacket;
        if (this.isEnabled() && (iPacket = event.packet) instanceof SChunkDataPacket) {
            SChunkDataPacket packet = (SChunkDataPacket)iPacket;
            ChunkPos chunkPos = new ChunkPos(packet.getChunkX(), packet.getChunkZ());
            if (!packet.isFullChunk()) {
                this.updatedChunks.add(chunkPos);
            }
        }
    }

    @EventTarget
    public void onRender3D(EventRender3D event) {
        if (this.isEnabled()) {
            ChunkPos chunkPos;
            Iterator<ChunkPos> iterator = this.updatedChunks.iterator();
            while (iterator.hasNext()) {
                chunkPos = iterator.next();
                if (!this.newChunks.contains(chunkPos)) {
                    this.newChunks.add(chunkPos);
                }
                iterator.remove();
            }
            Iterator<ChunkPos> chunkIterator = this.newChunks.iterator();
            while (chunkIterator.hasNext()) {
                chunkPos = chunkIterator.next();
                if (chunkPos == null) continue;
                double x = (double)chunkPos.x - NewChunks.mc.gameRenderer.getActiveRenderInfo().getPos().getX();
                double z = (double)chunkPos.z - NewChunks.mc.gameRenderer.getActiveRenderInfo().getPos().getZ();
                double y = -NewChunks.mc.gameRenderer.getActiveRenderInfo().getPos().getY();
                GL11.glDisable((int)2929);
                BoundingBox box = new BoundingBox(x, y, z, x + 16.0, y + 16.0, z + 16.0);
                RenderUtil.render3DColoredBox(box, RenderUtil.applyAlpha(ClientColors.PALE_ORANGE.getColor(), 0.1f));
                RenderUtil.renderWireframeBox(box, RenderUtil.applyAlpha(ClientColors.PALE_ORANGE.getColor(), 0.1f));
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)2929);
                int dx = NewChunks.mc.player.chunkCoordX - chunkPos.x;
                int dz = NewChunks.mc.player.chunkCoordZ - chunkPos.z;
                double distance = Math.sqrt(dx * dx + dz * dz);
                if (!(distance > 30.0)) continue;
                chunkIterator.remove();
            }
        }
    }

    @Override
    public void onDisable() {
        this.updatedChunks.clear();
        this.newChunks.clear();
    }
}

