/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.world;

import com.mentalfrostbyte.jello.event.impl.game.action.EventKeyPress;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRender3D;
import com.mentalfrostbyte.jello.event.impl.player.movement.EventMotion;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanListSetting;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanSetting;
import com.mentalfrostbyte.jello.module.settings.impl.ColorSetting;
import com.mentalfrostbyte.jello.module.settings.impl.ModeSetting;
import com.mentalfrostbyte.jello.module.settings.impl.NumberSetting;
import com.mentalfrostbyte.jello.util.client.render.theme.ClientColors;
import com.mentalfrostbyte.jello.util.game.player.combat.RotationUtil;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mentalfrostbyte.jello.util.game.world.BoundingBox;
import com.mentalfrostbyte.jello.util.game.world.blocks.BlockUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.DragonEggBlock;
import net.minecraft.network.play.client.CAnimateHandPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import org.lwjgl.opengl.GL11;
import team.sdhq.eventBus.EventBus;
import team.sdhq.eventBus.annotations.EventTarget;

public class Nuker
extends Module {
    public BlockPos targetPos;
    public List<BlockPos> blocksToDestroy;

    public Nuker() {
        super(ModuleCategory.WORLD, "Nuker", "Destroys blocks around you");
        this.registerSetting((Setting)new NumberSetting("Range", "Range value for nuker", 6.0f, 2.0f, 10.0f, 1.0f));
        this.registerSetting((Setting)new ModeSetting("Mode", "Mode", 0, "All", "One hit", "Bed", "Egg"));
        this.registerSetting((Setting)new BooleanSetting("NoSwing", "Removes the swing animation.", false));
        this.registerSetting((Setting)new BooleanListSetting("Blocks", "Blocks to destroy", true, new String[0]));
        this.registerSetting((Setting)new ColorSetting("Color", "The rendered block color", ClientColors.MID_GREY.getColor(), true));
    }

    public static void destroyBlock(BlockPos block) {
        mc.getConnection().sendPacket(new CPlayerDiggingPacket(CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, block, Direction.UP));
        mc.getConnection().sendPacket(new CPlayerDiggingPacket(CPlayerDiggingPacket.Action.STOP_DESTROY_BLOCK, block, Direction.UP));
        Nuker.mc.world.setBlockState(block, Blocks.AIR.getDefaultState());
    }

    @EventTarget
    public void onUpdate(EventMotion event) {
        if (this.isEnabled() && event.isPre()) {
            this.blocksToDestroy = this.getBlocksToDestroy(this.getNumberValueBySettingName("Range") / 2.0f);
            if (this.blocksToDestroy.isEmpty()) {
                this.targetPos = null;
            } else if (Nuker.mc.playerController.getCurrentGameType() != GameType.CREATIVE) {
                if (this.targetPos != null) {
                    if (Nuker.mc.world.getBlockState(this.targetPos).isAir() || Math.sqrt(Nuker.mc.player.getDistanceSq((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY() + 0.5, (double)this.targetPos.getZ() + 0.5)) > 6.0) {
                        this.targetPos = this.blocksToDestroy.get(0);
                    }
                    float[] rotations = RotationUtil.rotationToPos(this.targetPos.getX(), this.targetPos.getZ(), this.targetPos.getY());
                    event.setYaw(rotations[0]);
                    event.setPitch(rotations[1]);
                    EventKeyPress keyPress = new EventKeyPress(0, false, this.targetPos);
                    EventBus.call(keyPress);
                } else {
                    this.targetPos = this.blocksToDestroy.get(0);
                    float[] var6 = RotationUtil.rotationToPos((double)this.targetPos.getX() + 0.5, this.targetPos.getZ(), (double)this.targetPos.getY() + 0.5);
                    event.setYaw(var6[0]);
                    event.setPitch(var6[1]);
                    EventKeyPress keyPress = new EventKeyPress(0, false, this.targetPos);
                    EventBus.call(keyPress);
                }
                Nuker.mc.playerController.onPlayerDamageBlock(this.targetPos, BlockUtil.method34580(this.targetPos));
                if (!this.getBooleanValueFromSettingName("NoSwing")) {
                    Nuker.mc.player.swingArm(Hand.MAIN_HAND);
                } else {
                    mc.getConnection().sendPacket(new CAnimateHandPacket(Hand.MAIN_HAND));
                }
            } else {
                for (BlockPos var9 : this.blocksToDestroy) {
                    mc.getConnection().sendPacket(new CPlayerDiggingPacket(CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, var9, BlockUtil.method34580(var9)));
                    if (!this.getBooleanValueFromSettingName("NoSwing")) {
                        Nuker.mc.player.swingArm(Hand.MAIN_HAND);
                        continue;
                    }
                    mc.getConnection().sendPacket(new CAnimateHandPacket(Hand.MAIN_HAND));
                }
            }
        }
    }

    @EventTarget
    public void onRender(EventRender3D var1) {
        if (this.targetPos != null && !Nuker.mc.world.getBlockState(this.targetPos).isAir()) {
            int var4 = RenderUtil.applyAlpha(this.parseSettingValueToIntBySettingName("Color"), 0.4f);
            GL11.glPushMatrix();
            GL11.glDisable((int)2929);
            double var5 = (double)this.targetPos.getX() - Nuker.mc.gameRenderer.getActiveRenderInfo().getPos().getX();
            double var7 = (double)this.targetPos.getY() - Nuker.mc.gameRenderer.getActiveRenderInfo().getPos().getY();
            double var9 = (double)this.targetPos.getZ() - Nuker.mc.gameRenderer.getActiveRenderInfo().getPos().getZ();
            AxisAlignedBB var11 = Nuker.mc.world.getBlockState(this.targetPos).getCollisionShape(Nuker.mc.world, this.targetPos).getBoundingBox();
            BoundingBox var12 = new BoundingBox(var5 + var11.minX, var7 + var11.minY, var9 + var11.minZ, var5 + var11.maxX, var7 + var11.maxY, var9 + var11.maxZ);
            RenderUtil.render3DColoredBox(var12, var4);
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
        }
    }

    public boolean isReplaceable(BlockPos pos) {
        Block block = Nuker.mc.world.getBlockState(pos).getBlock();
        return Nuker.mc.world.getBlockState(pos).getMaterial().isReplaceable() || block instanceof BushBlock;
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<BlockPos> getBlocksToDestroy(float range) {
        ArrayList<BlockPos> blocksToDestroy = new ArrayList<BlockPos>();
        float y = range + 2.0f;
        block10: while (y >= -range + 1.0f) {
            float x = -range;
            while (true) {
                if (x <= range) {
                } else {
                    y -= 1.0f;
                    continue block10;
                }
                block12: for (float z = -range; z <= range; z += 1.0f) {
                    String mode;
                    BlockPos pos = new BlockPos(Nuker.mc.player.getPosX() + (double)x, Nuker.mc.player.getPosY() + (double)y, Nuker.mc.player.getPosZ() + (double)z);
                    if (Nuker.mc.world.getBlockState(pos).isAir() || !Nuker.mc.world.getBlockState(pos).getFluidState().isEmpty() || !(Math.sqrt(Nuker.mc.player.getDistanceSq((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5)) < (double)range)) continue;
                    switch (mode = this.getStringSettingValueByName("Mode")) {
                        case "One hit": {
                            if (this.isReplaceable(pos)) break;
                            continue block12;
                        }
                        case "Bed": {
                            if (Nuker.mc.world.getBlockState(pos).getBlock() instanceof BedBlock) break;
                            continue block12;
                        }
                        case "Egg": {
                            if (!(Nuker.mc.world.getBlockState(pos).getBlock() instanceof DragonEggBlock)) continue block12;
                        }
                    }
                    blocksToDestroy.add(pos);
                }
                x += 1.0f;
            }
            break;
        }
        return blocksToDestroy;
    }
}

