/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.world;

import com.mentalfrostbyte.jello.event.impl.game.network.EventReceivePacket;
import com.mentalfrostbyte.jello.event.impl.player.EventUpdate;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanSetting;
import com.mentalfrostbyte.jello.module.settings.impl.NumberSetting;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SUpdateTimePacket;
import team.sdhq.eventBus.annotations.EventTarget;

public class Weather
extends Module {
    private float rainStrength;
    private boolean isRaining;

    public Weather() {
        super(ModuleCategory.WORLD, "Weather", "Removes rain and changes the world's time");
        this.registerSetting((Setting)new BooleanSetting("Custom time", "Set the world time", true));
        this.registerSetting((Setting)new NumberSetting("Time", "Time to set the world to", 12000.0f, 0.0f, 24000.0f, 1.0f));
        this.registerSetting((Setting)new BooleanSetting("Disable rain", "Disable rain", true));
    }

    @Override
    public void onEnable() {
        if (Weather.mc.world != null) {
            this.rainStrength = Weather.mc.world.getRainStrength(1.0f);
            this.isRaining = Weather.mc.world.getRainStrength(1.0f) == 1.0f;
            this.applyCustomTime();
            if (this.getBooleanValueFromSettingName("Disable rain")) {
                this.applyWeatherOverride();
            }
        }
    }

    @EventTarget
    public void onTick(EventUpdate event) {
        if (this.isEnabled()) {
            this.applyCustomTime();
            if (this.getBooleanValueFromSettingName("Disable rain")) {
                this.applyWeatherOverride();
            }
        }
    }

    @EventTarget
    public void onReceivePacket(EventReceivePacket event) {
        if (this.isEnabled()) {
            if (event.packet instanceof SUpdateTimePacket) {
                event.cancelled = true;
            } else {
                IPacket<?> iPacket = event.packet;
                if (iPacket instanceof SChangeGameStatePacket) {
                    SChangeGameStatePacket gameStatePacket = (SChangeGameStatePacket)iPacket;
                    if (gameStatePacket.func_241776_b_().field_241778_b_ == 7) {
                        boolean bl = this.isRaining = gameStatePacket.getValue() == 1.0f;
                        if (this.getBooleanValueFromSettingName("Disable rain")) {
                            event.cancelled = true;
                        }
                    }
                }
            }
        }
    }

    private void applyCustomTime() {
        if (this.getBooleanValueFromSettingName("Custom time")) {
            long customTime = (long)this.getNumberValueBySettingName("Time");
            Weather.mc.world.setDayTime(customTime);
        }
    }

    private void applyWeatherOverride() {
        this.rainStrength = 0.0f;
        Weather.mc.world.setRainStrength(this.rainStrength);
        Weather.mc.world.setThunderStrength(this.rainStrength);
    }
}

