/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.util;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.IPacket;

public class PacketCollectorUtil {
    public static String[] getPacketClasses(String type) {
        String[] packages = new String[]{"net.minecraft.network.play.client", "net.minecraft.network.play.server"};
        HashSet<Class<? extends IPacket>> allPackets = new HashSet<Class<? extends IPacket>>(Set.of());
        try (ScanResult scanResult = new ClassGraph().acceptPackages(new String[]{"net.minecraft.network.play", "net.minecraft.network.play.server"}).scan();){
            allPackets.addAll(scanResult.getSubclasses(IPacket.class).loadClasses().stream().map(clazz -> clazz).collect(Collectors.toSet()));
        }
        Stream<Class<? extends IPacket>> filteredPackets = PacketCollectorUtil.getFilteredPackets(type, allPackets);
        return (String[])filteredPackets.map(Class::getSimpleName).sorted().toArray(String[]::new);
    }

    private static Stream<Class<? extends IPacket>> getFilteredPackets(String type, Set<Class<? extends IPacket>> allPackets) {
        Stream<Class<? extends IPacket>> filteredPackets = allPackets.stream();
        switch (type) {
            case "Incoming": {
                filteredPackets = filteredPackets.filter(packet -> packet.getSimpleName().matches("^S[A-Za-z]+Packet$"));
                break;
            }
            case "Outgoing": {
                filteredPackets = filteredPackets.filter(packet -> packet.getSimpleName().matches("^C[A-Za-z]+Packet$"));
            }
        }
        return filteredPackets;
    }
}

