/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.util.client.render.classicgui;

import com.mentalfrostbyte.jello.util.client.render.classicgui.CategoryDrawPartBackground;
import com.mentalfrostbyte.jello.util.client.render.theme.ClientColors;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil2;
import java.util.List;
import net.minecraft.client.Minecraft;

public class CategoryDrawPart
extends CategoryDrawPartBackground {
    private List<String> categories;
    private int maxCategoryWidth;
    public int currentOffset;
    public int scrollOffset;

    public CategoryDrawPart(List<String> categoryList, int priority) {
        super(priority);
        this.categories = categoryList;
        this.calculateMaxCategoryWidth();
    }

    public void updateCategory(int index, String newCategory) {
        if (index < this.categories.size()) {
            this.categories.set(index, newCategory);
        }
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
        if (this.currentOffset < 0) {
            this.currentOffset = 0;
        }
        if (this.currentOffset > this.categories.size()) {
            this.currentOffset = this.categories.size();
        }
        this.calculateMaxCategoryWidth();
    }

    private void calculateMaxCategoryWidth() {
        this.maxCategoryWidth = 0;
        for (String category : this.categories) {
            this.maxCategoryWidth = Math.max(this.maxCategoryWidth, this.font.getWidth(category));
        }
    }

    @Override
    public void drawContent(float partialTicks) {
        RenderUtil.drawRoundedRect2(this.getStartX(), this.getStartY(), this.getWidth(), this.getHeight(), RenderUtil2.applyAlpha(ClientColors.DEEP_TEAL.getColor(), partialTicks * 0.6f));
        this.scrollOffset += this.calculateScrollOffset();
        int startX = this.getStartX() + 4;
        int startY = this.getStartY() + this.scrollOffset + 4;
        int width = this.getWidth() - 8;
        int gradientStart = -15781024;
        int gradientEnd = -15626304;
        RenderUtil.drawQuad(startX, startY, startX + width, startY + 25, gradientStart, gradientEnd, gradientEnd, gradientStart);
        float categoryOffsetY = 6.0f;
        for (String categoryName : this.categories) {
            int color = ClientColors.LIGHT_GREYISH_BLUE.getColor();
            if (categoryName.startsWith("\u00a77")) {
                categoryName = categoryName.substring("\u00a77".length());
                color = ClientColors.MID_GREY.getColor();
            }
            RenderUtil.drawString(this.font, 7 + this.getStartX(), (float)this.getStartY() + categoryOffsetY, categoryName, RenderUtil2.applyAlpha(color, Math.min(1.0f, partialTicks * 1.7f)));
            categoryOffsetY += 25.0f;
        }
    }

    @Override
    public int getWidth() {
        return Math.max(super.getWidth(), this.maxCategoryWidth + 14);
    }

    @Override
    public int getHeight() {
        return this.categories.size() * 25 + 8;
    }

    public void scrollUp() {
        --this.currentOffset;
        if (this.currentOffset < 0) {
            this.currentOffset = this.categories.size() - 1;
        }
    }

    public void scrollDown() {
        ++this.currentOffset;
        if (this.currentOffset > this.categories.size() - 1) {
            this.currentOffset = 0;
        }
    }

    public boolean isAnimating() {
        return this.animation.calcPercent() == 1.0f;
    }

    public int calculateScrollOffset() {
        float targetOffset = this.currentOffset * 25;
        float delta = Math.abs(targetOffset - (float)this.scrollOffset);
        boolean isNegative = targetOffset - (float)this.scrollOffset != delta;
        float frameFactor = 60.0f / (float)Minecraft.getFps();
        float adjustment = Math.min(delta * 0.8f, delta * 0.3f * frameFactor);
        if (isNegative) {
            adjustment *= -1.0f;
        }
        if (adjustment > 0.0f && adjustment < 1.0f) {
            adjustment = 1.0f;
        }
        if (adjustment < 0.0f && adjustment > -1.0f) {
            adjustment = -1.0f;
        }
        return Math.round(adjustment);
    }
}

