/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.server.ServerWorld;

public class PlacedBlockTrigger
extends AbstractCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("placed_block");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public Instance deserializeTrigger(JsonObject json, EntityPredicate.AndPredicate entityPredicate, ConditionArrayParser conditionsParser) {
        Block block = PlacedBlockTrigger.deserializeBlock(json);
        StatePropertiesPredicate statepropertiespredicate = StatePropertiesPredicate.deserializeProperties(json.get("state"));
        if (block != null) {
            statepropertiespredicate.forEachNotPresent(block.getStateContainer(), property -> {
                throw new JsonSyntaxException("Block " + String.valueOf(block) + " has no property " + property + ":");
            });
        }
        LocationPredicate locationpredicate = LocationPredicate.deserialize(json.get("location"));
        ItemPredicate itempredicate = ItemPredicate.deserialize(json.get("item"));
        return new Instance(entityPredicate, block, statepropertiespredicate, locationpredicate, itempredicate);
    }

    @Nullable
    private static Block deserializeBlock(JsonObject object) {
        if (object.has("block")) {
            ResourceLocation resourcelocation = new ResourceLocation(JSONUtils.getString(object, "block"));
            return Registry.BLOCK.getOptional(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Unknown block type '" + String.valueOf(resourcelocation) + "'"));
        }
        return null;
    }

    public void trigger(ServerPlayerEntity player, BlockPos pos, ItemStack item) {
        BlockState blockstate = player.getServerWorld().getBlockState(pos);
        this.triggerListeners(player, instance -> instance.test(blockstate, pos, player.getServerWorld(), item));
    }

    public static class Instance
    extends CriterionInstance {
        private final Block block;
        private final StatePropertiesPredicate properties;
        private final LocationPredicate location;
        private final ItemPredicate item;

        public Instance(EntityPredicate.AndPredicate player, @Nullable Block block, StatePropertiesPredicate properties, LocationPredicate location, ItemPredicate item) {
            super(ID, player);
            this.block = block;
            this.properties = properties;
            this.location = location;
            this.item = item;
        }

        public static Instance placedBlock(Block block) {
            return new Instance(EntityPredicate.AndPredicate.ANY_AND, block, StatePropertiesPredicate.EMPTY, LocationPredicate.ANY, ItemPredicate.ANY);
        }

        public boolean test(BlockState state, BlockPos pos, ServerWorld world, ItemStack item) {
            if (this.block != null && !state.isIn(this.block)) {
                return false;
            }
            if (!this.properties.matches(state)) {
                return false;
            }
            if (!this.location.test(world, pos.getX(), pos.getY(), pos.getZ())) {
                return false;
            }
            return this.item.test(item);
        }

        @Override
        public JsonObject serialize(ConditionArraySerializer conditions) {
            JsonObject jsonobject = super.serialize(conditions);
            if (this.block != null) {
                jsonobject.addProperty("block", Registry.BLOCK.getKey(this.block).toString());
            }
            jsonobject.add("state", this.properties.toJsonElement());
            jsonobject.add("location", this.location.serialize());
            jsonobject.add("item", this.item.serialize());
            return jsonobject;
        }
    }
}

