/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRenderChat;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.RenderComponentsUtil;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.sdhq.eventBus.EventBus;

public class NewChatGui
extends AbstractGui {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Minecraft mc;
    private final List<String> sentMessages = Lists.newArrayList();
    private final List<ChatLine<ITextComponent>> chatLines = Lists.newArrayList();
    private final List<ChatLine<IReorderingProcessor>> drawnChatLines = Lists.newArrayList();
    private final Deque<ITextComponent> queuedMessages = Queues.newArrayDeque();
    private int scrollPos;
    private boolean isScrolled;
    private long field_238490_l_ = 0L;
    private int lastChatWidth = 0;

    public NewChatGui(Minecraft mcIn) {
        this.mc = mcIn;
    }

    public void func_238492_a_(MatrixStack matrix, int currentTick) {
        int chatWidth = this.getChatWidth();
        if (this.lastChatWidth != chatWidth) {
            this.lastChatWidth = chatWidth;
            this.refreshChat();
        }
        if (!this.isChatHidden()) {
            this.clearExpiredChatLines();
            int maxVisibleLines = this.getLineCount();
            int totalChatLines = this.drawnChatLines.size();
            if (totalChatLines > 0) {
                boolean isChatOpen = this.getChatOpen();
                double chatScale = this.getScale();
                int scaledChatWidth = MathHelper.ceil((double)this.getChatWidth() / chatScale);
                RenderSystem.pushMatrix();
                RenderSystem.translatef(2.0f, 8.0f, 0.0f);
                RenderSystem.scaled(chatScale, chatScale, 1.0);
                double chatOpacity = this.mc.gameSettings.chatOpacity * (double)0.9f + (double)0.1f;
                double backgroundOpacity = this.mc.gameSettings.accessibilityTextBackgroundOpacity;
                double lineHeight = 9.0 * (this.mc.gameSettings.chatLineSpacing + 1.0);
                double textOffset = -8.0 * (this.mc.gameSettings.chatLineSpacing + 1.0) + 4.0 * this.mc.gameSettings.chatLineSpacing;
                int renderedLines = 0;
                for (int lineIndex = 0; lineIndex + this.scrollPos < this.drawnChatLines.size() && lineIndex < maxVisibleLines; ++lineIndex) {
                    int age;
                    ChatLine<IReorderingProcessor> chatline = this.drawnChatLines.get(lineIndex + this.scrollPos);
                    if (chatline == null || (age = currentTick - chatline.getUpdatedCounter()) >= 200 && !isChatOpen) continue;
                    double lineOpacity = isChatOpen ? 1.0 : NewChatGui.getLineBrightness(age);
                    int textAlpha = (int)(255.0 * lineOpacity * chatOpacity);
                    int backgroundAlpha = (int)(255.0 * lineOpacity * backgroundOpacity);
                    ++renderedLines;
                    if (textAlpha <= 3) continue;
                    double yOffset = (double)(-lineIndex) * lineHeight;
                    EventRenderChat eventRenderChat = new EventRenderChat();
                    EventBus.call(eventRenderChat);
                    yOffset += (double)eventRenderChat.getYOffset();
                    matrix.push();
                    matrix.translate(0.0, 0.0, 50.0);
                    if (this.mc.gameSettings.ofChatBackground == 5) {
                        scaledChatWidth = this.mc.fontRenderer.getStringWidth(chatline.getLineString()) - 2;
                    }
                    if (this.mc.gameSettings.ofChatBackground != 3) {
                        NewChatGui.fill(matrix, -2, (int)(yOffset - lineHeight), scaledChatWidth + 4, (int)yOffset, backgroundAlpha << 24);
                    }
                    RenderSystem.enableBlend();
                    matrix.translate(0.0, 0.0, 50.0);
                    if (!this.mc.gameSettings.ofChatShadow) {
                        this.mc.fontRenderer.func_238422_b_(matrix, chatline.getLineString(), 0.0f, (int)(yOffset + textOffset), 0xFFFFFF + (textAlpha << 24));
                    } else {
                        this.mc.fontRenderer.func_238407_a_(matrix, chatline.getLineString(), 0.0f, (int)(yOffset + textOffset), 0xFFFFFF + (textAlpha << 24));
                    }
                    RenderSystem.disableAlphaTest();
                    RenderSystem.disableBlend();
                    matrix.pop();
                }
                if (!this.queuedMessages.isEmpty()) {
                    int queueAlpha = (int)(128.0 * chatOpacity);
                    int queueBackgroundAlpha = (int)(255.0 * backgroundOpacity);
                    matrix.push();
                    matrix.translate(0.0, 0.0, 50.0);
                    NewChatGui.fill(matrix, -2, 0, scaledChatWidth + 4, 9, queueBackgroundAlpha << 24);
                    RenderSystem.enableBlend();
                    matrix.translate(0.0, 0.0, 50.0);
                    this.mc.fontRenderer.drawText(matrix, new TranslationTextComponent("chat.queue", this.queuedMessages.size()), 0.0f, 1.0f, 0xFFFFFF + (queueAlpha << 24));
                    matrix.pop();
                    RenderSystem.disableAlphaTest();
                    RenderSystem.disableBlend();
                }
                if (isChatOpen) {
                    int scrollbarHeight = 9;
                    RenderSystem.translatef(-3.0f, 0.0f, 0.0f);
                    int totalScrollHeight = totalChatLines * scrollbarHeight + totalChatLines;
                    int visibleScrollHeight = renderedLines * scrollbarHeight + renderedLines;
                    int scrollBarTop = this.scrollPos * visibleScrollHeight / totalChatLines;
                    int scrollBarHeight = visibleScrollHeight * visibleScrollHeight / totalScrollHeight;
                    if (totalScrollHeight != visibleScrollHeight) {
                        int scrollbarBaseColor = scrollBarTop > 0 ? 170 : 96;
                        int scrollbarBackgroundAlpha = this.isScrolled ? 0xCC3333 : 0x3333AA;
                        NewChatGui.fill(matrix, 0, -scrollBarTop, 2, -scrollBarTop - scrollBarHeight, scrollbarBackgroundAlpha + (scrollbarBaseColor << 24));
                        NewChatGui.fill(matrix, 2, -scrollBarTop, 1, -scrollBarTop - scrollBarHeight, 0xCCCCCC + (scrollbarBaseColor << 24));
                    }
                }
                RenderSystem.popMatrix();
            }
        }
    }

    private boolean isChatHidden() {
        return this.mc.gameSettings.chatVisibility == ChatVisibility.HIDDEN;
    }

    private static double getLineBrightness(int counterIn) {
        double d0 = (double)counterIn / 200.0;
        d0 = 1.0 - d0;
        d0 *= 10.0;
        d0 = MathHelper.clamp(d0, 0.0, 1.0);
        return d0 * d0;
    }

    public void clearChatMessages(boolean clearSentMsgHistory) {
        this.queuedMessages.clear();
        this.drawnChatLines.clear();
        this.chatLines.clear();
        if (clearSentMsgHistory) {
            this.sentMessages.clear();
        }
    }

    public void printChatMessage(ITextComponent chatComponent) {
        this.printChatMessageWithOptionalDeletion(chatComponent, 0);
    }

    public void printChatMessageWithOptionalDeletion(ITextComponent chatComponent, int chatLineId) {
        this.func_238493_a_(chatComponent, chatLineId, this.mc.ingameGUI.getTicks(), false);
        LOGGER.info("[CHAT] {}", (Object)chatComponent.getString().replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n"));
    }

    private void func_238493_a_(ITextComponent p_238493_1_, int p_238493_2_, int p_238493_3_, boolean p_238493_4_) {
        if (p_238493_2_ != 0) {
            this.deleteChatLine(p_238493_2_);
        }
        int i = MathHelper.floor((double)this.getChatWidth() / this.getScale());
        List<IReorderingProcessor> list = RenderComponentsUtil.func_238505_a_(p_238493_1_, i, this.mc.fontRenderer);
        boolean flag = this.getChatOpen();
        for (IReorderingProcessor ireorderingprocessor : list) {
            if (flag && this.scrollPos > 0) {
                this.isScrolled = true;
                this.addScrollPos(1.0);
            }
            this.drawnChatLines.add(0, new ChatLine<IReorderingProcessor>(p_238493_3_, ireorderingprocessor, p_238493_2_));
        }
        while (this.drawnChatLines.size() > 100) {
            this.drawnChatLines.remove(this.drawnChatLines.size() - 1);
        }
        if (!p_238493_4_) {
            this.chatLines.add(0, new ChatLine<ITextComponent>(p_238493_3_, p_238493_1_, p_238493_2_));
            while (this.chatLines.size() > 100) {
                this.chatLines.remove(this.chatLines.size() - 1);
            }
        }
    }

    public void refreshChat() {
        this.drawnChatLines.clear();
        this.resetScroll();
        for (int i = this.chatLines.size() - 1; i >= 0; --i) {
            ChatLine<ITextComponent> chatline = this.chatLines.get(i);
            this.func_238493_a_(chatline.getLineString(), chatline.getChatLineID(), chatline.getUpdatedCounter(), true);
        }
    }

    public List<String> getSentMessages() {
        return this.sentMessages;
    }

    public void addToSentMessages(String message) {
        if (this.sentMessages.isEmpty() || !this.sentMessages.get(this.sentMessages.size() - 1).equals(message)) {
            this.sentMessages.add(message);
        }
    }

    public void resetScroll() {
        this.scrollPos = 0;
        this.isScrolled = false;
    }

    public void addScrollPos(double posInc) {
        this.scrollPos = (int)((double)this.scrollPos + posInc);
        int i = this.drawnChatLines.size();
        if (this.scrollPos > i - this.getLineCount()) {
            this.scrollPos = i - this.getLineCount();
        }
        if (this.scrollPos <= 0) {
            this.scrollPos = 0;
            this.isScrolled = false;
        }
    }

    public boolean func_238491_a_(double p_238491_1_, double p_238491_3_) {
        if (this.getChatOpen() && !this.mc.gameSettings.hideGUI && !this.isChatHidden() && !this.queuedMessages.isEmpty()) {
            double d0 = p_238491_1_ - 2.0;
            double d1 = (double)this.mc.getMainWindow().getScaledHeight() - p_238491_3_ - 40.0;
            if (d0 <= (double)MathHelper.floor((double)this.getChatWidth() / this.getScale()) && d1 < 0.0 && d1 > (double)MathHelper.floor(-9.0 * this.getScale())) {
                this.printChatMessage(this.queuedMessages.remove());
                this.field_238490_l_ = System.currentTimeMillis();
                return true;
            }
            return false;
        }
        return false;
    }

    @Nullable
    public Style func_238494_b_(double p_238494_1_, double p_238494_3_) {
        if (this.getChatOpen() && !this.mc.gameSettings.hideGUI && !this.isChatHidden()) {
            double d0 = p_238494_1_ - 2.0;
            double d1 = (double)this.mc.getMainWindow().getScaledHeight() - p_238494_3_ - 40.0;
            d0 = MathHelper.floor(d0 / this.getScale());
            d1 = MathHelper.floor(d1 / (this.getScale() * (this.mc.gameSettings.chatLineSpacing + 1.0)));
            if (!(d0 < 0.0) && !(d1 < 0.0)) {
                int j;
                int i = Math.min(this.getLineCount(), this.drawnChatLines.size());
                if (d0 <= (double)MathHelper.floor((double)this.getChatWidth() / this.getScale()) && d1 < (double)(9 * i + i) && (j = (int)(d1 / 9.0 + (double)this.scrollPos)) >= 0 && j < this.drawnChatLines.size()) {
                    ChatLine<IReorderingProcessor> chatline = this.drawnChatLines.get(j);
                    return this.mc.fontRenderer.getCharacterManager().func_243239_a(chatline.getLineString(), (int)d0);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private boolean getChatOpen() {
        return this.mc.currentScreen instanceof ChatScreen;
    }

    public void deleteChatLine(int id) {
        this.drawnChatLines.removeIf(p_lambda$deleteChatLine$0_1_ -> p_lambda$deleteChatLine$0_1_.getChatLineID() == id);
        this.chatLines.removeIf(p_lambda$deleteChatLine$1_1_ -> p_lambda$deleteChatLine$1_1_.getChatLineID() == id);
    }

    public int getChatWidth() {
        int i = NewChatGui.calculateChatboxWidth(this.mc.gameSettings.chatWidth);
        MainWindow mainwindow = Minecraft.getInstance().getMainWindow();
        int j = (int)((double)(mainwindow.getFramebufferWidth() - 3) / mainwindow.getGuiScaleFactor());
        return MathHelper.clamp(i, 0, j);
    }

    public int getChatHeight() {
        return NewChatGui.calculateChatboxHeight((this.getChatOpen() ? this.mc.gameSettings.chatHeightFocused : this.mc.gameSettings.chatHeightUnfocused) / (this.mc.gameSettings.chatLineSpacing + 1.0));
    }

    public double getScale() {
        return this.mc.gameSettings.chatScale;
    }

    public static int calculateChatboxWidth(double p_194814_0_) {
        int i = 320;
        int j = 40;
        return MathHelper.floor(p_194814_0_ * 280.0 + 40.0);
    }

    public static int calculateChatboxHeight(double p_194816_0_) {
        int i = 180;
        int j = 20;
        return MathHelper.floor(p_194816_0_ * 160.0 + 20.0);
    }

    public int getLineCount() {
        return this.getChatHeight() / 9;
    }

    private long func_238497_j_() {
        return (long)(this.mc.gameSettings.chatDelay * 1000.0);
    }

    private void clearExpiredChatLines() {
        long i;
        if (!this.queuedMessages.isEmpty() && (i = System.currentTimeMillis()) - this.field_238490_l_ >= this.func_238497_j_()) {
            this.printChatMessage(this.queuedMessages.remove());
            this.field_238490_l_ = i;
        }
    }

    public void func_238495_b_(ITextComponent p_238495_1_) {
        if (this.mc.gameSettings.chatDelay <= 0.0) {
            this.printChatMessage(p_238495_1_);
        } else {
            long i = System.currentTimeMillis();
            if (i - this.field_238490_l_ >= this.func_238497_j_()) {
                this.printChatMessage(p_238495_1_);
                this.field_238490_l_ = i;
            } else {
                this.queuedMessages.add(p_238495_1_);
            }
        }
    }
}

