/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.fonts.providers;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.gui.fonts.IGlyphInfo;
import net.minecraft.client.gui.fonts.providers.IGlyphProvider;
import net.minecraft.client.renderer.texture.NativeImage;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class TrueTypeGlyphProvider
implements IGlyphProvider {
    private final ByteBuffer field_230146_a_;
    private final STBTTFontinfo fontInfo;
    private final float oversample;
    private final IntSet chars = new IntArraySet();
    private final float shiftX;
    private final float shiftY;
    private final float scale;
    private final float ascent;

    public TrueTypeGlyphProvider(ByteBuffer p_i230051_1_, STBTTFontinfo p_i230051_2_, float p_i230051_3_, float p_i230051_4_, float p_i230051_5_, float p_i230051_6_, String p_i230051_7_) {
        this.field_230146_a_ = p_i230051_1_;
        this.fontInfo = p_i230051_2_;
        this.oversample = p_i230051_4_;
        p_i230051_7_.codePoints().forEach(arg_0 -> ((IntSet)this.chars).add(arg_0));
        this.shiftX = p_i230051_5_ * p_i230051_4_;
        this.shiftY = p_i230051_6_ * p_i230051_4_;
        this.scale = STBTruetype.stbtt_ScaleForPixelHeight((STBTTFontinfo)p_i230051_2_, (float)(p_i230051_3_ * p_i230051_4_));
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            STBTruetype.stbtt_GetFontVMetrics((STBTTFontinfo)p_i230051_2_, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (IntBuffer)intbuffer2);
            this.ascent = (float)intbuffer.get(0) * this.scale;
        }
    }

    @Override
    @Nullable
    public GlpyhInfo getGlyphInfo(int character) {
        Object lvt_9_1_;
        if (this.chars.contains(character)) {
            return null;
        }
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            IntBuffer intbuffer3 = memorystack.mallocInt(1);
            int i = STBTruetype.stbtt_FindGlyphIndex((STBTTFontinfo)this.fontInfo, (int)character);
            if (i != 0) {
                STBTruetype.stbtt_GetGlyphBitmapBoxSubpixel((STBTTFontinfo)this.fontInfo, (int)i, (float)this.scale, (float)this.scale, (float)this.shiftX, (float)this.shiftY, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (IntBuffer)intbuffer2, (IntBuffer)intbuffer3);
                int k = intbuffer2.get(0) - intbuffer.get(0);
                int j = intbuffer3.get(0) - intbuffer1.get(0);
                if (k != 0 && j != 0) {
                    IntBuffer intbuffer5 = memorystack.mallocInt(1);
                    IntBuffer intbuffer4 = memorystack.mallocInt(1);
                    STBTruetype.stbtt_GetGlyphHMetrics((STBTTFontinfo)this.fontInfo, (int)i, (IntBuffer)intbuffer5, (IntBuffer)intbuffer4);
                    GlpyhInfo glpyhInfo = new GlpyhInfo(intbuffer.get(0), intbuffer2.get(0), -intbuffer1.get(0), -intbuffer3.get(0), (float)intbuffer5.get(0) * this.scale, (float)intbuffer4.get(0) * this.scale, i);
                    return glpyhInfo;
                }
                GlpyhInfo glpyhInfo = null;
                return glpyhInfo;
            }
            lvt_9_1_ = null;
        }
        return lvt_9_1_;
    }

    @Override
    public void close() {
        this.fontInfo.free();
        MemoryUtil.memFree((ByteBuffer)this.field_230146_a_);
    }

    @Override
    public IntSet func_230428_a_() {
        return (IntSet)IntStream.range(0, 65535).filter(p_237505_1_ -> !this.chars.contains(p_237505_1_)).collect(IntOpenHashSet::new, IntCollection::add, IntCollection::addAll);
    }

    class GlpyhInfo
    implements IGlyphInfo {
        private final int width;
        private final int height;
        private final float field_212464_d;
        private final float field_212465_e;
        private final float advanceWidth;
        private final int glyphIndex;

        private GlpyhInfo(int p_i49751_2_, int p_i49751_3_, int p_i49751_4_, int p_i49751_5_, float p_i49751_6_, float p_i49751_7_, int p_i49751_8_) {
            this.width = p_i49751_3_ - p_i49751_2_;
            this.height = p_i49751_4_ - p_i49751_5_;
            this.advanceWidth = p_i49751_6_ / TrueTypeGlyphProvider.this.oversample;
            this.field_212464_d = (p_i49751_7_ + (float)p_i49751_2_ + TrueTypeGlyphProvider.this.shiftX) / TrueTypeGlyphProvider.this.oversample;
            this.field_212465_e = (TrueTypeGlyphProvider.this.ascent - (float)p_i49751_4_ + TrueTypeGlyphProvider.this.shiftY) / TrueTypeGlyphProvider.this.oversample;
            this.glyphIndex = p_i49751_8_;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public float getOversample() {
            return TrueTypeGlyphProvider.this.oversample;
        }

        @Override
        public float getAdvance() {
            return this.advanceWidth;
        }

        @Override
        public float getBearingX() {
            return this.field_212464_d;
        }

        @Override
        public float getBearingY() {
            return this.field_212465_e;
        }

        @Override
        public void uploadGlyph(int xOffset, int yOffset) {
            NativeImage nativeimage = new NativeImage(NativeImage.PixelFormat.LUMINANCE, this.width, this.height, false);
            nativeimage.renderGlyph(TrueTypeGlyphProvider.this.fontInfo, this.glyphIndex, this.width, this.height, TrueTypeGlyphProvider.this.scale, TrueTypeGlyphProvider.this.scale, TrueTypeGlyphProvider.this.shiftX, TrueTypeGlyphProvider.this.shiftY, 0, 0);
            nativeimage.uploadTextureSub(0, xOffset, yOffset, 0, 0, this.width, this.height, false, true);
        }

        @Override
        public boolean isColored() {
            return false;
        }
    }
}

