/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Function4;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.WorldOptimizer;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OptimizeWorldScreen
extends Screen {
    private static final Logger field_239024_a_ = LogManager.getLogger();
    private static final Object2IntMap<RegistryKey<World>> PROGRESS_BAR_COLORS = (Object2IntMap)Util.make(new Object2IntOpenCustomHashMap(Util.identityHashStrategy()), p_212346_0_ -> {
        p_212346_0_.put(World.OVERWORLD, -13408734);
        p_212346_0_.put(World.THE_NETHER, -10075085);
        p_212346_0_.put(World.THE_END, -8943531);
        p_212346_0_.defaultReturnValue(-2236963);
    });
    private final BooleanConsumer field_214332_b;
    private final WorldOptimizer optimizer;

    @Nullable
    public static OptimizeWorldScreen func_239025_a_(Minecraft p_239025_0_, BooleanConsumer p_239025_1_, DataFixer p_239025_2_, SaveFormat.LevelSave p_239025_3_, boolean p_239025_4_) {
        DynamicRegistries.Impl dynamicregistries$impl = DynamicRegistries.func_239770_b_();
        Minecraft.PackManager minecraft$packmanager = p_239025_0_.reloadDatapacks(dynamicregistries$impl, Minecraft::loadDataPackCodec, (Function4<SaveFormat.LevelSave, DynamicRegistries.Impl, IResourceManager, DatapackCodec, IServerConfiguration>)((Function4)Minecraft::loadWorld), false, p_239025_3_);
        try {
            IServerConfiguration iserverconfiguration = minecraft$packmanager.getServerConfiguration();
            p_239025_3_.saveLevel(dynamicregistries$impl, iserverconfiguration);
            ImmutableSet<RegistryKey<World>> immutableset = iserverconfiguration.getDimensionGeneratorSettings().func_236226_g_();
            OptimizeWorldScreen optimizeWorldScreen = new OptimizeWorldScreen(p_239025_1_, p_239025_2_, p_239025_3_, iserverconfiguration.getWorldSettings(), p_239025_4_, immutableset);
            if (minecraft$packmanager != null) {
                minecraft$packmanager.close();
            }
            return optimizeWorldScreen;
        }
        catch (Throwable throwable) {
            try {
                if (minecraft$packmanager != null) {
                    try {
                        minecraft$packmanager.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception exception) {
                field_239024_a_.warn("Failed to load datapacks, can't optimize world", (Throwable)exception);
                return null;
            }
        }
    }

    private OptimizeWorldScreen(BooleanConsumer p_i232319_1_, DataFixer p_i232319_2_, SaveFormat.LevelSave p_i232319_3_, WorldSettings p_i232319_4_, boolean p_i232319_5_, ImmutableSet<RegistryKey<World>> p_i232319_6_) {
        super(new TranslationTextComponent("optimizeWorld.title", p_i232319_4_.getWorldName()));
        this.field_214332_b = p_i232319_1_;
        this.optimizer = new WorldOptimizer(p_i232319_3_, p_i232319_2_, p_i232319_6_, p_i232319_5_);
    }

    @Override
    protected void init() {
        super.init();
        this.addButton(new Button(this.width / 2 - 100, this.height / 4 + 150, 200, 20, DialogTexts.GUI_CANCEL, p_214331_1_ -> {
            this.optimizer.cancel();
            this.field_214332_b.accept(false);
        }));
    }

    @Override
    public void tick() {
        if (this.optimizer.isFinished()) {
            this.field_214332_b.accept(true);
        }
    }

    @Override
    public void closeScreen() {
        this.field_214332_b.accept(false);
    }

    @Override
    public void onClose() {
        this.optimizer.cancel();
    }

    @Override
    public void render(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices);
        OptimizeWorldScreen.drawCenteredString(matrices, this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        int i = this.width / 2 - 150;
        int j = this.width / 2 + 150;
        int k = this.height / 4 + 100;
        int l = k + 10;
        OptimizeWorldScreen.drawCenteredString(matrices, this.font, this.optimizer.getStatusText(), this.width / 2, k - 9 - 2, 0xA0A0A0);
        if (this.optimizer.getTotalChunks() > 0) {
            OptimizeWorldScreen.fill(matrices, i - 1, k - 1, j + 1, l + 1, -16777216);
            OptimizeWorldScreen.drawString(matrices, this.font, new TranslationTextComponent("optimizeWorld.info.converted", this.optimizer.getConverted()), i, 40, 0xA0A0A0);
            OptimizeWorldScreen.drawString(matrices, this.font, new TranslationTextComponent("optimizeWorld.info.skipped", this.optimizer.getSkipped()), i, 52, 0xA0A0A0);
            OptimizeWorldScreen.drawString(matrices, this.font, new TranslationTextComponent("optimizeWorld.info.total", this.optimizer.getTotalChunks()), i, 64, 0xA0A0A0);
            int i1 = 0;
            for (RegistryKey registrykey : this.optimizer.func_233533_c_()) {
                int j1 = MathHelper.floor(this.optimizer.func_233531_a_(registrykey) * (float)(j - i));
                OptimizeWorldScreen.fill(matrices, i + i1, k, i + i1 + j1, l, PROGRESS_BAR_COLORS.getInt((Object)registrykey));
                i1 += j1;
            }
            int k1 = this.optimizer.getConverted() + this.optimizer.getSkipped();
            OptimizeWorldScreen.drawCenteredString(matrices, this.font, k1 + " / " + this.optimizer.getTotalChunks(), this.width / 2, k + 18 + 2, 0xA0A0A0);
            OptimizeWorldScreen.drawCenteredString(matrices, this.font, MathHelper.floor(this.optimizer.getTotalProgress() * 100.0f) + "%", this.width / 2, k + (l - k) / 2 - 4, 0xA0A0A0);
        }
        super.render(matrices, mouseX, mouseY, delta);
    }
}

