/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.optifine.util.CompareUtils;

public abstract class RenderState {
    protected final String name;
    private final Runnable setupTask;
    private final Runnable clearTask;
    protected static final TransparencyState NO_TRANSPARENCY = new TransparencyState("no_transparency", () -> RenderSystem.disableBlend(), () -> {});
    protected static final TransparencyState ADDITIVE_TRANSPARENCY = new TransparencyState("additive_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc(GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final TransparencyState LIGHTNING_TRANSPARENCY = new TransparencyState("lightning_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final TransparencyState GLINT_TRANSPARENCY = new TransparencyState("glint_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_COLOR, GlStateManager.DestFactor.ONE, GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final TransparencyState CRUMBLING_TRANSPARENCY = new TransparencyState("crumbling_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.DST_COLOR, GlStateManager.DestFactor.SRC_COLOR, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final TransparencyState TRANSLUCENT_TRANSPARENCY = new TransparencyState("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final AlphaState ZERO_ALPHA = new AlphaState(0.0f);
    protected static final AlphaState DEFAULT_ALPHA = new AlphaState(0.003921569f);
    protected static final AlphaState HALF_ALPHA = new AlphaState(0.5f);
    protected static final AlphaState CUTOUT_MIPPED_ALPHA = new AlphaState(0.1f);
    protected static final ShadeModelState SHADE_DISABLED = new ShadeModelState(false);
    protected static final ShadeModelState SHADE_ENABLED = new ShadeModelState(true);
    protected static final TextureState BLOCK_SHEET_MIPPED = new TextureState(AtlasTexture.LOCATION_BLOCKS_TEXTURE, false, true);
    protected static final TextureState BLOCK_SHEET = new TextureState(AtlasTexture.LOCATION_BLOCKS_TEXTURE, false, false);
    protected static final TextureState NO_TEXTURE = new TextureState();
    protected static final TexturingState DEFAULT_TEXTURING = new TexturingState("default_texturing", () -> {}, () -> {});
    protected static final TexturingState OUTLINE_TEXTURING = new TexturingState("outline_texturing", () -> RenderSystem.setupOutline(), () -> RenderSystem.teardownOutline());
    protected static final TexturingState GLINT_TEXTURING = new TexturingState("glint_texturing", () -> RenderState.setupGlintTexturing(8.0f), () -> {
        RenderSystem.matrixMode(5890);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode(5888);
    });
    protected static final TexturingState ENTITY_GLINT_TEXTURING = new TexturingState("entity_glint_texturing", () -> RenderState.setupGlintTexturing(0.16f), () -> {
        RenderSystem.matrixMode(5890);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode(5888);
    });
    protected static final LightmapState LIGHTMAP_ENABLED = new LightmapState(true);
    protected static final LightmapState LIGHTMAP_DISABLED = new LightmapState(false);
    protected static final OverlayState OVERLAY_ENABLED = new OverlayState(true);
    protected static final OverlayState OVERLAY_DISABLED = new OverlayState(false);
    protected static final DiffuseLightingState DIFFUSE_LIGHTING_ENABLED = new DiffuseLightingState(true);
    protected static final DiffuseLightingState DIFFUSE_LIGHTING_DISABLED = new DiffuseLightingState(false);
    protected static final CullState CULL_ENABLED = new CullState(true);
    protected static final CullState CULL_DISABLED = new CullState(false);
    protected static final DepthTestState DEPTH_ALWAYS = new DepthTestState("always", 519);
    protected static final DepthTestState DEPTH_EQUAL = new DepthTestState("==", 514);
    protected static final DepthTestState DEPTH_LEQUAL = new DepthTestState("<=", 515);
    protected static final WriteMaskState COLOR_DEPTH_WRITE = new WriteMaskState(true, true);
    protected static final WriteMaskState COLOR_WRITE = new WriteMaskState(true, false);
    protected static final WriteMaskState DEPTH_WRITE = new WriteMaskState(false, true);
    protected static final LayerState NO_LAYERING = new LayerState("no_layering", () -> {}, () -> {});
    protected static final LayerState POLYGON_OFFSET_LAYERING = new LayerState("polygon_offset_layering", () -> {
        RenderSystem.polygonOffset(-1.0f, -10.0f);
        RenderSystem.enablePolygonOffset();
    }, () -> {
        RenderSystem.polygonOffset(0.0f, 0.0f);
        RenderSystem.disablePolygonOffset();
    });
    protected static final LayerState field_239235_M_ = new LayerState("view_offset_z_layering", () -> {
        RenderSystem.pushMatrix();
        RenderSystem.scalef(0.99975586f, 0.99975586f, 0.99975586f);
    }, RenderSystem::popMatrix);
    protected static final FogState NO_FOG = new FogState("no_fog", () -> {}, () -> {});
    protected static final FogState FOG = new FogState("fog", () -> {
        FogRenderer.applyFog();
        RenderSystem.enableFog();
    }, () -> RenderSystem.disableFog());
    protected static final FogState BLACK_FOG = new FogState("black_fog", () -> {
        RenderSystem.fog(2918, 0.0f, 0.0f, 0.0f, 1.0f);
        RenderSystem.enableFog();
    }, () -> {
        FogRenderer.applyFog();
        RenderSystem.disableFog();
    });
    protected static final TargetState MAIN_TARGET = new TargetState("main_target", () -> {}, () -> {});
    protected static final TargetState OUTLINE_TARGET = new TargetState("outline_target", () -> Minecraft.getInstance().worldRenderer.getEntityOutlineFramebuffer().bindFramebuffer(false), () -> Minecraft.getInstance().getFramebuffer().bindFramebuffer(false));
    protected static final TargetState field_239236_S_ = new TargetState("translucent_target", () -> {
        if (Minecraft.isFabulousGraphicsEnabled()) {
            Minecraft.getInstance().worldRenderer.func_239228_q_().bindFramebuffer(false);
        }
    }, () -> {
        if (Minecraft.isFabulousGraphicsEnabled()) {
            Minecraft.getInstance().getFramebuffer().bindFramebuffer(false);
        }
    });
    protected static final TargetState field_239237_T_ = new TargetState("particles_target", () -> {
        if (Minecraft.isFabulousGraphicsEnabled()) {
            Minecraft.getInstance().worldRenderer.func_239230_s_().bindFramebuffer(false);
        }
    }, () -> {
        if (Minecraft.isFabulousGraphicsEnabled()) {
            Minecraft.getInstance().getFramebuffer().bindFramebuffer(false);
        }
    });
    protected static final TargetState field_239238_U_ = new TargetState("weather_target", () -> {
        if (Minecraft.isFabulousGraphicsEnabled()) {
            Minecraft.getInstance().worldRenderer.func_239231_t_().bindFramebuffer(false);
        }
    }, () -> {
        if (Minecraft.isFabulousGraphicsEnabled()) {
            Minecraft.getInstance().getFramebuffer().bindFramebuffer(false);
        }
    });
    protected static final TargetState field_239239_V_ = new TargetState("clouds_target", () -> {
        if (Minecraft.isFabulousGraphicsEnabled()) {
            Minecraft.getInstance().worldRenderer.func_239232_u_().bindFramebuffer(false);
        }
    }, () -> {
        if (Minecraft.isFabulousGraphicsEnabled()) {
            Minecraft.getInstance().getFramebuffer().bindFramebuffer(false);
        }
    });
    protected static final TargetState field_241712_U_ = new TargetState("item_entity_target", () -> {
        if (Minecraft.isFabulousGraphicsEnabled()) {
            Minecraft.getInstance().worldRenderer.func_239229_r_().bindFramebuffer(false);
        }
    }, () -> {
        if (Minecraft.isFabulousGraphicsEnabled()) {
            Minecraft.getInstance().getFramebuffer().bindFramebuffer(false);
        }
    });
    protected static final LineState DEFAULT_LINE = new LineState(OptionalDouble.of(1.0));

    public RenderState(String nameIn, Runnable setupTaskIn, Runnable clearTaskIn) {
        this.name = nameIn;
        this.setupTask = setupTaskIn;
        this.clearTask = clearTaskIn;
    }

    public void setupRenderState() {
        this.setupTask.run();
    }

    public void clearRenderState() {
        this.clearTask.run();
    }

    public boolean equals(@Nullable Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
            RenderState renderstate = (RenderState)p_equals_1_;
            return this.name.equals(renderstate.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    private static void setupGlintTexturing(float scaleIn) {
        RenderSystem.matrixMode(5890);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        long i = Util.milliTime() * 8L;
        float f = (float)(i % 110000L) / 110000.0f;
        float f1 = (float)(i % 30000L) / 30000.0f;
        RenderSystem.translatef(-f, f1, 0.0f);
        RenderSystem.rotatef(10.0f, 0.0f, 0.0f, 1.0f);
        RenderSystem.scalef(scaleIn, scaleIn, scaleIn);
        RenderSystem.matrixMode(5888);
    }

    public String getName() {
        return this.name;
    }

    public static class TransparencyState
    extends RenderState {
        public TransparencyState(String p_i225990_1_, Runnable p_i225990_2_, Runnable p_i225990_3_) {
            super(p_i225990_1_, p_i225990_2_, p_i225990_3_);
        }
    }

    public static class AlphaState
    extends RenderState {
        private final float ref;

        public AlphaState(float refIn) {
            super("alpha", () -> {
                if (refIn > 0.0f) {
                    RenderSystem.enableAlphaTest();
                    RenderSystem.alphaFunc(516, refIn);
                } else {
                    RenderSystem.disableAlphaTest();
                }
            }, () -> {
                RenderSystem.disableAlphaTest();
                RenderSystem.defaultAlphaFunc();
            });
            this.ref = refIn;
        }

        @Override
        public boolean equals(@Nullable Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                if (!super.equals(p_equals_1_)) {
                    return false;
                }
                return this.ref == ((AlphaState)p_equals_1_).ref;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return CompareUtils.hash(super.hashCode(), this.ref);
        }

        @Override
        public String toString() {
            return this.name + "[" + this.ref + "]";
        }
    }

    public static class ShadeModelState
    extends RenderState {
        private final boolean smooth;

        public ShadeModelState(boolean p_i225987_1_) {
            super("shade_model", () -> RenderSystem.shadeModel(p_i225987_1_ ? 7425 : 7424), () -> RenderSystem.shadeModel(7424));
            this.smooth = p_i225987_1_;
        }

        @Override
        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                ShadeModelState renderstate$shademodelstate = (ShadeModelState)p_equals_1_;
                return this.smooth == renderstate$shademodelstate.smooth;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Boolean.hashCode(this.smooth);
        }

        @Override
        public String toString() {
            return this.name + "[" + (this.smooth ? "smooth" : "flat") + "]";
        }
    }

    public static class TextureState
    extends RenderState {
        private final Optional<ResourceLocation> texture;
        private final boolean blur;
        private final boolean mipmap;

        public TextureState(ResourceLocation p_i225988_1_, boolean p_i225988_2_, boolean p_i225988_3_) {
            super("texture", () -> {
                RenderSystem.enableTexture();
                TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
                texturemanager.bindTexture(p_i225988_1_);
                texturemanager.getBoundTexture().setBlurMipmapDirect(p_i225988_2_, p_i225988_3_);
            }, () -> {});
            this.texture = Optional.of(p_i225988_1_);
            this.blur = p_i225988_2_;
            this.mipmap = p_i225988_3_;
        }

        public TextureState() {
            super("texture", () -> RenderSystem.disableTexture(), () -> RenderSystem.enableTexture());
            this.texture = Optional.empty();
            this.blur = false;
            this.mipmap = false;
        }

        @Override
        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                TextureState renderstate$texturestate = (TextureState)p_equals_1_;
                return this.texture.equals(renderstate$texturestate.texture) && this.blur == renderstate$texturestate.blur && this.mipmap == renderstate$texturestate.mipmap;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.texture.hashCode();
        }

        @Override
        public String toString() {
            return this.name + "[" + String.valueOf(this.texture) + "(blur=" + this.blur + ", mipmap=" + this.mipmap + ")]";
        }

        protected Optional<ResourceLocation> texture() {
            return this.texture;
        }

        public boolean isBlur() {
            return this.blur;
        }

        public boolean isMipmap() {
            return this.mipmap;
        }
    }

    public static class TexturingState
    extends RenderState {
        public TexturingState(String p_i225989_1_, Runnable p_i225989_2_, Runnable p_i225989_3_) {
            super(p_i225989_1_, p_i225989_2_, p_i225989_3_);
        }
    }

    public static class LightmapState
    extends BooleanState {
        public LightmapState(boolean p_i225981_1_) {
            super("lightmap", () -> {
                if (p_i225981_1_) {
                    Minecraft.getInstance().gameRenderer.getLightTexture().enableLightmap();
                }
            }, () -> {
                if (p_i225981_1_) {
                    Minecraft.getInstance().gameRenderer.getLightTexture().disableLightmap();
                }
            }, p_i225981_1_);
        }
    }

    public static class OverlayState
    extends BooleanState {
        public OverlayState(boolean p_i225985_1_) {
            super("overlay", () -> {
                if (p_i225985_1_) {
                    Minecraft.getInstance().gameRenderer.getOverlayTexture().setupOverlayColor();
                }
            }, () -> {
                if (p_i225985_1_) {
                    Minecraft.getInstance().gameRenderer.getOverlayTexture().teardownOverlayColor();
                }
            }, p_i225985_1_);
        }
    }

    public static class DiffuseLightingState
    extends BooleanState {
        public DiffuseLightingState(boolean p_i225978_1_) {
            super("diffuse_lighting", () -> {
                if (p_i225978_1_) {
                    RenderHelper.enableStandardItemLighting();
                }
            }, () -> {
                if (p_i225978_1_) {
                    RenderHelper.disableStandardItemLighting();
                }
            }, p_i225978_1_);
        }
    }

    public static class CullState
    extends BooleanState {
        public CullState(boolean p_i225976_1_) {
            super("cull", () -> {
                if (!p_i225976_1_) {
                    RenderSystem.disableCull();
                }
            }, () -> {
                if (!p_i225976_1_) {
                    RenderSystem.enableCull();
                }
            }, p_i225976_1_);
        }
    }

    public static class DepthTestState
    extends RenderState {
        private final String field_239256_X_;
        private final int func;

        public DepthTestState(String p_i232464_1_, int p_i232464_2_) {
            super("depth_test", () -> {
                if (p_i232464_2_ != 519) {
                    RenderSystem.enableDepthTest();
                    RenderSystem.depthFunc(p_i232464_2_);
                }
            }, () -> {
                if (p_i232464_2_ != 519) {
                    RenderSystem.disableDepthTest();
                    RenderSystem.depthFunc(515);
                }
            });
            this.field_239256_X_ = p_i232464_1_;
            this.func = p_i232464_2_;
        }

        @Override
        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                DepthTestState renderstate$depthteststate = (DepthTestState)p_equals_1_;
                return this.func == renderstate$depthteststate.func;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.func);
        }

        @Override
        public String toString() {
            return this.name + "[" + this.field_239256_X_ + "]";
        }
    }

    public static class WriteMaskState
    extends RenderState {
        private final boolean colorMask;
        private final boolean depthMask;

        public WriteMaskState(boolean p_i225991_1_, boolean p_i225991_2_) {
            super("write_mask_state", () -> {
                if (!p_i225991_2_) {
                    RenderSystem.depthMask(p_i225991_2_);
                }
                if (!p_i225991_1_) {
                    RenderSystem.colorMask(p_i225991_1_, p_i225991_1_, p_i225991_1_, p_i225991_1_);
                }
            }, () -> {
                if (!p_i225991_2_) {
                    RenderSystem.depthMask(true);
                }
                if (!p_i225991_1_) {
                    RenderSystem.colorMask(true, true, true, true);
                }
            });
            this.colorMask = p_i225991_1_;
            this.depthMask = p_i225991_2_;
        }

        @Override
        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                WriteMaskState renderstate$writemaskstate = (WriteMaskState)p_equals_1_;
                return this.colorMask == renderstate$writemaskstate.colorMask && this.depthMask == renderstate$writemaskstate.depthMask;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return CompareUtils.hash(this.colorMask, this.depthMask);
        }

        @Override
        public String toString() {
            return this.name + "[writeColor=" + this.colorMask + ", writeDepth=" + this.depthMask + "]";
        }
    }

    public static class LayerState
    extends RenderState {
        public LayerState(String p_i225980_1_, Runnable p_i225980_2_, Runnable p_i225980_3_) {
            super(p_i225980_1_, p_i225980_2_, p_i225980_3_);
        }
    }

    public static class FogState
    extends RenderState {
        public FogState(String p_i225979_1_, Runnable p_i225979_2_, Runnable p_i225979_3_) {
            super(p_i225979_1_, p_i225979_2_, p_i225979_3_);
        }
    }

    public static class TargetState
    extends RenderState {
        public TargetState(String p_i225984_1_, Runnable p_i225984_2_, Runnable p_i225984_3_) {
            super(p_i225984_1_, p_i225984_2_, p_i225984_3_);
        }
    }

    public static class LineState
    extends RenderState {
        private final OptionalDouble width;

        public LineState(OptionalDouble p_i225982_1_) {
            super("line_width", () -> {
                if (!Objects.equals(p_i225982_1_, OptionalDouble.of(1.0))) {
                    if (p_i225982_1_.isPresent()) {
                        RenderSystem.lineWidth((float)p_i225982_1_.getAsDouble());
                    } else {
                        RenderSystem.lineWidth(Math.max(2.5f, (float)Minecraft.getInstance().getMainWindow().getFramebufferWidth() / 1920.0f * 2.5f));
                    }
                }
            }, () -> {
                if (!Objects.equals(p_i225982_1_, OptionalDouble.of(1.0))) {
                    RenderSystem.lineWidth(1.0f);
                }
            });
            this.width = p_i225982_1_;
        }

        @Override
        public boolean equals(@Nullable Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                return !super.equals(p_equals_1_) ? false : Objects.equals(this.width, ((LineState)p_equals_1_).width);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return CompareUtils.hash(super.hashCode(), (Object)this.width);
        }

        @Override
        public String toString() {
            return this.name + "[" + String.valueOf(this.width.isPresent() ? Double.valueOf(this.width.getAsDouble()) : "window_scale") + "]";
        }
    }

    public static final class PortalTexturingState
    extends TexturingState {
        private final int iteration;

        public PortalTexturingState(int p_i225986_1_) {
            super("portal_texturing", () -> {
                RenderSystem.matrixMode(5890);
                RenderSystem.pushMatrix();
                RenderSystem.loadIdentity();
                RenderSystem.translatef(0.5f, 0.5f, 0.0f);
                RenderSystem.scalef(0.5f, 0.5f, 1.0f);
                RenderSystem.translatef(17.0f / (float)p_i225986_1_, (2.0f + (float)p_i225986_1_ / 1.5f) * ((float)(Util.milliTime() % 800000L) / 800000.0f), 0.0f);
                RenderSystem.rotatef(((float)(p_i225986_1_ * p_i225986_1_) * 4321.0f + (float)p_i225986_1_ * 9.0f) * 2.0f, 0.0f, 0.0f, 1.0f);
                RenderSystem.scalef(4.5f - (float)p_i225986_1_ / 4.0f, 4.5f - (float)p_i225986_1_ / 4.0f, 1.0f);
                RenderSystem.mulTextureByProjModelView();
                RenderSystem.matrixMode(5888);
                RenderSystem.setupEndPortalTexGen();
            }, () -> {
                RenderSystem.matrixMode(5890);
                RenderSystem.popMatrix();
                RenderSystem.matrixMode(5888);
                RenderSystem.clearTexGen();
            });
            this.iteration = p_i225986_1_;
        }

        @Override
        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                PortalTexturingState renderstate$portaltexturingstate = (PortalTexturingState)p_equals_1_;
                return this.iteration == renderstate$portaltexturingstate.iteration;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.iteration);
        }
    }

    public static final class OffsetTexturingState
    extends TexturingState {
        private final float offsetU;
        private final float offsetV;

        public OffsetTexturingState(float p_i225983_1_, float p_i225983_2_) {
            super("offset_texturing", () -> {
                RenderSystem.matrixMode(5890);
                RenderSystem.pushMatrix();
                RenderSystem.loadIdentity();
                RenderSystem.translatef(p_i225983_1_, p_i225983_2_, 0.0f);
                RenderSystem.matrixMode(5888);
            }, () -> {
                RenderSystem.matrixMode(5890);
                RenderSystem.popMatrix();
                RenderSystem.matrixMode(5888);
            });
            this.offsetU = p_i225983_1_;
            this.offsetV = p_i225983_2_;
        }

        @Override
        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                OffsetTexturingState renderstate$offsettexturingstate = (OffsetTexturingState)p_equals_1_;
                return Float.compare(renderstate$offsettexturingstate.offsetU, this.offsetU) == 0 && Float.compare(renderstate$offsettexturingstate.offsetV, this.offsetV) == 0;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return CompareUtils.hash(this.offsetU, this.offsetV);
        }
    }

    static class BooleanState
    extends RenderState {
        private final boolean enabled;

        public BooleanState(String p_i225975_1_, Runnable p_i225975_2_, Runnable p_i225975_3_, boolean p_i225975_4_) {
            super(p_i225975_1_, p_i225975_2_, p_i225975_3_);
            this.enabled = p_i225975_4_;
        }

        @Override
        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                BooleanState renderstate$booleanstate = (BooleanState)p_equals_1_;
                return this.enabled == renderstate$booleanstate.enabled;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Boolean.hashCode(this.enabled);
        }

        @Override
        public String toString() {
            return this.name + "[" + this.enabled + "]";
        }
    }
}

