/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.IllagerRenderer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.model.IllagerModel;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class IllusionerRenderer
extends IllagerRenderer<IllusionerEntity> {
    private static final ResourceLocation ILLUSIONIST = new ResourceLocation("textures/entity/illager/illusioner.png");

    public IllusionerRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new IllagerModel(0.0f, 0.0f, 64, 64), 0.5f);
        this.addLayer(new HeldItemLayer<IllusionerEntity, IllagerModel<IllusionerEntity>>((IEntityRenderer)this){

            @Override
            public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, IllusionerEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                if (entitylivingbaseIn.isSpellcasting() || entitylivingbaseIn.isAggressive()) {
                    super.render(matrixStackIn, bufferIn, packedLightIn, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                }
            }
        });
        ((IllagerModel)this.entityModel).func_205062_a().showModel = true;
    }

    @Override
    public ResourceLocation getEntityTexture(IllusionerEntity entity) {
        return ILLUSIONIST;
    }

    @Override
    public void render(IllusionerEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (entityIn.isInvisible()) {
            Vector3d[] avector3d = entityIn.getRenderLocations(partialTicks);
            float f = this.handleRotationFloat(entityIn, partialTicks);
            for (int i = 0; i < avector3d.length; ++i) {
                matrixStackIn.push();
                matrixStackIn.translate(avector3d[i].x + (double)MathHelper.cos((float)i + f * 0.5f) * 0.025, avector3d[i].y + (double)MathHelper.cos((float)i + f * 0.75f) * 0.0125, avector3d[i].z + (double)MathHelper.cos((float)i + f * 0.7f) * 0.025);
                super.render(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
                matrixStackIn.pop();
            }
        } else {
            super.render(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    @Override
    protected boolean isVisible(IllusionerEntity livingEntityIn) {
        return true;
    }
}

