/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;
import net.optifine.EmissiveTextures;

public abstract class Model
implements Consumer<ModelRenderer> {
    protected final Function<ResourceLocation, RenderType> renderType;
    public int textureWidth = 64;
    public int textureHeight = 32;

    public Model(Function<ResourceLocation, RenderType> renderTypeIn) {
        this.renderType = renderTypeIn;
    }

    @Override
    public void accept(ModelRenderer p_accept_1_) {
    }

    public final RenderType getRenderType(ResourceLocation locationIn) {
        RenderType rendertype = this.renderType.apply(locationIn);
        if (EmissiveTextures.isRenderEmissive() && rendertype.isEntitySolid()) {
            rendertype = RenderType.getEntityCutout(locationIn);
        }
        return rendertype;
    }

    public abstract void render(MatrixStack var1, IVertexBuilder var2, int var3, int var4, float var5, float var6, float var7, float var8);
}

