/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.vertex;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.optifine.Config;
import net.optifine.shaders.SVertexFormat;

public class DefaultVertexFormats {
    public static final VertexFormatElement POSITION_3F = new VertexFormatElement(0, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.POSITION, 3);
    public static final VertexFormatElement COLOR_4UB = new VertexFormatElement(0, VertexFormatElement.Type.UBYTE, VertexFormatElement.Usage.COLOR, 4);
    public static final VertexFormatElement TEX_2F = new VertexFormatElement(0, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.UV, 2);
    public static final VertexFormatElement TEX_2S = new VertexFormatElement(1, VertexFormatElement.Type.SHORT, VertexFormatElement.Usage.UV, 2);
    public static final VertexFormatElement TEX_2SB = new VertexFormatElement(2, VertexFormatElement.Type.SHORT, VertexFormatElement.Usage.UV, 2);
    public static final VertexFormatElement NORMAL_3B = new VertexFormatElement(0, VertexFormatElement.Type.BYTE, VertexFormatElement.Usage.NORMAL, 3);
    public static final VertexFormatElement PADDING_1B = new VertexFormatElement(0, VertexFormatElement.Type.BYTE, VertexFormatElement.Usage.PADDING, 1);
    public static VertexFormat BLOCK = new VertexFormat((ImmutableList<VertexFormatElement>)ImmutableList.builder().add((Object)POSITION_3F).add((Object)COLOR_4UB).add((Object)TEX_2F).add((Object)TEX_2SB).add((Object)NORMAL_3B).add((Object)PADDING_1B).build());
    public static VertexFormat ENTITY = new VertexFormat((ImmutableList<VertexFormatElement>)ImmutableList.builder().add((Object)POSITION_3F).add((Object)COLOR_4UB).add((Object)TEX_2F).add((Object)TEX_2S).add((Object)TEX_2SB).add((Object)NORMAL_3B).add((Object)PADDING_1B).build());
    private static final VertexFormat BLOCK_VANILLA = BLOCK;
    private static final VertexFormat BLOCK_SHADERS = SVertexFormat.makeExtendedFormatBlock(BLOCK_VANILLA);
    public static final int BLOCK_VANILLA_SIZE = BLOCK_VANILLA.getSize();
    public static final int BLOCK_SHADERS_SIZE = BLOCK_SHADERS.getSize();
    @Deprecated
    public static final VertexFormat PARTICLE_POSITION_TEX_COLOR_LMAP = new VertexFormat((ImmutableList<VertexFormatElement>)ImmutableList.builder().add((Object)POSITION_3F).add((Object)TEX_2F).add((Object)COLOR_4UB).add((Object)TEX_2SB).build());
    public static final VertexFormat POSITION = new VertexFormat((ImmutableList<VertexFormatElement>)ImmutableList.builder().add((Object)POSITION_3F).build());
    public static final VertexFormat POSITION_COLOR = new VertexFormat((ImmutableList<VertexFormatElement>)ImmutableList.builder().add((Object)POSITION_3F).add((Object)COLOR_4UB).build());
    public static final VertexFormat POSITION_COLOR_LIGHTMAP = new VertexFormat((ImmutableList<VertexFormatElement>)ImmutableList.builder().add((Object)POSITION_3F).add((Object)COLOR_4UB).add((Object)TEX_2SB).build());
    public static final VertexFormat POSITION_TEX = new VertexFormat((ImmutableList<VertexFormatElement>)ImmutableList.builder().add((Object)POSITION_3F).add((Object)TEX_2F).build());
    public static final VertexFormat POSITION_COLOR_TEX = new VertexFormat((ImmutableList<VertexFormatElement>)ImmutableList.builder().add((Object)POSITION_3F).add((Object)COLOR_4UB).add((Object)TEX_2F).build());
    @Deprecated
    public static final VertexFormat POSITION_TEX_COLOR = new VertexFormat((ImmutableList<VertexFormatElement>)ImmutableList.builder().add((Object)POSITION_3F).add((Object)TEX_2F).add((Object)COLOR_4UB).build());
    public static final VertexFormat POSITION_COLOR_TEX_LIGHTMAP = new VertexFormat((ImmutableList<VertexFormatElement>)ImmutableList.builder().add((Object)POSITION_3F).add((Object)COLOR_4UB).add((Object)TEX_2F).add((Object)TEX_2SB).build());
    @Deprecated
    public static final VertexFormat POSITION_TEX_LIGHTMAP_COLOR = new VertexFormat((ImmutableList<VertexFormatElement>)ImmutableList.builder().add((Object)POSITION_3F).add((Object)TEX_2F).add((Object)TEX_2SB).add((Object)COLOR_4UB).build());
    @Deprecated
    public static final VertexFormat POSITION_TEX_COLOR_NORMAL = new VertexFormat((ImmutableList<VertexFormatElement>)ImmutableList.builder().add((Object)POSITION_3F).add((Object)TEX_2F).add((Object)COLOR_4UB).add((Object)NORMAL_3B).add((Object)PADDING_1B).build());

    public static void updateVertexFormats() {
        BLOCK = Config.isShaders() ? BLOCK_SHADERS : BLOCK_VANILLA;
    }
}

