/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.data.LanguageMetadataSection;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.JSONUtils;

public class LanguageMetadataSectionSerializer
implements IMetadataSectionSerializer<LanguageMetadataSection> {
    @Override
    public LanguageMetadataSection deserialize(JsonObject json) {
        HashSet set = Sets.newHashSet();
        for (Map.Entry entry : json.entrySet()) {
            String s = (String)entry.getKey();
            if (s.length() > 16) {
                throw new JsonParseException("Invalid language->'" + s + "': language code must not be more than 16 characters long");
            }
            JsonObject jsonobject = JSONUtils.getJsonObject((JsonElement)entry.getValue(), "language");
            String s1 = JSONUtils.getString(jsonobject, "region");
            String s2 = JSONUtils.getString(jsonobject, "name");
            boolean flag = JSONUtils.getBoolean(jsonobject, "bidirectional", false);
            if (s1.isEmpty()) {
                throw new JsonParseException("Invalid language->'" + s + "'->region: empty value");
            }
            if (s2.isEmpty()) {
                throw new JsonParseException("Invalid language->'" + s + "'->name: empty value");
            }
            if (set.add(new Language(s, s1, s2, flag))) continue;
            throw new JsonParseException("Duplicate language->'" + s + "' defined");
        }
        return new LanguageMetadataSection(set);
    }

    @Override
    public String getSectionName() {
        return "language";
    }
}

