/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.World;

public interface ISuggestionProvider {
    public Collection<String> getPlayerNames();

    default public Collection<String> getTargetedEntity() {
        return Collections.emptyList();
    }

    public Collection<String> getTeamNames();

    public Collection<ResourceLocation> getSoundResourceLocations();

    public Stream<ResourceLocation> getRecipeResourceLocations();

    public CompletableFuture<Suggestions> getSuggestionsFromServer(CommandContext<ISuggestionProvider> var1, SuggestionsBuilder var2);

    default public Collection<Coordinates> func_217294_q() {
        return Collections.singleton(Coordinates.DEFAULT_GLOBAL);
    }

    default public Collection<Coordinates> func_217293_r() {
        return Collections.singleton(Coordinates.DEFAULT_GLOBAL);
    }

    public Set<RegistryKey<World>> func_230390_p_();

    public DynamicRegistries func_241861_q();

    public boolean hasPermissionLevel(int var1);

    public static <T> void func_210512_a(Iterable<T> p_210512_0_, String p_210512_1_, Function<T, ResourceLocation> p_210512_2_, Consumer<T> p_210512_3_) {
        boolean flag = p_210512_1_.indexOf(58) > -1;
        for (T t : p_210512_0_) {
            ResourceLocation resourcelocation = p_210512_2_.apply(t);
            if (flag) {
                String s = resourcelocation.toString();
                if (!ISuggestionProvider.func_237256_a_(p_210512_1_, s)) continue;
                p_210512_3_.accept(t);
                continue;
            }
            if (!ISuggestionProvider.func_237256_a_(p_210512_1_, resourcelocation.getNamespace()) && (!resourcelocation.getNamespace().equals("minecraft") || !ISuggestionProvider.func_237256_a_(p_210512_1_, resourcelocation.getPath()))) continue;
            p_210512_3_.accept(t);
        }
    }

    public static <T> void func_210511_a(Iterable<T> p_210511_0_, String p_210511_1_, String p_210511_2_, Function<T, ResourceLocation> p_210511_3_, Consumer<T> p_210511_4_) {
        if (p_210511_1_.isEmpty()) {
            p_210511_0_.forEach(p_210511_4_);
        } else {
            String s = Strings.commonPrefix((CharSequence)p_210511_1_, (CharSequence)p_210511_2_);
            if (!s.isEmpty()) {
                String s1 = p_210511_1_.substring(s.length());
                ISuggestionProvider.func_210512_a(p_210511_0_, s1, p_210511_3_, p_210511_4_);
            }
        }
    }

    public static CompletableFuture<Suggestions> suggestIterable(Iterable<ResourceLocation> p_197006_0_, SuggestionsBuilder p_197006_1_, String prefix) {
        String s = p_197006_1_.getRemaining().toLowerCase(Locale.ROOT);
        ISuggestionProvider.func_210511_a(p_197006_0_, s, prefix, p_210519_0_ -> p_210519_0_, p_210518_2_ -> p_197006_1_.suggest(prefix + String.valueOf(p_210518_2_)));
        return p_197006_1_.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggestIterable(Iterable<ResourceLocation> p_197014_0_, SuggestionsBuilder builder) {
        String s = builder.getRemaining().toLowerCase(Locale.ROOT);
        ISuggestionProvider.func_210512_a(p_197014_0_, s, p_210517_0_ -> p_210517_0_, p_210513_1_ -> builder.suggest(p_210513_1_.toString()));
        return builder.buildFuture();
    }

    public static <T> CompletableFuture<Suggestions> func_210514_a(Iterable<T> p_210514_0_, SuggestionsBuilder builder, Function<T, ResourceLocation> p_210514_2_, Function<T, Message> p_210514_3_) {
        String s = builder.getRemaining().toLowerCase(Locale.ROOT);
        ISuggestionProvider.func_210512_a(p_210514_0_, s, p_210514_2_, p_210515_3_ -> builder.suggest(((ResourceLocation)p_210514_2_.apply(p_210515_3_)).toString(), (Message)p_210514_3_.apply(p_210515_3_)));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> func_212476_a(Stream<ResourceLocation> p_212476_0_, SuggestionsBuilder builder) {
        return ISuggestionProvider.suggestIterable(p_212476_0_::iterator, builder);
    }

    public static <T> CompletableFuture<Suggestions> func_201725_a(Stream<T> p_201725_0_, SuggestionsBuilder builder, Function<T, ResourceLocation> p_201725_2_, Function<T, Message> p_201725_3_) {
        return ISuggestionProvider.func_210514_a(p_201725_0_::iterator, builder, p_201725_2_, p_201725_3_);
    }

    public static CompletableFuture<Suggestions> func_209000_a(String p_209000_0_, Collection<Coordinates> p_209000_1_, SuggestionsBuilder builder, Predicate<String> p_209000_3_) {
        ArrayList list;
        block4: {
            String[] astring;
            block5: {
                block3: {
                    list = Lists.newArrayList();
                    if (!Strings.isNullOrEmpty((String)p_209000_0_)) break block3;
                    for (Coordinates isuggestionprovider$coordinates : p_209000_1_) {
                        String s = isuggestionprovider$coordinates.x + " " + isuggestionprovider$coordinates.y + " " + isuggestionprovider$coordinates.z;
                        if (!p_209000_3_.test(s)) continue;
                        list.add(isuggestionprovider$coordinates.x);
                        list.add(isuggestionprovider$coordinates.x + " " + isuggestionprovider$coordinates.y);
                        list.add(s);
                    }
                    break block4;
                }
                astring = p_209000_0_.split(" ");
                if (astring.length != 1) break block5;
                for (Coordinates isuggestionprovider$coordinates1 : p_209000_1_) {
                    String s1 = astring[0] + " " + isuggestionprovider$coordinates1.y + " " + isuggestionprovider$coordinates1.z;
                    if (!p_209000_3_.test(s1)) continue;
                    list.add(astring[0] + " " + isuggestionprovider$coordinates1.y);
                    list.add(s1);
                }
                break block4;
            }
            if (astring.length != 2) break block4;
            for (Coordinates isuggestionprovider$coordinates2 : p_209000_1_) {
                String s2 = astring[0] + " " + astring[1] + " " + isuggestionprovider$coordinates2.z;
                if (!p_209000_3_.test(s2)) continue;
                list.add(s2);
            }
        }
        return ISuggestionProvider.suggest(list, builder);
    }

    public static CompletableFuture<Suggestions> func_211269_a(String p_211269_0_, Collection<Coordinates> p_211269_1_, SuggestionsBuilder builder, Predicate<String> p_211269_3_) {
        ArrayList list;
        block3: {
            block2: {
                list = Lists.newArrayList();
                if (!Strings.isNullOrEmpty((String)p_211269_0_)) break block2;
                for (Coordinates isuggestionprovider$coordinates : p_211269_1_) {
                    String s = isuggestionprovider$coordinates.x + " " + isuggestionprovider$coordinates.z;
                    if (!p_211269_3_.test(s)) continue;
                    list.add(isuggestionprovider$coordinates.x);
                    list.add(s);
                }
                break block3;
            }
            String[] astring = p_211269_0_.split(" ");
            if (astring.length != 1) break block3;
            for (Coordinates isuggestionprovider$coordinates1 : p_211269_1_) {
                String s1 = astring[0] + " " + isuggestionprovider$coordinates1.z;
                if (!p_211269_3_.test(s1)) continue;
                list.add(s1);
            }
        }
        return ISuggestionProvider.suggest(list, builder);
    }

    public static CompletableFuture<Suggestions> suggest(Iterable<String> p_197005_0_, SuggestionsBuilder builder) {
        String s = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (String s1 : p_197005_0_) {
            if (!ISuggestionProvider.func_237256_a_(s, s1.toLowerCase(Locale.ROOT))) continue;
            builder.suggest(s1);
        }
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggest(Stream<String> p_197013_0_, SuggestionsBuilder builder) {
        String s = builder.getRemaining().toLowerCase(Locale.ROOT);
        p_197013_0_.filter(p_197007_1_ -> ISuggestionProvider.func_237256_a_(s, p_197007_1_.toLowerCase(Locale.ROOT))).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggest(String[] p_197008_0_, SuggestionsBuilder builder) {
        String s = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (String s1 : p_197008_0_) {
            if (!ISuggestionProvider.func_237256_a_(s, s1.toLowerCase(Locale.ROOT))) continue;
            builder.suggest(s1);
        }
        return builder.buildFuture();
    }

    public static boolean func_237256_a_(String p_237256_0_, String p_237256_1_) {
        int i = 0;
        while (!p_237256_1_.startsWith(p_237256_0_, i)) {
            if ((i = p_237256_1_.indexOf(95, i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static class Coordinates {
        public static final Coordinates DEFAULT_LOCAL = new Coordinates("^", "^", "^");
        public static final Coordinates DEFAULT_GLOBAL = new Coordinates("~", "~", "~");
        public final String x;
        public final String y;
        public final String z;

        public Coordinates(String xIn, String yIn, String zIn) {
            this.x = xIn;
            this.y = yIn;
            this.z = zIn;
        }
    }
}

