/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments.serializers;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.command.arguments.serializers.BrigadierSerializers;
import net.minecraft.network.PacketBuffer;

public class DoubleArgumentSerializer
implements IArgumentSerializer<DoubleArgumentType> {
    @Override
    public void write(DoubleArgumentType argument, PacketBuffer buffer) {
        boolean flag = argument.getMinimum() != -1.7976931348623157E308;
        boolean flag1 = argument.getMaximum() != Double.MAX_VALUE;
        buffer.writeByte(BrigadierSerializers.minMaxFlags(flag, flag1));
        if (flag) {
            buffer.writeDouble(argument.getMinimum());
        }
        if (flag1) {
            buffer.writeDouble(argument.getMaximum());
        }
    }

    @Override
    public DoubleArgumentType read(PacketBuffer buffer) {
        byte b0 = buffer.readByte();
        double d0 = BrigadierSerializers.hasMin(b0) ? buffer.readDouble() : -1.7976931348623157E308;
        double d1 = BrigadierSerializers.hasMax(b0) ? buffer.readDouble() : Double.MAX_VALUE;
        return DoubleArgumentType.doubleArg((double)d0, (double)d1);
    }

    @Override
    public void write(DoubleArgumentType p_212244_1_, JsonObject p_212244_2_) {
        if (p_212244_1_.getMinimum() != -1.7976931348623157E308) {
            p_212244_2_.addProperty("min", (Number)p_212244_1_.getMinimum());
        }
        if (p_212244_1_.getMaximum() != Double.MAX_VALUE) {
            p_212244_2_.addProperty("max", (Number)p_212244_1_.getMaximum());
        }
    }
}

