/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.LocationInput;
import net.minecraft.command.arguments.RotationArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;

public class TeleportCommand {
    private static final SimpleCommandExceptionType field_241077_a_ = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.teleport.invalidPosition"));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralCommandNode literalcommandnode = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("teleport").requires(p_198816_0_ -> p_198816_0_.hasPermissionLevel(2))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.entities()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("location", Vec3Argument.vec3()).executes(p_198807_0_ -> TeleportCommand.teleportToPos((CommandSource)p_198807_0_.getSource(), EntityArgument.getEntities((CommandContext<CommandSource>)p_198807_0_, "targets"), ((CommandSource)p_198807_0_.getSource()).getWorld(), Vec3Argument.getLocation((CommandContext<CommandSource>)p_198807_0_, "location"), null, null))).then(Commands.argument("rotation", RotationArgument.rotation()).executes(p_198811_0_ -> TeleportCommand.teleportToPos((CommandSource)p_198811_0_.getSource(), EntityArgument.getEntities((CommandContext<CommandSource>)p_198811_0_, "targets"), ((CommandSource)p_198811_0_.getSource()).getWorld(), Vec3Argument.getLocation((CommandContext<CommandSource>)p_198811_0_, "location"), RotationArgument.getRotation((CommandContext<CommandSource>)p_198811_0_, "rotation"), null)))).then(((LiteralArgumentBuilder)Commands.literal("facing").then(Commands.literal("entity").then(((RequiredArgumentBuilder)Commands.argument("facingEntity", EntityArgument.entity()).executes(p_198806_0_ -> TeleportCommand.teleportToPos((CommandSource)p_198806_0_.getSource(), EntityArgument.getEntities((CommandContext<CommandSource>)p_198806_0_, "targets"), ((CommandSource)p_198806_0_.getSource()).getWorld(), Vec3Argument.getLocation((CommandContext<CommandSource>)p_198806_0_, "location"), null, new Facing(EntityArgument.getEntity((CommandContext<CommandSource>)p_198806_0_, "facingEntity"), EntityAnchorArgument.Type.FEET)))).then(Commands.argument("facingAnchor", EntityAnchorArgument.entityAnchor()).executes(p_198812_0_ -> TeleportCommand.teleportToPos((CommandSource)p_198812_0_.getSource(), EntityArgument.getEntities((CommandContext<CommandSource>)p_198812_0_, "targets"), ((CommandSource)p_198812_0_.getSource()).getWorld(), Vec3Argument.getLocation((CommandContext<CommandSource>)p_198812_0_, "location"), null, new Facing(EntityArgument.getEntity((CommandContext<CommandSource>)p_198812_0_, "facingEntity"), EntityAnchorArgument.getEntityAnchor((CommandContext<CommandSource>)p_198812_0_, "facingAnchor")))))))).then(Commands.argument("facingLocation", Vec3Argument.vec3()).executes(p_198805_0_ -> TeleportCommand.teleportToPos((CommandSource)p_198805_0_.getSource(), EntityArgument.getEntities((CommandContext<CommandSource>)p_198805_0_, "targets"), ((CommandSource)p_198805_0_.getSource()).getWorld(), Vec3Argument.getLocation((CommandContext<CommandSource>)p_198805_0_, "location"), null, new Facing(Vec3Argument.getVec3((CommandContext<CommandSource>)p_198805_0_, "facingLocation")))))))).then(Commands.argument("destination", EntityArgument.entity()).executes(p_198814_0_ -> TeleportCommand.teleportToEntity((CommandSource)p_198814_0_.getSource(), EntityArgument.getEntities((CommandContext<CommandSource>)p_198814_0_, "targets"), EntityArgument.getEntity((CommandContext<CommandSource>)p_198814_0_, "destination")))))).then(Commands.argument("location", Vec3Argument.vec3()).executes(p_200560_0_ -> TeleportCommand.teleportToPos((CommandSource)p_200560_0_.getSource(), Collections.singleton(((CommandSource)p_200560_0_.getSource()).assertIsEntity()), ((CommandSource)p_200560_0_.getSource()).getWorld(), Vec3Argument.getLocation((CommandContext<CommandSource>)p_200560_0_, "location"), LocationInput.current(), null)))).then(Commands.argument("destination", EntityArgument.entity()).executes(p_200562_0_ -> TeleportCommand.teleportToEntity((CommandSource)p_200562_0_.getSource(), Collections.singleton(((CommandSource)p_200562_0_.getSource()).assertIsEntity()), EntityArgument.getEntity((CommandContext<CommandSource>)p_200562_0_, "destination")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("tp").requires(p_200556_0_ -> p_200556_0_.hasPermissionLevel(2))).redirect((CommandNode)literalcommandnode));
    }

    private static int teleportToEntity(CommandSource source, Collection<? extends Entity> targets, Entity destination) throws CommandSyntaxException {
        for (Entity entity : targets) {
            TeleportCommand.teleport(source, entity, (ServerWorld)destination.world, destination.getPosX(), destination.getPosY(), destination.getPosZ(), EnumSet.noneOf(SPlayerPositionLookPacket.Flags.class), destination.rotationYaw, destination.rotationPitch, null);
        }
        if (targets.size() == 1) {
            source.sendFeedback(new TranslationTextComponent("commands.teleport.success.entity.single", targets.iterator().next().getDisplayName(), destination.getDisplayName()), true);
        } else {
            source.sendFeedback(new TranslationTextComponent("commands.teleport.success.entity.multiple", targets.size(), destination.getDisplayName()), true);
        }
        return targets.size();
    }

    private static int teleportToPos(CommandSource source, Collection<? extends Entity> targets, ServerWorld worldIn, ILocationArgument position, @Nullable ILocationArgument rotationIn, @Nullable Facing facing) throws CommandSyntaxException {
        Vector3d vector3d = position.getPosition(source);
        Vector2f vector2f = rotationIn == null ? null : rotationIn.getRotation(source);
        EnumSet<SPlayerPositionLookPacket.Flags> set = EnumSet.noneOf(SPlayerPositionLookPacket.Flags.class);
        if (position.isXRelative()) {
            set.add(SPlayerPositionLookPacket.Flags.X);
        }
        if (position.isYRelative()) {
            set.add(SPlayerPositionLookPacket.Flags.Y);
        }
        if (position.isZRelative()) {
            set.add(SPlayerPositionLookPacket.Flags.Z);
        }
        if (rotationIn == null) {
            set.add(SPlayerPositionLookPacket.Flags.X_ROT);
            set.add(SPlayerPositionLookPacket.Flags.Y_ROT);
        } else {
            if (rotationIn.isXRelative()) {
                set.add(SPlayerPositionLookPacket.Flags.X_ROT);
            }
            if (rotationIn.isYRelative()) {
                set.add(SPlayerPositionLookPacket.Flags.Y_ROT);
            }
        }
        for (Entity entity : targets) {
            if (rotationIn == null) {
                TeleportCommand.teleport(source, entity, worldIn, vector3d.x, vector3d.y, vector3d.z, set, entity.rotationYaw, entity.rotationPitch, facing);
                continue;
            }
            TeleportCommand.teleport(source, entity, worldIn, vector3d.x, vector3d.y, vector3d.z, set, vector2f.y, vector2f.x, facing);
        }
        if (targets.size() == 1) {
            source.sendFeedback(new TranslationTextComponent("commands.teleport.success.location.single", targets.iterator().next().getDisplayName(), vector3d.x, vector3d.y, vector3d.z), true);
        } else {
            source.sendFeedback(new TranslationTextComponent("commands.teleport.success.location.multiple", targets.size(), vector3d.x, vector3d.y, vector3d.z), true);
        }
        return targets.size();
    }

    private static void teleport(CommandSource source, Entity entityIn, ServerWorld worldIn, double x, double y, double z, Set<SPlayerPositionLookPacket.Flags> relativeList, float yaw, float pitch, @Nullable Facing facing) throws CommandSyntaxException {
        BlockPos blockpos = new BlockPos(x, y, z);
        if (!World.isInvalidPosition(blockpos)) {
            throw field_241077_a_.create();
        }
        if (entityIn instanceof ServerPlayerEntity) {
            ChunkPos chunkpos = new ChunkPos(new BlockPos(x, y, z));
            worldIn.getChunkProvider().registerTicket(TicketType.POST_TELEPORT, chunkpos, 1, entityIn.getEntityId());
            entityIn.stopRiding();
            if (((ServerPlayerEntity)entityIn).isSleeping()) {
                ((ServerPlayerEntity)entityIn).stopSleepInBed(true, true);
            }
            if (worldIn == entityIn.world) {
                ((ServerPlayerEntity)entityIn).connection.setPlayerLocation(x, y, z, yaw, pitch, relativeList);
            } else {
                ((ServerPlayerEntity)entityIn).teleport(worldIn, x, y, z, yaw, pitch);
            }
            entityIn.setRotationYawHead(yaw);
        } else {
            float f1 = MathHelper.wrapDegrees(yaw);
            float f = MathHelper.wrapDegrees(pitch);
            f = MathHelper.clamp(f, -90.0f, 90.0f);
            if (worldIn == entityIn.world) {
                entityIn.setLocationAndAngles(x, y, z, f1, f);
                entityIn.setRotationYawHead(f1);
            } else {
                entityIn.detach();
                Entity entity = entityIn;
                entityIn = entityIn.getType().create(worldIn);
                if (entityIn == null) {
                    return;
                }
                entityIn.copyDataFromOld(entity);
                entityIn.setLocationAndAngles(x, y, z, f1, f);
                entityIn.setRotationYawHead(f1);
                worldIn.addFromAnotherDimension(entityIn);
                entity.removed = true;
            }
        }
        if (facing != null) {
            facing.updateLook(source, entityIn);
        }
        if (!(entityIn instanceof LivingEntity) || !((LivingEntity)entityIn).isElytraFlying()) {
            entityIn.setMotion(entityIn.getMotion().mul(1.0, 0.0, 1.0));
            entityIn.setOnGround(true);
        }
        if (entityIn instanceof CreatureEntity) {
            ((CreatureEntity)entityIn).getNavigator().clearPath();
        }
    }

    static class Facing {
        private final Vector3d position;
        private final Entity entity;
        private final EntityAnchorArgument.Type anchor;

        public Facing(Entity entityIn, EntityAnchorArgument.Type anchorIn) {
            this.entity = entityIn;
            this.anchor = anchorIn;
            this.position = anchorIn.apply(entityIn);
        }

        public Facing(Vector3d positionIn) {
            this.entity = null;
            this.position = positionIn;
            this.anchor = null;
        }

        public void updateLook(CommandSource source, Entity entityIn) {
            if (this.entity != null) {
                if (entityIn instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)entityIn).lookAt(source.getEntityAnchorType(), this.entity, this.anchor);
                } else {
                    entityIn.lookAt(source.getEntityAnchorType(), this.position);
                }
            } else {
                entityIn.lookAt(source.getEntityAnchorType(), this.position);
            }
        }
    }
}

