/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.PanicTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.world.server.ServerWorld;

public class ClearHurtTask
extends Task<VillagerEntity> {
    public ClearHurtTask() {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of());
    }

    @Override
    protected void startExecuting(ServerWorld worldIn, VillagerEntity entityIn, long gameTimeIn) {
        boolean flag;
        boolean bl = flag = PanicTask.hasBeenHurt(entityIn) || PanicTask.hostileNearby(entityIn) || ClearHurtTask.isAttackerWithinDistance(entityIn);
        if (!flag) {
            entityIn.getBrain().removeMemory(MemoryModuleType.HURT_BY);
            entityIn.getBrain().removeMemory(MemoryModuleType.HURT_BY_ENTITY);
            entityIn.getBrain().updateActivity(worldIn.getDayTime(), worldIn.getGameTime());
        }
    }

    private static boolean isAttackerWithinDistance(VillagerEntity villager) {
        return villager.getBrain().getMemory(MemoryModuleType.HURT_BY_ENTITY).filter(attacker -> attacker.getDistanceSq(villager) <= 36.0).isPresent();
    }
}

