/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.brain.task;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.AssignProfessionTask;
import net.minecraft.entity.ai.brain.task.BeginRaidTask;
import net.minecraft.entity.ai.brain.task.BoneMealCropsTask;
import net.minecraft.entity.ai.brain.task.CelebrateRaidVictoryTask;
import net.minecraft.entity.ai.brain.task.ChangeJobTask;
import net.minecraft.entity.ai.brain.task.ClearHurtTask;
import net.minecraft.entity.ai.brain.task.CongregateTask;
import net.minecraft.entity.ai.brain.task.CreateBabyVillagerTask;
import net.minecraft.entity.ai.brain.task.DummyTask;
import net.minecraft.entity.ai.brain.task.ExpireHidingTask;
import net.minecraft.entity.ai.brain.task.ExpirePOITask;
import net.minecraft.entity.ai.brain.task.FarmTask;
import net.minecraft.entity.ai.brain.task.FarmerWorkTask;
import net.minecraft.entity.ai.brain.task.FindHidingPlaceDuringRaidTask;
import net.minecraft.entity.ai.brain.task.FindHidingPlaceTask;
import net.minecraft.entity.ai.brain.task.FindInteractionAndLookTargetTask;
import net.minecraft.entity.ai.brain.task.FindJobTask;
import net.minecraft.entity.ai.brain.task.FindPotentialJobTask;
import net.minecraft.entity.ai.brain.task.FindWalkTargetAfterRaidVictoryTask;
import net.minecraft.entity.ai.brain.task.FindWalkTargetTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.ForgetRaidTask;
import net.minecraft.entity.ai.brain.task.GatherPOITask;
import net.minecraft.entity.ai.brain.task.GiveHeroGiftsTask;
import net.minecraft.entity.ai.brain.task.GoOutsideAfterRaidTask;
import net.minecraft.entity.ai.brain.task.HideFromRaidOnBellRingTask;
import net.minecraft.entity.ai.brain.task.InteractWithDoorTask;
import net.minecraft.entity.ai.brain.task.InteractWithEntityTask;
import net.minecraft.entity.ai.brain.task.JumpOnBedTask;
import net.minecraft.entity.ai.brain.task.LookAtEntityTask;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.entity.ai.brain.task.MultiTask;
import net.minecraft.entity.ai.brain.task.PanicTask;
import net.minecraft.entity.ai.brain.task.PickupWantedItemTask;
import net.minecraft.entity.ai.brain.task.RingBellTask;
import net.minecraft.entity.ai.brain.task.RunAwayTask;
import net.minecraft.entity.ai.brain.task.ShareItemsTask;
import net.minecraft.entity.ai.brain.task.ShowWaresTask;
import net.minecraft.entity.ai.brain.task.SleepAtHomeTask;
import net.minecraft.entity.ai.brain.task.SpawnGolemTask;
import net.minecraft.entity.ai.brain.task.StayNearPointTask;
import net.minecraft.entity.ai.brain.task.SwimTask;
import net.minecraft.entity.ai.brain.task.SwitchVillagerJobTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.TradeTask;
import net.minecraft.entity.ai.brain.task.UpdateActivityTask;
import net.minecraft.entity.ai.brain.task.WakeUpTask;
import net.minecraft.entity.ai.brain.task.WalkRandomlyInsideTask;
import net.minecraft.entity.ai.brain.task.WalkToHouseTask;
import net.minecraft.entity.ai.brain.task.WalkToPOITask;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.entity.ai.brain.task.WalkToVillagerBabiesTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsLookTargetTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsPosTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsRandomSecondaryPosTask;
import net.minecraft.entity.ai.brain.task.WorkTask;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.village.PointOfInterestType;

public class VillagerTasks {
    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> core(VillagerProfession profession, float p_220638_1_) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new SwimTask(0.8f)), (Object)Pair.of((Object)0, (Object)new InteractWithDoorTask()), (Object)Pair.of((Object)0, (Object)new LookTask(45, 90)), (Object)Pair.of((Object)0, (Object)new PanicTask()), (Object)Pair.of((Object)0, (Object)new WakeUpTask()), (Object)Pair.of((Object)0, (Object)new HideFromRaidOnBellRingTask()), (Object)Pair.of((Object)0, (Object)new BeginRaidTask()), (Object)Pair.of((Object)0, (Object)new ExpirePOITask(profession.getPointOfInterest(), MemoryModuleType.JOB_SITE)), (Object)Pair.of((Object)0, (Object)new ExpirePOITask(profession.getPointOfInterest(), MemoryModuleType.POTENTIAL_JOB_SITE)), (Object)Pair.of((Object)1, (Object)new WalkToTargetTask()), (Object)Pair.of((Object)2, (Object)new SwitchVillagerJobTask(profession)), (Object)Pair.of((Object)3, (Object)new TradeTask(p_220638_1_)), (Object[])new Pair[]{Pair.of((Object)5, new PickupWantedItemTask(p_220638_1_, false, 4)), Pair.of((Object)6, (Object)new GatherPOITask(profession.getPointOfInterest(), MemoryModuleType.JOB_SITE, MemoryModuleType.POTENTIAL_JOB_SITE, true, Optional.empty())), Pair.of((Object)7, (Object)new FindPotentialJobTask(p_220638_1_)), Pair.of((Object)8, (Object)new FindJobTask(p_220638_1_)), Pair.of((Object)10, (Object)new GatherPOITask(PointOfInterestType.HOME, MemoryModuleType.HOME, false, Optional.of((byte)14))), Pair.of((Object)10, (Object)new GatherPOITask(PointOfInterestType.MEETING, MemoryModuleType.MEETING_POINT, true, Optional.of((byte)14))), Pair.of((Object)10, (Object)new AssignProfessionTask()), Pair.of((Object)10, (Object)new ChangeJobTask())});
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> work(VillagerProfession profession, float p_220639_1_) {
        SpawnGolemTask spawngolemtask = profession == VillagerProfession.FARMER ? new FarmerWorkTask() : new SpawnGolemTask();
        return ImmutableList.of(VillagerTasks.lookAtPlayerOrVillager(), (Object)Pair.of((Object)5, new FirstShuffledTask(ImmutableList.of((Object)Pair.of((Object)spawngolemtask, (Object)7), (Object)Pair.of((Object)new WorkTask(MemoryModuleType.JOB_SITE, 0.4f, 4), (Object)2), (Object)Pair.of((Object)new WalkTowardsPosTask(MemoryModuleType.JOB_SITE, 0.4f, 1, 10), (Object)5), (Object)Pair.of((Object)new WalkTowardsRandomSecondaryPosTask(MemoryModuleType.SECONDARY_JOB_SITE, p_220639_1_, 1, 6, MemoryModuleType.JOB_SITE), (Object)5), (Object)Pair.of((Object)new FarmTask(), (Object)(profession == VillagerProfession.FARMER ? 2 : 5)), (Object)Pair.of((Object)new BoneMealCropsTask(), (Object)(profession == VillagerProfession.FARMER ? 4 : 7))))), (Object)Pair.of((Object)10, (Object)new ShowWaresTask(400, 1600)), (Object)Pair.of((Object)10, (Object)new FindInteractionAndLookTargetTask(EntityType.PLAYER, 4)), (Object)Pair.of((Object)2, (Object)new StayNearPointTask(MemoryModuleType.JOB_SITE, p_220639_1_, 9, 100, 1200)), (Object)Pair.of((Object)3, (Object)new GiveHeroGiftsTask(100)), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> play(float walkingSpeed) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new WalkToTargetTask(80, 120)), VillagerTasks.lookAtMany(), (Object)Pair.of((Object)5, (Object)new WalkToVillagerBabiesTask()), (Object)Pair.of((Object)5, new FirstShuffledTask((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of(MemoryModuleType.VISIBLE_VILLAGER_BABIES, (Object)((Object)MemoryModuleStatus.VALUE_ABSENT)), ImmutableList.of((Object)Pair.of(InteractWithEntityTask.func_220445_a(EntityType.VILLAGER, 8, MemoryModuleType.INTERACTION_TARGET, walkingSpeed, 2), (Object)2), (Object)Pair.of(InteractWithEntityTask.func_220445_a(EntityType.CAT, 8, MemoryModuleType.INTERACTION_TARGET, walkingSpeed, 2), (Object)1), (Object)Pair.of((Object)new FindWalkTargetTask(walkingSpeed), (Object)1), (Object)Pair.of((Object)new WalkTowardsLookTargetTask(walkingSpeed, 2), (Object)1), (Object)Pair.of((Object)new JumpOnBedTask(walkingSpeed), (Object)2), (Object)Pair.of((Object)new DummyTask(20, 40), (Object)2)))), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> rest(VillagerProfession profession, float walkingSpeed) {
        return ImmutableList.of((Object)Pair.of((Object)2, (Object)new StayNearPointTask(MemoryModuleType.HOME, walkingSpeed, 1, 150, 1200)), (Object)Pair.of((Object)3, (Object)new ExpirePOITask(PointOfInterestType.HOME, MemoryModuleType.HOME)), (Object)Pair.of((Object)3, (Object)new SleepAtHomeTask()), (Object)Pair.of((Object)5, new FirstShuffledTask((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of(MemoryModuleType.HOME, (Object)((Object)MemoryModuleStatus.VALUE_ABSENT)), ImmutableList.of((Object)Pair.of((Object)new WalkToHouseTask(walkingSpeed), (Object)1), (Object)Pair.of((Object)new WalkRandomlyInsideTask(walkingSpeed), (Object)4), (Object)Pair.of((Object)new WalkToPOITask(walkingSpeed, 4), (Object)2), (Object)Pair.of((Object)new DummyTask(20, 40), (Object)2)))), VillagerTasks.lookAtPlayerOrVillager(), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> meet(VillagerProfession profession, float p_220637_1_) {
        return ImmutableList.of((Object)Pair.of((Object)2, new FirstShuffledTask(ImmutableList.of((Object)Pair.of((Object)new WorkTask(MemoryModuleType.MEETING_POINT, 0.4f, 40), (Object)2), (Object)Pair.of((Object)new CongregateTask(), (Object)2)))), (Object)Pair.of((Object)10, (Object)new ShowWaresTask(400, 1600)), (Object)Pair.of((Object)10, (Object)new FindInteractionAndLookTargetTask(EntityType.PLAYER, 4)), (Object)Pair.of((Object)2, (Object)new StayNearPointTask(MemoryModuleType.MEETING_POINT, p_220637_1_, 6, 100, 200)), (Object)Pair.of((Object)3, (Object)new GiveHeroGiftsTask(100)), (Object)Pair.of((Object)3, (Object)new ExpirePOITask(PointOfInterestType.MEETING, MemoryModuleType.MEETING_POINT)), (Object)Pair.of((Object)3, new MultiTask((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of(), (Set<MemoryModuleType<?>>)ImmutableSet.of(MemoryModuleType.INTERACTION_TARGET), MultiTask.Ordering.ORDERED, MultiTask.RunType.RUN_ONE, ImmutableList.of((Object)Pair.of((Object)new ShareItemsTask(), (Object)1)))), VillagerTasks.lookAtMany(), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> idle(VillagerProfession profession, float p_220641_1_) {
        return ImmutableList.of((Object)Pair.of((Object)2, new FirstShuffledTask(ImmutableList.of((Object)Pair.of(InteractWithEntityTask.func_220445_a(EntityType.VILLAGER, 8, MemoryModuleType.INTERACTION_TARGET, p_220641_1_, 2), (Object)2), (Object)Pair.of(new InteractWithEntityTask<VillagerEntity, AgeableEntity>(EntityType.VILLAGER, 8, AgeableEntity::canBreed, AgeableEntity::canBreed, MemoryModuleType.BREED_TARGET, p_220641_1_, 2), (Object)1), (Object)Pair.of(InteractWithEntityTask.func_220445_a(EntityType.CAT, 8, MemoryModuleType.INTERACTION_TARGET, p_220641_1_, 2), (Object)1), (Object)Pair.of((Object)new FindWalkTargetTask(p_220641_1_), (Object)1), (Object)Pair.of((Object)new WalkTowardsLookTargetTask(p_220641_1_, 2), (Object)1), (Object)Pair.of((Object)new JumpOnBedTask(p_220641_1_), (Object)1), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)1)))), (Object)Pair.of((Object)3, (Object)new GiveHeroGiftsTask(100)), (Object)Pair.of((Object)3, (Object)new FindInteractionAndLookTargetTask(EntityType.PLAYER, 4)), (Object)Pair.of((Object)3, (Object)new ShowWaresTask(400, 1600)), (Object)Pair.of((Object)3, new MultiTask((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of(), (Set<MemoryModuleType<?>>)ImmutableSet.of(MemoryModuleType.INTERACTION_TARGET), MultiTask.Ordering.ORDERED, MultiTask.RunType.RUN_ONE, ImmutableList.of((Object)Pair.of((Object)new ShareItemsTask(), (Object)1)))), (Object)Pair.of((Object)3, new MultiTask((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of(), (Set<MemoryModuleType<?>>)ImmutableSet.of(MemoryModuleType.BREED_TARGET), MultiTask.Ordering.ORDERED, MultiTask.RunType.RUN_ONE, ImmutableList.of((Object)Pair.of((Object)new CreateBabyVillagerTask(), (Object)1)))), VillagerTasks.lookAtMany(), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> panic(VillagerProfession profession, float p_220636_1_) {
        float f = p_220636_1_ * 1.5f;
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new ClearHurtTask()), (Object)Pair.of((Object)1, RunAwayTask.func_233965_b_(MemoryModuleType.NEAREST_HOSTILE, f, 6, false)), (Object)Pair.of((Object)1, RunAwayTask.func_233965_b_(MemoryModuleType.HURT_BY_ENTITY, f, 6, false)), (Object)Pair.of((Object)3, (Object)new FindWalkTargetTask(f, 2, 2)), VillagerTasks.lookAtPlayerOrVillager());
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> preRaid(VillagerProfession profession, float p_220642_1_) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new RingBellTask()), (Object)Pair.of((Object)0, new FirstShuffledTask(ImmutableList.of((Object)Pair.of((Object)new StayNearPointTask(MemoryModuleType.MEETING_POINT, p_220642_1_ * 1.5f, 2, 150, 200), (Object)6), (Object)Pair.of((Object)new FindWalkTargetTask(p_220642_1_ * 1.5f), (Object)2)))), VillagerTasks.lookAtPlayerOrVillager(), (Object)Pair.of((Object)99, (Object)new ForgetRaidTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> raid(VillagerProfession profession, float p_220640_1_) {
        return ImmutableList.of((Object)Pair.of((Object)0, new FirstShuffledTask(ImmutableList.of((Object)Pair.of((Object)new GoOutsideAfterRaidTask(p_220640_1_), (Object)5), (Object)Pair.of((Object)new FindWalkTargetAfterRaidVictoryTask(p_220640_1_ * 1.1f), (Object)2)))), (Object)Pair.of((Object)0, (Object)new CelebrateRaidVictoryTask(600, 600)), (Object)Pair.of((Object)2, (Object)new FindHidingPlaceDuringRaidTask(24, p_220640_1_ * 1.4f)), VillagerTasks.lookAtPlayerOrVillager(), (Object)Pair.of((Object)99, (Object)new ForgetRaidTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> hide(VillagerProfession profession, float p_220644_1_) {
        int i = 2;
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new ExpireHidingTask(15, 3)), (Object)Pair.of((Object)1, (Object)new FindHidingPlaceTask(32, p_220644_1_ * 1.25f, 2)), VillagerTasks.lookAtPlayerOrVillager());
    }

    private static Pair<Integer, Task<LivingEntity>> lookAtMany() {
        return Pair.of((Object)5, new FirstShuffledTask(ImmutableList.of((Object)Pair.of((Object)new LookAtEntityTask(EntityType.CAT, 8.0f), (Object)8), (Object)Pair.of((Object)new LookAtEntityTask(EntityType.VILLAGER, 8.0f), (Object)2), (Object)Pair.of((Object)new LookAtEntityTask(EntityType.PLAYER, 8.0f), (Object)2), (Object)Pair.of((Object)new LookAtEntityTask(EntityClassification.CREATURE, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(EntityClassification.WATER_CREATURE, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(EntityClassification.WATER_AMBIENT, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(EntityClassification.MONSTER, 8.0f), (Object)1), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)2))));
    }

    private static Pair<Integer, Task<LivingEntity>> lookAtPlayerOrVillager() {
        return Pair.of((Object)5, new FirstShuffledTask(ImmutableList.of((Object)Pair.of((Object)new LookAtEntityTask(EntityType.VILLAGER, 8.0f), (Object)2), (Object)Pair.of((Object)new LookAtEntityTask(EntityType.PLAYER, 8.0f), (Object)2), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)8))));
    }
}

