/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class SpellcastingIllagerEntity
extends AbstractIllagerEntity {
    private static final DataParameter<Byte> SPELL = EntityDataManager.createKey(SpellcastingIllagerEntity.class, DataSerializers.BYTE);
    protected int spellTicks;
    private SpellType activeSpell = SpellType.NONE;

    protected SpellcastingIllagerEntity(EntityType<? extends SpellcastingIllagerEntity> type, World p_i48551_2_) {
        super((EntityType<? extends AbstractIllagerEntity>)type, p_i48551_2_);
    }

    @Override
    protected void registerData() {
        super.registerData();
        this.dataManager.register(SPELL, (byte)0);
    }

    @Override
    public void readAdditional(CompoundNBT compound) {
        super.readAdditional(compound);
        this.spellTicks = compound.getInt("SpellTicks");
    }

    @Override
    public void writeAdditional(CompoundNBT compound) {
        super.writeAdditional(compound);
        compound.putInt("SpellTicks", this.spellTicks);
    }

    @Override
    public AbstractIllagerEntity.ArmPose getArmPose() {
        if (this.isSpellcasting()) {
            return AbstractIllagerEntity.ArmPose.SPELLCASTING;
        }
        return this.getCelebrating() ? AbstractIllagerEntity.ArmPose.CELEBRATING : AbstractIllagerEntity.ArmPose.CROSSED;
    }

    public boolean isSpellcasting() {
        if (this.world.isRemote) {
            return this.dataManager.get(SPELL) > 0;
        }
        return this.spellTicks > 0;
    }

    public void setSpellType(SpellType spellType) {
        this.activeSpell = spellType;
        this.dataManager.set(SPELL, (byte)spellType.id);
    }

    protected SpellType getSpellType() {
        return !this.world.isRemote ? this.activeSpell : SpellType.getFromId(this.dataManager.get(SPELL).byteValue());
    }

    @Override
    protected void updateAITasks() {
        super.updateAITasks();
        if (this.spellTicks > 0) {
            --this.spellTicks;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.world.isRemote && this.isSpellcasting()) {
            SpellType spellcastingillagerentity$spelltype = this.getSpellType();
            double d0 = spellcastingillagerentity$spelltype.particleSpeed[0];
            double d1 = spellcastingillagerentity$spelltype.particleSpeed[1];
            double d2 = spellcastingillagerentity$spelltype.particleSpeed[2];
            float f = this.renderYawOffset * ((float)Math.PI / 180) + MathHelper.cos((float)this.ticksExisted * 0.6662f) * 0.25f;
            float f1 = MathHelper.cos(f);
            float f2 = MathHelper.sin(f);
            this.world.addParticle(ParticleTypes.ENTITY_EFFECT, this.getPosX() + (double)f1 * 0.6, this.getPosY() + 1.8, this.getPosZ() + (double)f2 * 0.6, d0, d1, d2);
            this.world.addParticle(ParticleTypes.ENTITY_EFFECT, this.getPosX() - (double)f1 * 0.6, this.getPosY() + 1.8, this.getPosZ() - (double)f2 * 0.6, d0, d1, d2);
        }
    }

    protected int getSpellTicks() {
        return this.spellTicks;
    }

    protected abstract SoundEvent getSpellSound();

    public static enum SpellType {
        NONE(0, 0.0, 0.0, 0.0),
        SUMMON_VEX(1, 0.7, 0.7, 0.8),
        FANGS(2, 0.4, 0.3, 0.35),
        WOLOLO(3, 0.7, 0.5, 0.2),
        DISAPPEAR(4, 0.3, 0.3, 0.8),
        BLINDNESS(5, 0.1, 0.1, 0.2);

        private final int id;
        private final double[] particleSpeed;

        private SpellType(int idIn, double xParticleSpeed, double yParticleSpeed, double zParticleSpeed) {
            this.id = idIn;
            this.particleSpeed = new double[]{xParticleSpeed, yParticleSpeed, zParticleSpeed};
        }

        public static SpellType getFromId(int idIn) {
            for (SpellType spellcastingillagerentity$spelltype : SpellType.values()) {
                if (idIn != spellcastingillagerentity$spelltype.id) continue;
                return spellcastingillagerentity$spelltype;
            }
            return NONE;
        }
    }

    public abstract class UseSpellGoal
    extends Goal {
        protected int spellWarmup;
        protected int spellCooldown;

        protected UseSpellGoal() {
        }

        @Override
        public boolean shouldExecute() {
            LivingEntity livingentity = SpellcastingIllagerEntity.this.getAttackTarget();
            if (livingentity != null && livingentity.isAlive()) {
                if (SpellcastingIllagerEntity.this.isSpellcasting()) {
                    return false;
                }
                return SpellcastingIllagerEntity.this.ticksExisted >= this.spellCooldown;
            }
            return false;
        }

        @Override
        public boolean shouldContinueExecuting() {
            LivingEntity livingentity = SpellcastingIllagerEntity.this.getAttackTarget();
            return livingentity != null && livingentity.isAlive() && this.spellWarmup > 0;
        }

        @Override
        public void startExecuting() {
            this.spellWarmup = this.getCastWarmupTime();
            SpellcastingIllagerEntity.this.spellTicks = this.getCastingTime();
            this.spellCooldown = SpellcastingIllagerEntity.this.ticksExisted + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                SpellcastingIllagerEntity.this.playSound(soundevent, 1.0f, 1.0f);
            }
            SpellcastingIllagerEntity.this.setSpellType(this.getSpellType());
        }

        @Override
        public void tick() {
            --this.spellWarmup;
            if (this.spellWarmup == 0) {
                this.castSpell();
                SpellcastingIllagerEntity.this.playSound(SpellcastingIllagerEntity.this.getSpellSound(), 1.0f, 1.0f);
            }
        }

        protected abstract void castSpell();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @Nullable
        protected abstract SoundEvent getSpellPrepareSound();

        protected abstract SpellType getSpellType();
    }

    public class CastingASpellGoal
    extends Goal {
        public CastingASpellGoal() {
            this.setMutexFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean shouldExecute() {
            return SpellcastingIllagerEntity.this.getSpellTicks() > 0;
        }

        @Override
        public void startExecuting() {
            super.startExecuting();
            SpellcastingIllagerEntity.this.navigator.clearPath();
        }

        @Override
        public void resetTask() {
            super.resetTask();
            SpellcastingIllagerEntity.this.setSpellType(SpellType.NONE);
        }

        @Override
        public void tick() {
            if (SpellcastingIllagerEntity.this.getAttackTarget() != null) {
                SpellcastingIllagerEntity.this.getLookController().setLookPositionWithEntity(SpellcastingIllagerEntity.this.getAttackTarget(), SpellcastingIllagerEntity.this.getHorizontalFaceSpeed(), SpellcastingIllagerEntity.this.getVerticalFaceSpeed());
            }
        }
    }
}

