/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.Logger;

public class ZombieVillagerEntity
extends ZombieEntity
implements IVillagerDataHolder {
    private static final DataParameter<Boolean> CONVERTING = EntityDataManager.createKey(ZombieVillagerEntity.class, DataSerializers.BOOLEAN);
    private static final DataParameter<VillagerData> VILLAGER_DATA = EntityDataManager.createKey(ZombieVillagerEntity.class, DataSerializers.VILLAGER_DATA);
    private int conversionTime;
    private UUID converstionStarter;
    private INBT gossips;
    private CompoundNBT offers;
    private int xp;

    public ZombieVillagerEntity(EntityType<? extends ZombieVillagerEntity> p_i50186_1_, World p_i50186_2_) {
        super((EntityType<? extends ZombieEntity>)p_i50186_1_, p_i50186_2_);
        this.setVillagerData(this.getVillagerData().withProfession(Registry.VILLAGER_PROFESSION.getRandom(this.rand)));
    }

    @Override
    protected void registerData() {
        super.registerData();
        this.dataManager.register(CONVERTING, false);
        this.dataManager.register(VILLAGER_DATA, new VillagerData(VillagerType.PLAINS, VillagerProfession.NONE, 1));
    }

    @Override
    public void writeAdditional(CompoundNBT compound) {
        super.writeAdditional(compound);
        VillagerData.CODEC.encodeStart((DynamicOps)NBTDynamicOps.INSTANCE, (Object)this.getVillagerData()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_234343_1_ -> compound.put("VillagerData", (INBT)p_234343_1_));
        if (this.offers != null) {
            compound.put("Offers", this.offers);
        }
        if (this.gossips != null) {
            compound.put("Gossips", this.gossips);
        }
        compound.putInt("ConversionTime", this.isConverting() ? this.conversionTime : -1);
        if (this.converstionStarter != null) {
            compound.putUniqueId("ConversionPlayer", this.converstionStarter);
        }
        compound.putInt("Xp", this.xp);
    }

    @Override
    public void readAdditional(CompoundNBT compound) {
        super.readAdditional(compound);
        if (compound.contains("VillagerData", 10)) {
            DataResult dataresult = VillagerData.CODEC.parse(new Dynamic((DynamicOps)NBTDynamicOps.INSTANCE, (Object)compound.get("VillagerData")));
            dataresult.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this::setVillagerData);
        }
        if (compound.contains("Offers", 10)) {
            this.offers = compound.getCompound("Offers");
        }
        if (compound.contains("Gossips", 10)) {
            this.gossips = compound.getList("Gossips", 10);
        }
        if (compound.contains("ConversionTime", 99) && compound.getInt("ConversionTime") > -1) {
            this.startConverting(compound.hasUniqueId("ConversionPlayer") ? compound.getUniqueId("ConversionPlayer") : null, compound.getInt("ConversionTime"));
        }
        if (compound.contains("Xp", 3)) {
            this.xp = compound.getInt("Xp");
        }
    }

    @Override
    public void tick() {
        if (!this.world.isRemote && this.isAlive() && this.isConverting()) {
            int i = this.getConversionProgress();
            this.conversionTime -= i;
            if (this.conversionTime <= 0) {
                this.cureZombie((ServerWorld)this.world);
            }
        }
        super.tick();
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.getHeldItem(p_230254_2_);
        if (itemstack.getItem() == Items.GOLDEN_APPLE) {
            if (this.isPotionActive(Effects.WEAKNESS)) {
                if (!p_230254_1_.abilities.isCreativeMode) {
                    itemstack.shrink(1);
                }
                if (!this.world.isRemote) {
                    this.startConverting(p_230254_1_.getUniqueID(), this.rand.nextInt(2401) + 3600);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.CONSUME;
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    @Override
    protected boolean shouldDrown() {
        return false;
    }

    @Override
    public boolean canDespawn(double distanceToClosestPlayer) {
        return !this.isConverting() && this.xp == 0;
    }

    public boolean isConverting() {
        return this.getDataManager().get(CONVERTING);
    }

    private void startConverting(@Nullable UUID conversionStarterIn, int conversionTimeIn) {
        this.converstionStarter = conversionStarterIn;
        this.conversionTime = conversionTimeIn;
        this.getDataManager().set(CONVERTING, true);
        this.removePotionEffect(Effects.WEAKNESS);
        this.addPotionEffect(new EffectInstance(Effects.STRENGTH, conversionTimeIn, Math.min(this.world.getDifficulty().getId() - 1, 0)));
        this.world.setEntityState(this, (byte)16);
    }

    @Override
    public void handleStatusUpdate(byte id) {
        if (id == 16) {
            if (!this.isSilent()) {
                this.world.playSound(this.getPosX(), this.getPosYEye(), this.getPosZ(), SoundEvents.ENTITY_ZOMBIE_VILLAGER_CURE, this.getSoundCategory(), 1.0f + this.rand.nextFloat(), this.rand.nextFloat() * 0.7f + 0.3f, false);
            }
        } else {
            super.handleStatusUpdate(id);
        }
    }

    private void cureZombie(ServerWorld p_213791_1_) {
        PlayerEntity playerentity;
        VillagerEntity villagerentity = this.func_233656_b_(EntityType.VILLAGER, false);
        for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
            ItemStack itemstack = this.getItemStackFromSlot(equipmentslottype);
            if (itemstack.isEmpty()) continue;
            if (EnchantmentHelper.hasBindingCurse(itemstack)) {
                villagerentity.replaceItemInInventory(equipmentslottype.getIndex() + 300, itemstack);
                continue;
            }
            double d0 = this.getDropChance(equipmentslottype);
            if (!(d0 > 1.0)) continue;
            this.entityDropItem(itemstack);
        }
        villagerentity.setVillagerData(this.getVillagerData());
        if (this.gossips != null) {
            villagerentity.setGossips(this.gossips);
        }
        if (this.offers != null) {
            villagerentity.setOffers(new MerchantOffers(this.offers));
        }
        villagerentity.setXp(this.xp);
        villagerentity.onInitialSpawn(p_213791_1_, p_213791_1_.getDifficultyForLocation(villagerentity.getPosition()), SpawnReason.CONVERSION, null, null);
        if (this.converstionStarter != null && (playerentity = p_213791_1_.getPlayerByUuid(this.converstionStarter)) instanceof ServerPlayerEntity) {
            CriteriaTriggers.CURED_ZOMBIE_VILLAGER.trigger((ServerPlayerEntity)playerentity, this, villagerentity);
            p_213791_1_.updateReputation(IReputationType.ZOMBIE_VILLAGER_CURED, playerentity, villagerentity);
        }
        villagerentity.addPotionEffect(new EffectInstance(Effects.NAUSEA, 200, 0));
        if (!this.isSilent()) {
            p_213791_1_.playEvent(null, 1027, this.getPosition(), 0);
        }
    }

    private int getConversionProgress() {
        int i = 1;
        if (this.rand.nextFloat() < 0.01f) {
            int j = 0;
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (int k = (int)this.getPosX() - 4; k < (int)this.getPosX() + 4 && j < 14; ++k) {
                for (int l = (int)this.getPosY() - 4; l < (int)this.getPosY() + 4 && j < 14; ++l) {
                    for (int i1 = (int)this.getPosZ() - 4; i1 < (int)this.getPosZ() + 4 && j < 14; ++i1) {
                        Block block = this.world.getBlockState(blockpos$mutable.setPos(k, l, i1)).getBlock();
                        if (block != Blocks.IRON_BARS && !(block instanceof BedBlock)) continue;
                        if (this.rand.nextFloat() < 0.3f) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        return i;
    }

    @Override
    protected float getSoundPitch() {
        return this.isChild() ? (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 2.0f : (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_ZOMBIE_VILLAGER_AMBIENT;
    }

    @Override
    public SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_ZOMBIE_VILLAGER_HURT;
    }

    @Override
    public SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_ZOMBIE_VILLAGER_DEATH;
    }

    @Override
    public SoundEvent getStepSound() {
        return SoundEvents.ENTITY_ZOMBIE_VILLAGER_STEP;
    }

    @Override
    protected ItemStack getSkullDrop() {
        return ItemStack.EMPTY;
    }

    public void setOffers(CompoundNBT p_213790_1_) {
        this.offers = p_213790_1_;
    }

    public void setGossips(INBT p_223727_1_) {
        this.gossips = p_223727_1_;
    }

    @Override
    @Nullable
    public ILivingEntityData onInitialSpawn(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setVillagerData(this.getVillagerData().withType(VillagerType.func_242371_a(worldIn.func_242406_i(this.getPosition()))));
        return super.onInitialSpawn(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void setVillagerData(VillagerData p_213792_1_) {
        VillagerData villagerdata = this.getVillagerData();
        if (villagerdata.getProfession() != p_213792_1_.getProfession()) {
            this.offers = null;
        }
        this.dataManager.set(VILLAGER_DATA, p_213792_1_);
    }

    @Override
    public VillagerData getVillagerData() {
        return this.dataManager.get(VILLAGER_DATA);
    }

    public void setEXP(int p_213789_1_) {
        this.xp = p_213789_1_;
    }
}

