/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ShearsItem
extends Item {
    public ShearsItem(Item.Properties builder) {
        super(builder);
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.isRemote && !state.getBlock().isIn(BlockTags.FIRE)) {
            stack.damageItem(1, entityLiving, entity -> entity.sendBreakAnimation(EquipmentSlotType.MAINHAND));
        }
        return !state.isIn(BlockTags.LEAVES) && !state.isIn(Blocks.COBWEB) && !state.isIn(Blocks.GRASS) && !state.isIn(Blocks.FERN) && !state.isIn(Blocks.DEAD_BUSH) && !state.isIn(Blocks.VINE) && !state.isIn(Blocks.TRIPWIRE) && !state.isIn(BlockTags.WOOL) ? super.onBlockDestroyed(stack, worldIn, state, pos, entityLiving) : true;
    }

    @Override
    public boolean canHarvestBlock(BlockState blockIn) {
        return blockIn.isIn(Blocks.COBWEB) || blockIn.isIn(Blocks.REDSTONE_WIRE) || blockIn.isIn(Blocks.TRIPWIRE);
    }

    @Override
    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (!state.isIn(Blocks.COBWEB) && !state.isIn(BlockTags.LEAVES)) {
            return state.isIn(BlockTags.WOOL) ? 5.0f : super.getDestroySpeed(stack, state);
        }
        return 15.0f;
    }
}

