/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class ApplyBonus
extends LootFunction {
    private static final Map<ResourceLocation, IFormulaDeserializer> field_215875_a = Maps.newHashMap();
    private final Enchantment enchantment;
    private final IFormula field_215877_d;

    private ApplyBonus(ILootCondition[] conditionsIn, Enchantment enchantmentIn, IFormula p_i51246_3_) {
        super(conditionsIn);
        this.enchantment = enchantmentIn;
        this.field_215877_d = p_i51246_3_;
    }

    @Override
    public LootFunctionType getFunctionType() {
        return LootFunctionManager.APPLY_BONUS;
    }

    @Override
    public Set<LootParameter<?>> getRequiredParameters() {
        return ImmutableSet.of(LootParameters.TOOL);
    }

    @Override
    public ItemStack doApply(ItemStack stack, LootContext context) {
        ItemStack itemstack = context.get(LootParameters.TOOL);
        if (itemstack != null) {
            int i = EnchantmentHelper.getEnchantmentLevel(this.enchantment, itemstack);
            int j = this.field_215877_d.func_216204_a(context.getRandom(), stack.getCount(), i);
            stack.setCount(j);
        }
        return stack;
    }

    public static LootFunction.Builder<?> binomialWithBonusCount(Enchantment p_215870_0_, float p_215870_1_, int p_215870_2_) {
        return ApplyBonus.builder(p_215864_3_ -> new ApplyBonus((ILootCondition[])p_215864_3_, p_215870_0_, new BinomialWithBonusCountFormula(p_215870_2_, p_215870_1_)));
    }

    public static LootFunction.Builder<?> oreDrops(Enchantment p_215869_0_) {
        return ApplyBonus.builder(p_215866_1_ -> new ApplyBonus((ILootCondition[])p_215866_1_, p_215869_0_, new OreDropsFormula()));
    }

    public static LootFunction.Builder<?> uniformBonusCount(Enchantment p_215871_0_) {
        return ApplyBonus.builder(p_215872_1_ -> new ApplyBonus((ILootCondition[])p_215872_1_, p_215871_0_, new UniformBonusCountFormula(1)));
    }

    public static LootFunction.Builder<?> uniformBonusCount(Enchantment p_215865_0_, int p_215865_1_) {
        return ApplyBonus.builder(p_215868_2_ -> new ApplyBonus((ILootCondition[])p_215868_2_, p_215865_0_, new UniformBonusCountFormula(p_215865_1_)));
    }

    static {
        field_215875_a.put(BinomialWithBonusCountFormula.field_216211_a, BinomialWithBonusCountFormula::func_216210_a);
        field_215875_a.put(OreDropsFormula.field_216206_a, OreDropsFormula::func_216205_a);
        field_215875_a.put(UniformBonusCountFormula.field_216208_a, UniformBonusCountFormula::func_216207_a);
    }

    static interface IFormula {
        public int func_216204_a(Random var1, int var2, int var3);

        public void func_216202_a(JsonObject var1, JsonSerializationContext var2);

        public ResourceLocation func_216203_a();
    }

    static final class UniformBonusCountFormula
    implements IFormula {
        public static final ResourceLocation field_216208_a = new ResourceLocation("uniform_bonus_count");
        private final int bonusMultiplier;

        public UniformBonusCountFormula(int bonusMultiplier) {
            this.bonusMultiplier = bonusMultiplier;
        }

        @Override
        public int func_216204_a(Random p_216204_1_, int p_216204_2_, int p_216204_3_) {
            return p_216204_2_ + p_216204_1_.nextInt(this.bonusMultiplier * p_216204_3_ + 1);
        }

        @Override
        public void func_216202_a(JsonObject p_216202_1_, JsonSerializationContext p_216202_2_) {
            p_216202_1_.addProperty("bonusMultiplier", (Number)this.bonusMultiplier);
        }

        public static IFormula func_216207_a(JsonObject p_216207_0_, JsonDeserializationContext p_216207_1_) {
            int i = JSONUtils.getInt(p_216207_0_, "bonusMultiplier");
            return new UniformBonusCountFormula(i);
        }

        @Override
        public ResourceLocation func_216203_a() {
            return field_216208_a;
        }
    }

    static final class OreDropsFormula
    implements IFormula {
        public static final ResourceLocation field_216206_a = new ResourceLocation("ore_drops");

        private OreDropsFormula() {
        }

        @Override
        public int func_216204_a(Random p_216204_1_, int p_216204_2_, int p_216204_3_) {
            if (p_216204_3_ > 0) {
                int i = p_216204_1_.nextInt(p_216204_3_ + 2) - 1;
                if (i < 0) {
                    i = 0;
                }
                return p_216204_2_ * (i + 1);
            }
            return p_216204_2_;
        }

        @Override
        public void func_216202_a(JsonObject p_216202_1_, JsonSerializationContext p_216202_2_) {
        }

        public static IFormula func_216205_a(JsonObject p_216205_0_, JsonDeserializationContext p_216205_1_) {
            return new OreDropsFormula();
        }

        @Override
        public ResourceLocation func_216203_a() {
            return field_216206_a;
        }
    }

    static final class BinomialWithBonusCountFormula
    implements IFormula {
        public static final ResourceLocation field_216211_a = new ResourceLocation("binomial_with_bonus_count");
        private final int extra;
        private final float probability;

        public BinomialWithBonusCountFormula(int extra, float probability) {
            this.extra = extra;
            this.probability = probability;
        }

        @Override
        public int func_216204_a(Random p_216204_1_, int p_216204_2_, int p_216204_3_) {
            for (int i = 0; i < p_216204_3_ + this.extra; ++i) {
                if (!(p_216204_1_.nextFloat() < this.probability)) continue;
                ++p_216204_2_;
            }
            return p_216204_2_;
        }

        @Override
        public void func_216202_a(JsonObject p_216202_1_, JsonSerializationContext p_216202_2_) {
            p_216202_1_.addProperty("extra", (Number)this.extra);
            p_216202_1_.addProperty("probability", (Number)Float.valueOf(this.probability));
        }

        public static IFormula func_216210_a(JsonObject p_216210_0_, JsonDeserializationContext p_216210_1_) {
            int i = JSONUtils.getInt(p_216210_0_, "extra");
            float f = JSONUtils.getFloat(p_216210_0_, "probability");
            return new BinomialWithBonusCountFormula(i, f);
        }

        @Override
        public ResourceLocation func_216203_a() {
            return field_216211_a;
        }
    }

    static interface IFormulaDeserializer {
        public IFormula deserialize(JsonObject var1, JsonDeserializationContext var2);
    }

    public static class Serializer
    extends LootFunction.Serializer<ApplyBonus> {
        @Override
        public void serialize(JsonObject p_230424_1_, ApplyBonus p_230424_2_, JsonSerializationContext p_230424_3_) {
            super.serialize(p_230424_1_, p_230424_2_, p_230424_3_);
            p_230424_1_.addProperty("enchantment", Registry.ENCHANTMENT.getKey(p_230424_2_.enchantment).toString());
            p_230424_1_.addProperty("formula", p_230424_2_.field_215877_d.func_216203_a().toString());
            JsonObject jsonobject = new JsonObject();
            p_230424_2_.field_215877_d.func_216202_a(jsonobject, p_230424_3_);
            if (jsonobject.size() > 0) {
                p_230424_1_.add("parameters", (JsonElement)jsonobject);
            }
        }

        @Override
        public ApplyBonus deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            ResourceLocation resourcelocation = new ResourceLocation(JSONUtils.getString(object, "enchantment"));
            Enchantment enchantment = Registry.ENCHANTMENT.getOptional(resourcelocation).orElseThrow(() -> new JsonParseException("Invalid enchantment id: " + String.valueOf(resourcelocation)));
            ResourceLocation resourcelocation1 = new ResourceLocation(JSONUtils.getString(object, "formula"));
            IFormulaDeserializer applybonus$iformuladeserializer = field_215875_a.get(resourcelocation1);
            if (applybonus$iformuladeserializer == null) {
                throw new JsonParseException("Invalid formula id: " + String.valueOf(resourcelocation1));
            }
            IFormula applybonus$iformula = object.has("parameters") ? applybonus$iformuladeserializer.deserialize(JSONUtils.getJsonObject(object, "parameters"), deserializationContext) : applybonus$iformuladeserializer.deserialize(new JsonObject(), deserializationContext);
            return new ApplyBonus(conditionsIn, enchantment, applybonus$iformula);
        }
    }
}

