/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.MobEntity;
import net.minecraft.pathfinding.FlaggedPathPoint;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.Region;

public class FlyingNodeProcessor
extends WalkNodeProcessor {
    @Override
    public void func_225578_a_(Region p_225578_1_, MobEntity p_225578_2_) {
        super.func_225578_a_(p_225578_1_, p_225578_2_);
        this.avoidsWater = p_225578_2_.getPathPriority(PathNodeType.WATER);
    }

    @Override
    public void postProcess() {
        this.entity.setPathPriority(PathNodeType.WATER, this.avoidsWater);
        super.postProcess();
    }

    @Override
    public PathPoint getStart() {
        BlockPos blockpos1;
        PathNodeType pathnodetype1;
        int i;
        if (this.getCanSwim() && this.entity.isInWater()) {
            i = MathHelper.floor(this.entity.getPosY());
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(this.entity.getPosX(), (double)i, this.entity.getPosZ());
            Block block = this.blockaccess.getBlockState(blockpos$mutable).getBlock();
            while (block == Blocks.WATER) {
                blockpos$mutable.setPos(this.entity.getPosX(), (double)(++i), this.entity.getPosZ());
                block = this.blockaccess.getBlockState(blockpos$mutable).getBlock();
            }
        } else {
            i = MathHelper.floor(this.entity.getPosY() + 0.5);
        }
        if (this.entity.getPathPriority(pathnodetype1 = this.getPathNodeType(this.entity, (blockpos1 = this.entity.getPosition()).getX(), i, blockpos1.getZ())) < 0.0f) {
            HashSet set = Sets.newHashSet();
            set.add(new BlockPos(this.entity.getBoundingBox().minX, (double)i, this.entity.getBoundingBox().minZ));
            set.add(new BlockPos(this.entity.getBoundingBox().minX, (double)i, this.entity.getBoundingBox().maxZ));
            set.add(new BlockPos(this.entity.getBoundingBox().maxX, (double)i, this.entity.getBoundingBox().minZ));
            set.add(new BlockPos(this.entity.getBoundingBox().maxX, (double)i, this.entity.getBoundingBox().maxZ));
            for (BlockPos blockpos : set) {
                PathNodeType pathnodetype = this.getPathNodeType(this.entity, blockpos);
                if (!(this.entity.getPathPriority(pathnodetype) >= 0.0f)) continue;
                return super.openPoint(blockpos.getX(), blockpos.getY(), blockpos.getZ());
            }
        }
        return super.openPoint(blockpos1.getX(), i, blockpos1.getZ());
    }

    @Override
    public FlaggedPathPoint func_224768_a(double p_224768_1_, double p_224768_3_, double p_224768_5_) {
        return new FlaggedPathPoint(super.openPoint(MathHelper.floor(p_224768_1_), MathHelper.floor(p_224768_3_), MathHelper.floor(p_224768_5_)));
    }

    @Override
    public int func_222859_a(PathPoint[] p_222859_1_, PathPoint p_222859_2_) {
        PathPoint pathpoint25;
        PathPoint pathpoint24;
        PathPoint pathpoint23;
        PathPoint pathpoint22;
        PathPoint pathpoint21;
        PathPoint pathpoint20;
        PathPoint pathpoint19;
        PathPoint pathpoint18;
        PathPoint pathpoint17;
        PathPoint pathpoint16;
        PathPoint pathpoint15;
        PathPoint pathpoint14;
        PathPoint pathpoint13;
        PathPoint pathpoint12;
        PathPoint pathpoint11;
        PathPoint pathpoint10;
        PathPoint pathpoint9;
        PathPoint pathpoint8;
        PathPoint pathpoint7;
        PathPoint pathpoint6;
        PathPoint pathpoint5;
        PathPoint pathpoint4;
        PathPoint pathpoint3;
        PathPoint pathpoint2;
        PathPoint pathpoint1;
        int i = 0;
        PathPoint pathpoint = this.openPoint(p_222859_2_.x, p_222859_2_.y, p_222859_2_.z + 1);
        if (this.func_227477_b_(pathpoint)) {
            p_222859_1_[i++] = pathpoint;
        }
        if (this.func_227477_b_(pathpoint1 = this.openPoint(p_222859_2_.x - 1, p_222859_2_.y, p_222859_2_.z))) {
            p_222859_1_[i++] = pathpoint1;
        }
        if (this.func_227477_b_(pathpoint2 = this.openPoint(p_222859_2_.x + 1, p_222859_2_.y, p_222859_2_.z))) {
            p_222859_1_[i++] = pathpoint2;
        }
        if (this.func_227477_b_(pathpoint3 = this.openPoint(p_222859_2_.x, p_222859_2_.y, p_222859_2_.z - 1))) {
            p_222859_1_[i++] = pathpoint3;
        }
        if (this.func_227477_b_(pathpoint4 = this.openPoint(p_222859_2_.x, p_222859_2_.y + 1, p_222859_2_.z))) {
            p_222859_1_[i++] = pathpoint4;
        }
        if (this.func_227477_b_(pathpoint5 = this.openPoint(p_222859_2_.x, p_222859_2_.y - 1, p_222859_2_.z))) {
            p_222859_1_[i++] = pathpoint5;
        }
        if (this.func_227477_b_(pathpoint6 = this.openPoint(p_222859_2_.x, p_222859_2_.y + 1, p_222859_2_.z + 1)) && this.func_227476_a_(pathpoint) && this.func_227476_a_(pathpoint4)) {
            p_222859_1_[i++] = pathpoint6;
        }
        if (this.func_227477_b_(pathpoint7 = this.openPoint(p_222859_2_.x - 1, p_222859_2_.y + 1, p_222859_2_.z)) && this.func_227476_a_(pathpoint1) && this.func_227476_a_(pathpoint4)) {
            p_222859_1_[i++] = pathpoint7;
        }
        if (this.func_227477_b_(pathpoint8 = this.openPoint(p_222859_2_.x + 1, p_222859_2_.y + 1, p_222859_2_.z)) && this.func_227476_a_(pathpoint2) && this.func_227476_a_(pathpoint4)) {
            p_222859_1_[i++] = pathpoint8;
        }
        if (this.func_227477_b_(pathpoint9 = this.openPoint(p_222859_2_.x, p_222859_2_.y + 1, p_222859_2_.z - 1)) && this.func_227476_a_(pathpoint3) && this.func_227476_a_(pathpoint4)) {
            p_222859_1_[i++] = pathpoint9;
        }
        if (this.func_227477_b_(pathpoint10 = this.openPoint(p_222859_2_.x, p_222859_2_.y - 1, p_222859_2_.z + 1)) && this.func_227476_a_(pathpoint) && this.func_227476_a_(pathpoint5)) {
            p_222859_1_[i++] = pathpoint10;
        }
        if (this.func_227477_b_(pathpoint11 = this.openPoint(p_222859_2_.x - 1, p_222859_2_.y - 1, p_222859_2_.z)) && this.func_227476_a_(pathpoint1) && this.func_227476_a_(pathpoint5)) {
            p_222859_1_[i++] = pathpoint11;
        }
        if (this.func_227477_b_(pathpoint12 = this.openPoint(p_222859_2_.x + 1, p_222859_2_.y - 1, p_222859_2_.z)) && this.func_227476_a_(pathpoint2) && this.func_227476_a_(pathpoint5)) {
            p_222859_1_[i++] = pathpoint12;
        }
        if (this.func_227477_b_(pathpoint13 = this.openPoint(p_222859_2_.x, p_222859_2_.y - 1, p_222859_2_.z - 1)) && this.func_227476_a_(pathpoint3) && this.func_227476_a_(pathpoint5)) {
            p_222859_1_[i++] = pathpoint13;
        }
        if (this.func_227477_b_(pathpoint14 = this.openPoint(p_222859_2_.x + 1, p_222859_2_.y, p_222859_2_.z - 1)) && this.func_227476_a_(pathpoint3) && this.func_227476_a_(pathpoint2)) {
            p_222859_1_[i++] = pathpoint14;
        }
        if (this.func_227477_b_(pathpoint15 = this.openPoint(p_222859_2_.x + 1, p_222859_2_.y, p_222859_2_.z + 1)) && this.func_227476_a_(pathpoint) && this.func_227476_a_(pathpoint2)) {
            p_222859_1_[i++] = pathpoint15;
        }
        if (this.func_227477_b_(pathpoint16 = this.openPoint(p_222859_2_.x - 1, p_222859_2_.y, p_222859_2_.z - 1)) && this.func_227476_a_(pathpoint3) && this.func_227476_a_(pathpoint1)) {
            p_222859_1_[i++] = pathpoint16;
        }
        if (this.func_227477_b_(pathpoint17 = this.openPoint(p_222859_2_.x - 1, p_222859_2_.y, p_222859_2_.z + 1)) && this.func_227476_a_(pathpoint) && this.func_227476_a_(pathpoint1)) {
            p_222859_1_[i++] = pathpoint17;
        }
        if (this.func_227477_b_(pathpoint18 = this.openPoint(p_222859_2_.x + 1, p_222859_2_.y + 1, p_222859_2_.z - 1)) && this.func_227476_a_(pathpoint14) && this.func_227476_a_(pathpoint3) && this.func_227476_a_(pathpoint2) && this.func_227476_a_(pathpoint4) && this.func_227476_a_(pathpoint9) && this.func_227476_a_(pathpoint8)) {
            p_222859_1_[i++] = pathpoint18;
        }
        if (this.func_227477_b_(pathpoint19 = this.openPoint(p_222859_2_.x + 1, p_222859_2_.y + 1, p_222859_2_.z + 1)) && this.func_227476_a_(pathpoint15) && this.func_227476_a_(pathpoint) && this.func_227476_a_(pathpoint2) && this.func_227476_a_(pathpoint4) && this.func_227476_a_(pathpoint6) && this.func_227476_a_(pathpoint8)) {
            p_222859_1_[i++] = pathpoint19;
        }
        if (this.func_227477_b_(pathpoint20 = this.openPoint(p_222859_2_.x - 1, p_222859_2_.y + 1, p_222859_2_.z - 1)) && this.func_227476_a_(pathpoint16) && this.func_227476_a_(pathpoint3) && this.func_227476_a_(pathpoint1) & this.func_227476_a_(pathpoint4) && this.func_227476_a_(pathpoint9) && this.func_227476_a_(pathpoint7)) {
            p_222859_1_[i++] = pathpoint20;
        }
        if (this.func_227477_b_(pathpoint21 = this.openPoint(p_222859_2_.x - 1, p_222859_2_.y + 1, p_222859_2_.z + 1)) && this.func_227476_a_(pathpoint17) && this.func_227476_a_(pathpoint) && this.func_227476_a_(pathpoint1) & this.func_227476_a_(pathpoint4) && this.func_227476_a_(pathpoint6) && this.func_227476_a_(pathpoint7)) {
            p_222859_1_[i++] = pathpoint21;
        }
        if (this.func_227477_b_(pathpoint22 = this.openPoint(p_222859_2_.x + 1, p_222859_2_.y - 1, p_222859_2_.z - 1)) && this.func_227476_a_(pathpoint14) && this.func_227476_a_(pathpoint3) && this.func_227476_a_(pathpoint2) && this.func_227476_a_(pathpoint5) && this.func_227476_a_(pathpoint13) && this.func_227476_a_(pathpoint12)) {
            p_222859_1_[i++] = pathpoint22;
        }
        if (this.func_227477_b_(pathpoint23 = this.openPoint(p_222859_2_.x + 1, p_222859_2_.y - 1, p_222859_2_.z + 1)) && this.func_227476_a_(pathpoint15) && this.func_227476_a_(pathpoint) && this.func_227476_a_(pathpoint2) && this.func_227476_a_(pathpoint5) && this.func_227476_a_(pathpoint10) && this.func_227476_a_(pathpoint12)) {
            p_222859_1_[i++] = pathpoint23;
        }
        if (this.func_227477_b_(pathpoint24 = this.openPoint(p_222859_2_.x - 1, p_222859_2_.y - 1, p_222859_2_.z - 1)) && this.func_227476_a_(pathpoint16) && this.func_227476_a_(pathpoint3) && this.func_227476_a_(pathpoint1) && this.func_227476_a_(pathpoint5) && this.func_227476_a_(pathpoint13) && this.func_227476_a_(pathpoint11)) {
            p_222859_1_[i++] = pathpoint24;
        }
        if (this.func_227477_b_(pathpoint25 = this.openPoint(p_222859_2_.x - 1, p_222859_2_.y - 1, p_222859_2_.z + 1)) && this.func_227476_a_(pathpoint17) && this.func_227476_a_(pathpoint) && this.func_227476_a_(pathpoint1) && this.func_227476_a_(pathpoint5) && this.func_227476_a_(pathpoint10) && this.func_227476_a_(pathpoint11)) {
            p_222859_1_[i++] = pathpoint25;
        }
        return i;
    }

    private boolean func_227476_a_(@Nullable PathPoint p_227476_1_) {
        return p_227476_1_ != null && p_227476_1_.costMalus >= 0.0f;
    }

    private boolean func_227477_b_(@Nullable PathPoint p_227477_1_) {
        return p_227477_1_ != null && !p_227477_1_.visited;
    }

    @Override
    @Nullable
    protected PathPoint openPoint(int x, int y, int z) {
        PathPoint pathpoint = null;
        PathNodeType pathnodetype = this.getPathNodeType(this.entity, x, y, z);
        float f = this.entity.getPathPriority(pathnodetype);
        if (f >= 0.0f) {
            pathpoint = super.openPoint(x, y, z);
            pathpoint.nodeType = pathnodetype;
            pathpoint.costMalus = Math.max(pathpoint.costMalus, f);
            if (pathnodetype == PathNodeType.WALKABLE) {
                pathpoint.costMalus += 1.0f;
            }
        }
        return pathnodetype != PathNodeType.OPEN && pathnodetype != PathNodeType.WALKABLE ? pathpoint : pathpoint;
    }

    @Override
    public PathNodeType getPathNodeType(IBlockReader blockaccessIn, int x, int y, int z, MobEntity entitylivingIn, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        EnumSet<PathNodeType> enumset = EnumSet.noneOf(PathNodeType.class);
        PathNodeType pathnodetype = PathNodeType.BLOCKED;
        BlockPos blockpos = entitylivingIn.getPosition();
        pathnodetype = this.getPathNodeType(blockaccessIn, x, y, z, xSize, ySize, zSize, canBreakDoorsIn, canEnterDoorsIn, enumset, pathnodetype, blockpos);
        if (enumset.contains((Object)PathNodeType.FENCE)) {
            return PathNodeType.FENCE;
        }
        PathNodeType pathnodetype1 = PathNodeType.BLOCKED;
        for (PathNodeType pathnodetype2 : enumset) {
            if (entitylivingIn.getPathPriority(pathnodetype2) < 0.0f) {
                return pathnodetype2;
            }
            if (!(entitylivingIn.getPathPriority(pathnodetype2) >= entitylivingIn.getPathPriority(pathnodetype1))) continue;
            pathnodetype1 = pathnodetype2;
        }
        return pathnodetype == PathNodeType.OPEN && entitylivingIn.getPathPriority(pathnodetype1) == 0.0f ? PathNodeType.OPEN : pathnodetype1;
    }

    @Override
    public PathNodeType getPathNodeType(IBlockReader blockaccessIn, int x, int y, int z) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        PathNodeType pathnodetype = FlyingNodeProcessor.func_237238_b_(blockaccessIn, blockpos$mutable.setPos(x, y, z));
        if (pathnodetype == PathNodeType.OPEN && y >= 1) {
            BlockState blockstate = blockaccessIn.getBlockState(blockpos$mutable.setPos(x, y - 1, z));
            PathNodeType pathnodetype1 = FlyingNodeProcessor.func_237238_b_(blockaccessIn, blockpos$mutable.setPos(x, y - 1, z));
            pathnodetype = pathnodetype1 != PathNodeType.DAMAGE_FIRE && !blockstate.isIn(Blocks.MAGMA_BLOCK) && pathnodetype1 != PathNodeType.LAVA && !blockstate.isIn(BlockTags.CAMPFIRES) ? (pathnodetype1 == PathNodeType.DAMAGE_CACTUS ? PathNodeType.DAMAGE_CACTUS : (pathnodetype1 == PathNodeType.DAMAGE_OTHER ? PathNodeType.DAMAGE_OTHER : (pathnodetype1 == PathNodeType.COCOA ? PathNodeType.COCOA : (pathnodetype1 == PathNodeType.FENCE ? PathNodeType.FENCE : (pathnodetype1 != PathNodeType.WALKABLE && pathnodetype1 != PathNodeType.OPEN && pathnodetype1 != PathNodeType.WATER ? PathNodeType.WALKABLE : PathNodeType.OPEN))))) : PathNodeType.DAMAGE_FIRE;
        }
        if (pathnodetype == PathNodeType.WALKABLE || pathnodetype == PathNodeType.OPEN) {
            pathnodetype = FlyingNodeProcessor.func_237232_a_(blockaccessIn, blockpos$mutable.setPos(x, y, z), pathnodetype);
        }
        return pathnodetype;
    }

    private PathNodeType getPathNodeType(MobEntity p_192559_1_, BlockPos p_192559_2_) {
        return this.getPathNodeType(p_192559_1_, p_192559_2_.getX(), p_192559_2_.getY(), p_192559_2_.getZ());
    }

    private PathNodeType getPathNodeType(MobEntity p_192558_1_, int p_192558_2_, int p_192558_3_, int p_192558_4_) {
        return this.getPathNodeType(this.blockaccess, p_192558_2_, p_192558_3_, p_192558_4_, p_192558_1_, this.entitySizeX, this.entitySizeY, this.entitySizeZ, this.getCanOpenDoors(), this.getCanEnterDoors());
    }
}

