/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;

public class StatisticsManager {
    protected final Object2IntMap<Stat<?>> statsData = Object2IntMaps.synchronize((Object2IntMap)new Object2IntOpenHashMap());

    public StatisticsManager() {
        this.statsData.defaultReturnValue(0);
    }

    public void increment(PlayerEntity player, Stat<?> stat, int amount) {
        int i = (int)Math.min((long)this.getValue(stat) + (long)amount, Integer.MAX_VALUE);
        this.setValue(player, stat, i);
    }

    public void setValue(PlayerEntity playerIn, Stat<?> statIn, int p_150873_3_) {
        this.statsData.put(statIn, p_150873_3_);
    }

    public <T> int getValue(StatType<T> p_199060_1_, T p_199060_2_) {
        return p_199060_1_.contains(p_199060_2_) ? this.getValue(p_199060_1_.get(p_199060_2_)) : 0;
    }

    public int getValue(Stat<?> stat) {
        return this.statsData.getInt(stat);
    }
}

