/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.command.CommandSource;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.CommandBlockLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;

public class CommandBlockTileEntity
extends TileEntity {
    private boolean powered;
    private boolean auto;
    private boolean conditionMet;
    private boolean sendToClient;
    private final CommandBlockLogic commandBlockLogic = new CommandBlockLogic(){

        @Override
        public void setCommand(String command) {
            super.setCommand(command);
            CommandBlockTileEntity.this.markDirty();
        }

        @Override
        public ServerWorld getWorld() {
            return (ServerWorld)CommandBlockTileEntity.this.world;
        }

        @Override
        public void updateCommand() {
            BlockState blockstate = CommandBlockTileEntity.this.world.getBlockState(CommandBlockTileEntity.this.pos);
            this.getWorld().notifyBlockUpdate(CommandBlockTileEntity.this.pos, blockstate, blockstate, 3);
        }

        @Override
        public Vector3d getPositionVector() {
            return Vector3d.copyCentered(CommandBlockTileEntity.this.pos);
        }

        @Override
        public CommandSource getCommandSource() {
            return new CommandSource(this, Vector3d.copyCentered(CommandBlockTileEntity.this.pos), Vector2f.ZERO, this.getWorld(), 2, this.getName().getString(), this.getName(), this.getWorld().getServer(), null);
        }
    };

    public CommandBlockTileEntity() {
        super(TileEntityType.COMMAND_BLOCK);
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        super.write(compound);
        this.commandBlockLogic.write(compound);
        compound.putBoolean("powered", this.isPowered());
        compound.putBoolean("conditionMet", this.isConditionMet());
        compound.putBoolean("auto", this.isAuto());
        return compound;
    }

    @Override
    public void read(BlockState state, CompoundNBT nbt) {
        super.read(state, nbt);
        this.commandBlockLogic.read(nbt);
        this.powered = nbt.getBoolean("powered");
        this.conditionMet = nbt.getBoolean("conditionMet");
        this.setAuto(nbt.getBoolean("auto"));
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket getUpdatePacket() {
        if (this.isSendToClient()) {
            this.setSendToClient(false);
            CompoundNBT compoundnbt = this.write(new CompoundNBT());
            return new SUpdateTileEntityPacket(this.pos, 2, compoundnbt);
        }
        return null;
    }

    @Override
    public boolean onlyOpsCanSetNbt() {
        return true;
    }

    public CommandBlockLogic getCommandBlockLogic() {
        return this.commandBlockLogic;
    }

    public void setPowered(boolean poweredIn) {
        this.powered = poweredIn;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public void setAuto(boolean autoIn) {
        boolean flag = this.auto;
        this.auto = autoIn;
        if (!flag && autoIn && !this.powered && this.world != null && this.getMode() != Mode.SEQUENCE) {
            this.func_226988_y_();
        }
    }

    public void func_226987_h_() {
        Mode commandblocktileentity$mode = this.getMode();
        if (commandblocktileentity$mode == Mode.AUTO && (this.powered || this.auto) && this.world != null) {
            this.func_226988_y_();
        }
    }

    private void func_226988_y_() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof CommandBlockBlock) {
            this.setConditionMet();
            this.world.getPendingBlockTicks().scheduleTick(this.pos, block, 1);
        }
    }

    public boolean isConditionMet() {
        return this.conditionMet;
    }

    public boolean setConditionMet() {
        this.conditionMet = true;
        if (this.isConditional()) {
            TileEntity tileentity;
            BlockPos blockpos = this.pos.offset(this.world.getBlockState(this.pos).get(CommandBlockBlock.FACING).getOpposite());
            this.conditionMet = this.world.getBlockState(blockpos).getBlock() instanceof CommandBlockBlock ? (tileentity = this.world.getTileEntity(blockpos)) instanceof CommandBlockTileEntity && ((CommandBlockTileEntity)tileentity).getCommandBlockLogic().getSuccessCount() > 0 : false;
        }
        return this.conditionMet;
    }

    public boolean isSendToClient() {
        return this.sendToClient;
    }

    public void setSendToClient(boolean p_184252_1_) {
        this.sendToClient = p_184252_1_;
    }

    public Mode getMode() {
        BlockState blockstate = this.getBlockState();
        if (blockstate.isIn(Blocks.COMMAND_BLOCK)) {
            return Mode.REDSTONE;
        }
        if (blockstate.isIn(Blocks.REPEATING_COMMAND_BLOCK)) {
            return Mode.AUTO;
        }
        return blockstate.isIn(Blocks.CHAIN_COMMAND_BLOCK) ? Mode.SEQUENCE : Mode.REDSTONE;
    }

    public boolean isConditional() {
        BlockState blockstate = this.world.getBlockState(this.getPos());
        return blockstate.getBlock() instanceof CommandBlockBlock ? blockstate.get(CommandBlockBlock.CONDITIONAL) : false;
    }

    @Override
    public void validate() {
        this.updateContainingBlockInfo();
        super.validate();
    }

    public static enum Mode {
        SEQUENCE,
        AUTO,
        REDSTONE;

    }
}

