/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.bridge.game.GameVersion;
import java.util.Date;
import java.util.UUID;
import net.minecraft.util.SharedConstants;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinecraftVersion
implements GameVersion {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final GameVersion GAME_VERSION = new MinecraftVersion();
    private final String id = UUID.randomUUID().toString().replaceAll("-", "");
    private final String name;
    private final boolean stable;
    private final int worldVersion;
    private final int protocolVersion = SharedConstants.getNativeVersion();
    private final int packVersion;
    private final Date buildTime = new Date();
    private final String releaseTarget;

    private MinecraftVersion() {
        this.name = "1.16.4";
        this.stable = true;
        this.worldVersion = 2584;
        this.packVersion = 6;
        this.releaseTarget = "1.16.4";
    }

    public static GameVersion load() {
        return GAME_VERSION;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getReleaseTarget() {
        return this.releaseTarget;
    }

    public int getWorldVersion() {
        return this.worldVersion;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public int getPackVersion() {
        return this.packVersion;
    }

    public Date getBuildTime() {
        return this.buildTime;
    }

    public boolean isStable() {
        return this.stable;
    }
}

