/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.ArbitraryBitLengthIntArray;
import net.minecraft.util.datafix.TypeReferences;

public class LeavesFix
extends DataFix {
    private static final int[][] DIRECTIONS = new int[][]{{-1, 0, 0}, {1, 0, 0}, {0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}};
    private static final Object2IntMap<String> LEAVES = (Object2IntMap)DataFixUtils.make((Object)new Object2IntOpenHashMap(), p_208417_0_ -> {
        p_208417_0_.put((Object)"minecraft:acacia_leaves", 0);
        p_208417_0_.put((Object)"minecraft:birch_leaves", 1);
        p_208417_0_.put((Object)"minecraft:dark_oak_leaves", 2);
        p_208417_0_.put((Object)"minecraft:jungle_leaves", 3);
        p_208417_0_.put((Object)"minecraft:oak_leaves", 4);
        p_208417_0_.put((Object)"minecraft:spruce_leaves", 5);
    });
    private static final Set<String> LOGS = ImmutableSet.of((Object)"minecraft:acacia_bark", (Object)"minecraft:birch_bark", (Object)"minecraft:dark_oak_bark", (Object)"minecraft:jungle_bark", (Object)"minecraft:oak_bark", (Object)"minecraft:spruce_bark", (Object[])new String[]{"minecraft:acacia_log", "minecraft:birch_log", "minecraft:dark_oak_log", "minecraft:jungle_log", "minecraft:oak_log", "minecraft:spruce_log", "minecraft:stripped_acacia_log", "minecraft:stripped_birch_log", "minecraft:stripped_dark_oak_log", "minecraft:stripped_jungle_log", "minecraft:stripped_oak_log", "minecraft:stripped_spruce_log"});

    public LeavesFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(TypeReferences.CHUNK);
        OpticFinder opticfinder = type.findField("Level");
        OpticFinder opticfinder1 = opticfinder.type().findField("Sections");
        Type type1 = opticfinder1.type();
        if (!(type1 instanceof List.ListType)) {
            throw new IllegalStateException("Expecting sections to be a list.");
        }
        Type type2 = ((List.ListType)type1).getElement();
        OpticFinder opticfinder2 = DSL.typeFinder((Type)type2);
        return this.fixTypeEverywhereTyped("Leaves fix", type, p_208422_4_ -> p_208422_4_.updateTyped(opticfinder, p_208420_3_ -> {
            int[] aint = new int[]{0};
            Typed typed = p_208420_3_.updateTyped(opticfinder1, p_208415_3_ -> {
                Int2ObjectOpenHashMap int2objectmap = new Int2ObjectOpenHashMap(p_208415_3_.getAllTyped(opticfinder2).stream().map(p_212527_1_ -> new LeavesSection((Typed<?>)p_212527_1_, this.getInputSchema())).collect(Collectors.toMap(Section::getIndex, p_208410_0_ -> p_208410_0_)));
                if (int2objectmap.values().stream().allMatch(Section::isSkippable)) {
                    return p_208415_3_;
                }
                ArrayList list = Lists.newArrayList();
                for (int i = 0; i < 7; ++i) {
                    list.add(new IntOpenHashSet());
                }
                for (LeavesSection leavesfix$leavessection : int2objectmap.values()) {
                    if (leavesfix$leavessection.isSkippable()) continue;
                    for (int j = 0; j < 4096; ++j) {
                        int k = leavesfix$leavessection.getBlock(j);
                        if (leavesfix$leavessection.isLog(k)) {
                            ((IntSet)list.get(0)).add(leavesfix$leavessection.getIndex() << 12 | j);
                            continue;
                        }
                        if (!leavesfix$leavessection.isLeaf(k)) continue;
                        int l = this.getX(j);
                        int i1 = this.getZ(j);
                        aint[0] = aint[0] | LeavesFix.getSideMask(l == 0, l == 15, i1 == 0, i1 == 15);
                    }
                }
                for (int j3 = 1; j3 < 7; ++j3) {
                    IntSet intset = (IntSet)list.get(j3 - 1);
                    IntSet intset1 = (IntSet)list.get(j3);
                    IntIterator intiterator = intset.iterator();
                    while (intiterator.hasNext()) {
                        int k3 = intiterator.nextInt();
                        int l3 = this.getX(k3);
                        int j1 = this.getY(k3);
                        int k1 = this.getZ(k3);
                        for (int[] aint1 : DIRECTIONS) {
                            int i3;
                            int k2;
                            int l2;
                            LeavesSection leavesfix$leavessection1;
                            int l1 = l3 + aint1[0];
                            int i2 = j1 + aint1[1];
                            int j2 = k1 + aint1[2];
                            if (l1 < 0 || l1 > 15 || j2 < 0 || j2 > 15 || i2 < 0 || i2 > 255 || (leavesfix$leavessection1 = (LeavesSection)int2objectmap.get(i2 >> 4)) == null || leavesfix$leavessection1.isSkippable() || !leavesfix$leavessection1.isLeaf(l2 = leavesfix$leavessection1.getBlock(k2 = LeavesFix.getIndex(l1, i2 & 0xF, j2))) || (i3 = leavesfix$leavessection1.getDistance(l2)) <= j3) continue;
                            leavesfix$leavessection1.setDistance(k2, l2, j3);
                            intset1.add(LeavesFix.getIndex(l1, i2, j2));
                        }
                    }
                }
                return p_208415_3_.updateTyped(opticfinder2, arg_0 -> LeavesFix.lambda$makeRule$3((Int2ObjectMap)int2objectmap, arg_0));
            });
            if (aint[0] != 0) {
                typed = typed.update(DSL.remainderFinder(), p_208419_1_ -> {
                    Dynamic dynamic = (Dynamic)DataFixUtils.orElse((Optional)p_208419_1_.get("UpgradeData").result(), (Object)p_208419_1_.emptyMap());
                    return p_208419_1_.set("UpgradeData", dynamic.set("Sides", p_208419_1_.createByte((byte)(dynamic.get("Sides").asByte((byte)0) | aint[0]))));
                });
            }
            return typed;
        }));
    }

    public static int getIndex(int p_208411_0_, int p_208411_1_, int p_208411_2_) {
        return p_208411_1_ << 8 | p_208411_2_ << 4 | p_208411_0_;
    }

    private int getX(int p_208412_1_) {
        return p_208412_1_ & 0xF;
    }

    private int getY(int p_208421_1_) {
        return p_208421_1_ >> 8 & 0xFF;
    }

    private int getZ(int p_208409_1_) {
        return p_208409_1_ >> 4 & 0xF;
    }

    public static int getSideMask(boolean p_210537_0_, boolean p_210537_1_, boolean p_210537_2_, boolean p_210537_3_) {
        int i = 0;
        if (p_210537_2_) {
            i = p_210537_1_ ? (i |= 2) : (p_210537_0_ ? (i |= 0x80) : (i |= 1));
        } else if (p_210537_3_) {
            i = p_210537_0_ ? (i |= 0x20) : (p_210537_1_ ? (i |= 8) : (i |= 0x10));
        } else if (p_210537_1_) {
            i |= 4;
        } else if (p_210537_0_) {
            i |= 0x40;
        }
        return i;
    }

    private static /* synthetic */ Typed lambda$makeRule$3(Int2ObjectMap int2objectmap, Typed p_208413_1_) {
        return ((LeavesSection)int2objectmap.get(((Dynamic)p_208413_1_.get(DSL.remainderFinder())).get("Y").asInt(0))).write(p_208413_1_);
    }

    public static final class LeavesSection
    extends Section {
        @Nullable
        private IntSet field_212523_f;
        @Nullable
        private IntSet field_212524_g;
        @Nullable
        private Int2IntMap field_212525_h;

        public LeavesSection(Typed<?> p_i49851_1_, Schema p_i49851_2_) {
            super(p_i49851_1_, p_i49851_2_);
        }

        @Override
        protected boolean func_212508_a() {
            this.field_212523_f = new IntOpenHashSet();
            this.field_212524_g = new IntOpenHashSet();
            this.field_212525_h = new Int2IntOpenHashMap();
            for (int i = 0; i < this.palette.size(); ++i) {
                Dynamic dynamic = (Dynamic)this.palette.get(i);
                String s = dynamic.get("Name").asString("");
                if (LEAVES.containsKey((Object)s)) {
                    boolean flag = Objects.equals(dynamic.get("Properties").get("decayable").asString(""), "false");
                    this.field_212523_f.add(i);
                    this.field_212525_h.put(this.getStateId(s, flag, 7), i);
                    this.palette.set(i, this.makeLeafTag(dynamic, s, flag, 7));
                }
                if (!LOGS.contains(s)) continue;
                this.field_212524_g.add(i);
            }
            return this.field_212523_f.isEmpty() && this.field_212524_g.isEmpty();
        }

        private Dynamic<?> makeLeafTag(Dynamic<?> p_209770_1_, String p_209770_2_, boolean p_209770_3_, int p_209770_4_) {
            Dynamic dynamic = p_209770_1_.emptyMap();
            dynamic = dynamic.set("persistent", dynamic.createString(p_209770_3_ ? "true" : "false"));
            dynamic = dynamic.set("distance", dynamic.createString(Integer.toString(p_209770_4_)));
            Dynamic dynamic1 = p_209770_1_.emptyMap();
            dynamic1 = dynamic1.set("Properties", dynamic);
            return dynamic1.set("Name", dynamic1.createString(p_209770_2_));
        }

        public boolean isLog(int p_208457_1_) {
            return this.field_212524_g.contains(p_208457_1_);
        }

        public boolean isLeaf(int p_208460_1_) {
            return this.field_212523_f.contains(p_208460_1_);
        }

        private int getDistance(int p_208459_1_) {
            return this.isLog(p_208459_1_) ? 0 : Integer.parseInt(((Dynamic)this.palette.get(p_208459_1_)).get("Properties").get("distance").asString(""));
        }

        private void setDistance(int p_208454_1_, int p_208454_2_, int p_208454_3_) {
            boolean flag;
            Dynamic dynamic = (Dynamic)this.palette.get(p_208454_2_);
            String s = dynamic.get("Name").asString("");
            int i = this.getStateId(s, flag = Objects.equals(dynamic.get("Properties").get("persistent").asString(""), "true"), p_208454_3_);
            if (!this.field_212525_h.containsKey(i)) {
                int j = this.palette.size();
                this.field_212523_f.add(j);
                this.field_212525_h.put(i, j);
                this.palette.add(this.makeLeafTag(dynamic, s, flag, p_208454_3_));
            }
            int l = this.field_212525_h.get(i);
            if (1 << this.storage.func_233050_b_() <= l) {
                ArbitraryBitLengthIntArray arbitrarybitlengthintarray = new ArbitraryBitLengthIntArray(this.storage.func_233050_b_() + 1, 4096);
                for (int k = 0; k < 4096; ++k) {
                    arbitrarybitlengthintarray.func_233049_a_(k, this.storage.func_233048_a_(k));
                }
                this.storage = arbitrarybitlengthintarray;
            }
            this.storage.func_233049_a_(p_208454_1_, l);
        }
    }

    public static abstract class Section {
        private final Type<Pair<String, Dynamic<?>>> blockStateType = DSL.named((String)TypeReferences.BLOCK_STATE.typeName(), (Type)DSL.remainderType());
        protected final OpticFinder<List<Pair<String, Dynamic<?>>>> paletteFinder = DSL.fieldFinder((String)"Palette", (Type)DSL.list(this.blockStateType));
        protected final List palette;
        protected final int index;
        @Nullable
        protected ArbitraryBitLengthIntArray storage;

        public Section(Typed<?> p_i49850_1_, Schema p_i49850_2_) {
            if (!Objects.equals(p_i49850_2_.getType(TypeReferences.BLOCK_STATE), this.blockStateType)) {
                throw new IllegalStateException("Block state type is not what was expected.");
            }
            Optional optional = p_i49850_1_.getOptional(this.paletteFinder);
            this.palette = optional.map(p_208463_0_ -> p_208463_0_.stream().map(Pair::getSecond).collect(Collectors.toList())).orElse((List)ImmutableList.of());
            Dynamic dynamic = (Dynamic)p_i49850_1_.get(DSL.remainderFinder());
            this.index = dynamic.get("Y").asInt(0);
            this.func_212507_a(dynamic);
        }

        protected void func_212507_a(Dynamic<?> p_212507_1_) {
            if (this.func_212508_a()) {
                this.storage = null;
            } else {
                long[] along = p_212507_1_.get("BlockStates").asLongStream().toArray();
                int i = Math.max(4, DataFixUtils.ceillog2((int)this.palette.size()));
                this.storage = new ArbitraryBitLengthIntArray(i, 4096, along);
            }
        }

        public Typed<?> write(Typed<?> p_208465_1_) {
            return this.isSkippable() ? p_208465_1_ : p_208465_1_.update(DSL.remainderFinder(), p_212510_1_ -> p_212510_1_.set("BlockStates", p_212510_1_.createLongList(Arrays.stream(this.storage.func_233047_a_())))).set(this.paletteFinder, this.palette.stream().map(p_212509_0_ -> Pair.of((Object)TypeReferences.BLOCK_STATE.typeName(), (Object)p_212509_0_)).collect(Collectors.toList()));
        }

        public boolean isSkippable() {
            return this.storage == null;
        }

        public int getBlock(int p_208453_1_) {
            return this.storage.func_233048_a_(p_208453_1_);
        }

        protected int getStateId(String p_208464_1_, boolean p_208464_2_, int p_208464_3_) {
            return LEAVES.get((Object)p_208464_1_) << 5 | (p_208464_2_ ? 16 : 0) | p_208464_3_;
        }

        int getIndex() {
            return this.index;
        }

        protected abstract boolean func_212508_a();
    }
}

