/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.palette;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.palette.IPalette;
import net.minecraft.util.palette.IResizeCallback;

public class HashMapPalette<T>
implements IPalette<T> {
    private final ObjectIntIdentityMap<T> registry;
    private final IntIdentityHashBiMap<T> statePaletteMap;
    private final IResizeCallback<T> paletteResizer;
    private final Function<CompoundNBT, T> deserializer;
    private final Function<T, CompoundNBT> serializer;
    private final int bits;

    public HashMapPalette(ObjectIntIdentityMap<T> backingRegistry, int bitsIn, IResizeCallback<T> paletteResizerIn, Function<CompoundNBT, T> deserializerIn, Function<T, CompoundNBT> p_i48964_5_) {
        this.registry = backingRegistry;
        this.bits = bitsIn;
        this.paletteResizer = paletteResizerIn;
        this.deserializer = deserializerIn;
        this.serializer = p_i48964_5_;
        this.statePaletteMap = new IntIdentityHashBiMap(1 << bitsIn);
    }

    @Override
    public int idFor(T state) {
        int i = this.statePaletteMap.getId(state);
        if (i == -1 && (i = this.statePaletteMap.add(state)) >= 1 << this.bits) {
            i = this.paletteResizer.onResize(this.bits + 1, state);
        }
        return i;
    }

    @Override
    public boolean func_230341_a_(Predicate<T> p_230341_1_) {
        for (int i = 0; i < this.getPaletteSize(); ++i) {
            if (!p_230341_1_.test(this.statePaletteMap.getByValue(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public T get(int indexKey) {
        return this.statePaletteMap.getByValue(indexKey);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.statePaletteMap.clear();
        int i = buf.readVarInt();
        for (int j = 0; j < i; ++j) {
            this.statePaletteMap.add(this.registry.getByValue(buf.readVarInt()));
        }
    }

    @Override
    public void write(PacketBuffer buf) {
        int i = this.getPaletteSize();
        buf.writeVarInt(i);
        for (int j = 0; j < i; ++j) {
            buf.writeVarInt(this.registry.getId(this.statePaletteMap.getByValue(j)));
        }
    }

    @Override
    public int getSerializedSize() {
        int i = PacketBuffer.getVarIntSize(this.getPaletteSize());
        for (int j = 0; j < this.getPaletteSize(); ++j) {
            i += PacketBuffer.getVarIntSize(this.registry.getId(this.statePaletteMap.getByValue(j)));
        }
        return i;
    }

    public int getPaletteSize() {
        return this.statePaletteMap.size();
    }

    @Override
    public void read(ListNBT nbt) {
        this.statePaletteMap.clear();
        for (int i = 0; i < nbt.size(); ++i) {
            this.statePaletteMap.add(this.deserializer.apply(nbt.getCompound(i)));
        }
    }

    public void writePaletteToList(ListNBT paletteList) {
        for (int i = 0; i < this.getPaletteSize(); ++i) {
            paletteList.add((INBT)this.serializer.apply(this.statePaletteMap.getByValue(i)));
        }
    }
}

