/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;

public class DefaultedRegistry<T>
extends SimpleRegistry<T> {
    private final ResourceLocation defaultValueKey;
    private T defaultValue;

    public DefaultedRegistry(String defaultValueKey, RegistryKey<? extends Registry<T>> registryKey, Lifecycle lifecycle) {
        super(registryKey, lifecycle);
        this.defaultValueKey = new ResourceLocation(defaultValueKey);
    }

    @Override
    public <V extends T> V register(int id, RegistryKey<T> name, V instance, Lifecycle lifecycle) {
        if (this.defaultValueKey.equals(name.getLocation())) {
            this.defaultValue = instance;
        }
        return super.register(id, name, instance, lifecycle);
    }

    @Override
    public int getId(@Nullable T value) {
        int i = super.getId(value);
        return i == -1 ? super.getId(this.defaultValue) : i;
    }

    @Override
    @Nonnull
    public ResourceLocation getKey(T value) {
        ResourceLocation resourcelocation = super.getKey(value);
        return resourcelocation == null ? this.defaultValueKey : resourcelocation;
    }

    @Override
    @Nonnull
    public T getOrDefault(@Nullable ResourceLocation name) {
        Object t = super.getOrDefault(name);
        return t == null ? this.defaultValue : t;
    }

    @Override
    public Optional<T> getOptional(@Nullable ResourceLocation id) {
        return Optional.ofNullable(super.getOrDefault(id));
    }

    @Override
    @Nonnull
    public T getByValue(int value) {
        Object t = super.getByValue(value);
        return t == null ? this.defaultValue : t;
    }

    @Override
    @Nonnull
    public T getRandom(Random random) {
        Object t = super.getRandom(random);
        return t == null ? this.defaultValue : t;
    }

    public ResourceLocation getDefaultKey() {
        return this.defaultValueKey;
    }
}

