/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class PointOfInterestData {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Short2ObjectMap<PointOfInterest> records = new Short2ObjectOpenHashMap();
    private final Map<PointOfInterestType, Set<PointOfInterest>> byType = Maps.newHashMap();
    private final Runnable onChange;
    private boolean valid;

    public static Codec<PointOfInterestData> func_234158_a_(Runnable p_234158_0_) {
        return RecordCodecBuilder.create(p_234159_1_ -> p_234159_1_.group((App)RecordCodecBuilder.point((Object)p_234158_0_), (App)Codec.BOOL.optionalFieldOf("Valid", (Object)false).forGetter(data -> data.valid), (App)PointOfInterest.func_234150_a_(p_234158_0_).listOf().fieldOf("Records").forGetter(data -> ImmutableList.copyOf((Collection)data.records.values()))).apply((Applicative)p_234159_1_, PointOfInterestData::new)).orElseGet(Util.func_240982_a_("Failed to read POI section: ", arg_0 -> ((Logger)LOGGER).error(arg_0)), () -> new PointOfInterestData(p_234158_0_, false, (List<PointOfInterest>)ImmutableList.of()));
    }

    public PointOfInterestData(Runnable onChangeIn) {
        this(onChangeIn, true, (List<PointOfInterest>)ImmutableList.of());
    }

    private PointOfInterestData(Runnable onChange, boolean valid, List<PointOfInterest> interestPoints) {
        this.onChange = onChange;
        this.valid = valid;
        interestPoints.forEach(this::add);
    }

    public Stream<PointOfInterest> getRecords(Predicate<PointOfInterestType> typePredicate, PointOfInterestManager.Status status) {
        return this.byType.entrySet().stream().filter(typeToPointEntry -> typePredicate.test((PointOfInterestType)typeToPointEntry.getKey())).flatMap(p_234160_0_ -> ((Set)p_234160_0_.getValue()).stream()).filter(status.getTest());
    }

    public void add(BlockPos pos, PointOfInterestType type) {
        if (this.add(new PointOfInterest(pos, type, this.onChange))) {
            LOGGER.debug("Added POI of type {} @ {}", new Supplier[]{() -> type, () -> pos});
            this.onChange.run();
        }
    }

    private boolean add(PointOfInterest p_218254_1_) {
        BlockPos blockpos = p_218254_1_.getPos();
        PointOfInterestType pointofinteresttype = p_218254_1_.getType();
        short short1 = SectionPos.toRelativeOffset(blockpos);
        PointOfInterest pointofinterest = (PointOfInterest)this.records.get(short1);
        if (pointofinterest != null) {
            if (pointofinteresttype.equals(pointofinterest.getType())) {
                return false;
            }
            throw Util.pauseDevMode(new IllegalStateException("POI data mismatch: already registered at " + String.valueOf(blockpos)));
        }
        this.records.put(short1, (Object)p_218254_1_);
        this.byType.computeIfAbsent(pointofinteresttype, type -> Sets.newHashSet()).add(p_218254_1_);
        return true;
    }

    public void remove(BlockPos pos) {
        PointOfInterest pointofinterest = (PointOfInterest)this.records.remove(SectionPos.toRelativeOffset(pos));
        if (pointofinterest == null) {
            LOGGER.error("POI data mismatch: never registered at " + String.valueOf(pos));
        } else {
            this.byType.get(pointofinterest.getType()).remove(pointofinterest);
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = pointofinterest::getType;
            supplierArray[1] = pointofinterest::getPos;
            LOGGER.debug("Removed POI of type {} @ {}", supplierArray);
            this.onChange.run();
        }
    }

    public boolean release(BlockPos pos) {
        PointOfInterest pointofinterest = (PointOfInterest)this.records.get(SectionPos.toRelativeOffset(pos));
        if (pointofinterest == null) {
            throw Util.pauseDevMode(new IllegalStateException("POI never registered at " + String.valueOf(pos)));
        }
        boolean flag = pointofinterest.release();
        this.onChange.run();
        return flag;
    }

    public boolean exists(BlockPos pos, Predicate<PointOfInterestType> typePredicate) {
        short short1 = SectionPos.toRelativeOffset(pos);
        PointOfInterest pointofinterest = (PointOfInterest)this.records.get(short1);
        return pointofinterest != null && typePredicate.test(pointofinterest.getType());
    }

    public Optional<PointOfInterestType> getType(BlockPos pos) {
        short short1 = SectionPos.toRelativeOffset(pos);
        PointOfInterest pointofinterest = (PointOfInterest)this.records.get(short1);
        return pointofinterest != null ? Optional.of(pointofinterest.getType()) : Optional.empty();
    }

    public void refresh(Consumer<BiConsumer<BlockPos, PointOfInterestType>> posToTypeConsumer) {
        if (!this.valid) {
            Short2ObjectOpenHashMap short2objectmap = new Short2ObjectOpenHashMap(this.records);
            this.clear();
            posToTypeConsumer.accept((arg_0, arg_1) -> this.lambda$refresh$10((Short2ObjectMap)short2objectmap, arg_0, arg_1));
            this.valid = true;
            this.onChange.run();
        }
    }

    private void clear() {
        this.records.clear();
        this.byType.clear();
    }

    boolean isValid() {
        return this.valid;
    }

    private /* synthetic */ void lambda$refresh$10(Short2ObjectMap short2objectmap, BlockPos pos, PointOfInterestType type) {
        short short1 = SectionPos.toRelativeOffset(pos);
        PointOfInterest pointofinterest = (PointOfInterest)short2objectmap.computeIfAbsent(short1, p_234156_3_ -> new PointOfInterest(pos, type, this.onChange));
        this.add(pointofinterest);
    }
}

