/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.audio.BackgroundMusicSelector;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryKeyCodec;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.biome.SoundAdditionsAmbience;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Biome {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Codec<Biome> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Climate.CODEC.forGetter(biome -> biome.climate), (App)Category.CODEC.fieldOf("category").forGetter(biome -> biome.category), (App)Codec.FLOAT.fieldOf("depth").forGetter(biome -> Float.valueOf(biome.depth)), (App)Codec.FLOAT.fieldOf("scale").forGetter(biome -> Float.valueOf(biome.scale)), (App)BiomeAmbience.CODEC.fieldOf("effects").forGetter(biome -> biome.effects), (App)BiomeGenerationSettings.CODEC.forGetter(biome -> biome.biomeGenerationSettings), (App)MobSpawnInfo.CODEC.forGetter(biome -> biome.mobSpawnInfo)).apply((Applicative)builder, Biome::new));
    public static final Codec<Biome> PACKET_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Climate.CODEC.forGetter(biome -> biome.climate), (App)Category.CODEC.fieldOf("category").forGetter(biome -> biome.category), (App)Codec.FLOAT.fieldOf("depth").forGetter(biome -> Float.valueOf(biome.depth)), (App)Codec.FLOAT.fieldOf("scale").forGetter(biome -> Float.valueOf(biome.scale)), (App)BiomeAmbience.CODEC.fieldOf("effects").forGetter(biome -> biome.effects)).apply((Applicative)builder, (climate, category, depth, scale, ambience) -> new Biome((Climate)climate, (Category)category, depth.floatValue(), scale.floatValue(), (BiomeAmbience)ambience, BiomeGenerationSettings.DEFAULT_SETTINGS, MobSpawnInfo.EMPTY)));
    public static final Codec<Supplier<Biome>> BIOME_CODEC = RegistryKeyCodec.create(Registry.BIOME_KEY, CODEC);
    public static final Codec<List<Supplier<Biome>>> BIOMES_CODEC = RegistryKeyCodec.getValueCodecs(Registry.BIOME_KEY, CODEC);
    private final Map<Integer, List<Structure<?>>> biomeStructures = Registry.STRUCTURE_FEATURE.stream().collect(Collectors.groupingBy(structure -> structure.func_236396_f_().ordinal()));
    private static final PerlinNoiseGenerator TEMPERATURE_NOISE = new PerlinNoiseGenerator(new SharedSeedRandom(1234L), (List<Integer>)ImmutableList.of((Object)0));
    private static final PerlinNoiseGenerator FROZEN_TEMPERATURE_NOISE = new PerlinNoiseGenerator(new SharedSeedRandom(3456L), (List<Integer>)ImmutableList.of((Object)-2, (Object)-1, (Object)0));
    public static final PerlinNoiseGenerator INFO_NOISE = new PerlinNoiseGenerator(new SharedSeedRandom(2345L), (List<Integer>)ImmutableList.of((Object)0));
    private final Climate climate;
    private final BiomeGenerationSettings biomeGenerationSettings;
    private final MobSpawnInfo mobSpawnInfo;
    private final float depth;
    private final float scale;
    private final Category category;
    private final BiomeAmbience effects;
    private final ThreadLocal<Long2FloatLinkedOpenHashMap> temperatureCache = ThreadLocal.withInitial(() -> Util.make(() -> {
        Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = new Long2FloatLinkedOpenHashMap(1024, 0.25f){

            protected void rehash(int p_rehash_1_) {
            }
        };
        long2floatlinkedopenhashmap.defaultReturnValue(Float.NaN);
        return long2floatlinkedopenhashmap;
    }));

    private Biome(Climate climate, Category category, float depth, float scale, BiomeAmbience effects, BiomeGenerationSettings biomeGenerationSettings, MobSpawnInfo mobSpawnInfo) {
        this.climate = climate;
        this.biomeGenerationSettings = biomeGenerationSettings;
        this.mobSpawnInfo = mobSpawnInfo;
        this.category = category;
        this.depth = depth;
        this.scale = scale;
        this.effects = effects;
    }

    public int getSkyColor() {
        return this.effects.getSkyColor();
    }

    public MobSpawnInfo getMobSpawnInfo() {
        return this.mobSpawnInfo;
    }

    public RainType getPrecipitation() {
        return this.climate.precipitation;
    }

    public boolean isHighHumidity() {
        return this.getDownfall() > 0.85f;
    }

    private float getTemperatureAtPosition(BlockPos pos) {
        float f = this.climate.temperatureModifier.getTemperatureAtPosition(pos, this.getTemperature());
        if (pos.getY() > 64) {
            float f1 = (float)(TEMPERATURE_NOISE.noiseAt((float)pos.getX() / 8.0f, (float)pos.getZ() / 8.0f, false) * 4.0);
            return f - (f1 + (float)pos.getY() - 64.0f) * 0.05f / 30.0f;
        }
        return f;
    }

    public final float getTemperature(BlockPos pos) {
        long i = pos.toLong();
        Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = this.temperatureCache.get();
        float f = long2floatlinkedopenhashmap.get(i);
        if (!Float.isNaN(f)) {
            return f;
        }
        float f1 = this.getTemperatureAtPosition(pos);
        if (long2floatlinkedopenhashmap.size() == 1024) {
            long2floatlinkedopenhashmap.removeFirstFloat();
        }
        long2floatlinkedopenhashmap.put(i, f1);
        return f1;
    }

    public boolean doesWaterFreeze(IWorldReader worldIn, BlockPos pos) {
        return this.doesWaterFreeze(worldIn, pos, true);
    }

    public boolean doesWaterFreeze(IWorldReader worldIn, BlockPos water, boolean mustBeAtEdge) {
        if (this.getTemperature(water) >= 0.15f) {
            return false;
        }
        if (water.getY() >= 0 && water.getY() < 256 && worldIn.getLightFor(LightType.BLOCK, water) < 10) {
            BlockState blockstate = worldIn.getBlockState(water);
            FluidState fluidstate = worldIn.getFluidState(water);
            if (fluidstate.getFluid() == Fluids.WATER && blockstate.getBlock() instanceof FlowingFluidBlock) {
                boolean flag;
                if (!mustBeAtEdge) {
                    return true;
                }
                boolean bl = flag = worldIn.hasWater(water.west()) && worldIn.hasWater(water.east()) && worldIn.hasWater(water.north()) && worldIn.hasWater(water.south());
                if (!flag) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean doesSnowGenerate(IWorldReader worldIn, BlockPos pos) {
        BlockState blockstate;
        if (this.getTemperature(pos) >= 0.15f) {
            return false;
        }
        return pos.getY() >= 0 && pos.getY() < 256 && worldIn.getLightFor(LightType.BLOCK, pos) < 10 && (blockstate = worldIn.getBlockState(pos)).isAir() && Blocks.SNOW.getDefaultState().isValidPosition(worldIn, pos);
    }

    public BiomeGenerationSettings getGenerationSettings() {
        return this.biomeGenerationSettings;
    }

    public void generateFeatures(StructureManager structureManager, ChunkGenerator chunkGenerator, WorldGenRegion worldGenRegion, long seed, SharedSeedRandom rand, BlockPos pos) {
        List<List<Supplier<ConfiguredFeature<?, ?>>>> list = this.biomeGenerationSettings.getFeatures();
        int i = GenerationStage.Decoration.values().length;
        for (int j = 0; j < i; ++j) {
            int k = 0;
            if (structureManager.func_235005_a_()) {
                for (Structure structure : this.biomeStructures.getOrDefault(j, Collections.emptyList())) {
                    rand.setFeatureSeed(seed, k, j);
                    int l = pos.getX() >> 4;
                    int i1 = pos.getZ() >> 4;
                    int j1 = l << 4;
                    int k1 = i1 << 4;
                    try {
                        structureManager.func_235011_a_(SectionPos.from(pos), structure).forEach(structureStart -> structureStart.func_230366_a_(worldGenRegion, structureManager, chunkGenerator, rand, new MutableBoundingBox(j1, k1, j1 + 15, k1 + 15), new ChunkPos(l, i1)));
                    }
                    catch (Exception exception) {
                        CrashReport crashreport = CrashReport.makeCrashReport(exception, "Feature placement");
                        crashreport.makeCategory("Feature").addDetail("Id", Registry.STRUCTURE_FEATURE.getKey(structure)).addDetail("Description", () -> structure.toString());
                        throw new ReportedException(crashreport);
                    }
                    ++k;
                }
            }
            if (list.size() <= j) continue;
            for (Supplier supplier : list.get(j)) {
                ConfiguredFeature configuredfeature = (ConfiguredFeature)supplier.get();
                rand.setFeatureSeed(seed, k, j);
                try {
                    configuredfeature.func_242765_a(worldGenRegion, chunkGenerator, rand, pos);
                }
                catch (Exception exception1) {
                    CrashReport crashreport1 = CrashReport.makeCrashReport(exception1, "Feature placement");
                    crashreport1.makeCategory("Feature").addDetail("Id", Registry.FEATURE.getKey((Feature<?>)configuredfeature.feature)).addDetail("Config", configuredfeature.config).addDetail("Description", () -> configuredfeature.feature.toString());
                    throw new ReportedException(crashreport1);
                }
                ++k;
            }
        }
    }

    public int getFogColor() {
        return this.effects.getFogColor();
    }

    public int getGrassColor(double posX, double posZ) {
        int i = this.effects.getGrassColor().orElseGet(this::getGrassColorByClimate);
        return this.effects.getGrassColorModifier().getModifiedGrassColor(posX, posZ, i);
    }

    private int getGrassColorByClimate() {
        double d0 = MathHelper.clamp(this.climate.temperature, 0.0f, 1.0f);
        double d1 = MathHelper.clamp(this.climate.downfall, 0.0f, 1.0f);
        return GrassColors.get(d0, d1);
    }

    public int getFoliageColor() {
        return this.effects.getFoliageColor().orElseGet(this::getFoliageColorByClimate);
    }

    private int getFoliageColorByClimate() {
        double d0 = MathHelper.clamp(this.climate.temperature, 0.0f, 1.0f);
        double d1 = MathHelper.clamp(this.climate.downfall, 0.0f, 1.0f);
        return FoliageColors.get(d0, d1);
    }

    public void buildSurface(Random random, IChunk chunkIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed) {
        ConfiguredSurfaceBuilder<?> configuredsurfacebuilder = this.biomeGenerationSettings.getSurfaceBuilder().get();
        configuredsurfacebuilder.setSeed(seed);
        configuredsurfacebuilder.buildSurface(random, chunkIn, this, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed);
    }

    public final float getDepth() {
        return this.depth;
    }

    public final float getDownfall() {
        return this.climate.downfall;
    }

    public final float getScale() {
        return this.scale;
    }

    public final float getTemperature() {
        return this.climate.temperature;
    }

    public BiomeAmbience getAmbience() {
        return this.effects;
    }

    public final int getWaterColor() {
        return this.effects.getWaterColor();
    }

    public final int getWaterFogColor() {
        return this.effects.getWaterFogColor();
    }

    public Optional<ParticleEffectAmbience> getAmbientParticle() {
        return this.effects.getParticle();
    }

    public Optional<SoundEvent> getAmbientSound() {
        return this.effects.getAmbientSound();
    }

    public Optional<MoodSoundAmbience> getMoodSound() {
        return this.effects.getMoodSound();
    }

    public Optional<SoundAdditionsAmbience> getAdditionalAmbientSound() {
        return this.effects.getAdditionsSound();
    }

    public Optional<BackgroundMusicSelector> getBackgroundMusic() {
        return this.effects.getMusic();
    }

    public final Category getCategory() {
        return this.category;
    }

    public String toString() {
        ResourceLocation resourcelocation = WorldGenRegistries.BIOME.getKey(this);
        return resourcelocation == null ? super.toString() : resourcelocation.toString();
    }

    static class Climate {
        public static final MapCodec<Climate> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)RainType.CODEC.fieldOf("precipitation").forGetter(precipitation -> precipitation.precipitation), (App)Codec.FLOAT.fieldOf("temperature").forGetter(climate -> Float.valueOf(climate.temperature)), (App)TemperatureModifier.CODEC.optionalFieldOf("temperature_modifier", (Object)TemperatureModifier.NONE).forGetter(climate -> climate.temperatureModifier), (App)Codec.FLOAT.fieldOf("downfall").forGetter(climate -> Float.valueOf(climate.downfall))).apply((Applicative)builder, Climate::new));
        private final RainType precipitation;
        private final float temperature;
        private final TemperatureModifier temperatureModifier;
        private final float downfall;

        private Climate(RainType precipitation, float temperature, TemperatureModifier temperatureModifier, float downfall) {
            this.precipitation = precipitation;
            this.temperature = temperature;
            this.temperatureModifier = temperatureModifier;
            this.downfall = downfall;
        }
    }

    public static enum Category implements IStringSerializable
    {
        NONE("none"),
        TAIGA("taiga"),
        EXTREME_HILLS("extreme_hills"),
        JUNGLE("jungle"),
        MESA("mesa"),
        PLAINS("plains"),
        SAVANNA("savanna"),
        ICY("icy"),
        THEEND("the_end"),
        BEACH("beach"),
        FOREST("forest"),
        OCEAN("ocean"),
        DESERT("desert"),
        RIVER("river"),
        SWAMP("swamp"),
        MUSHROOM("mushroom"),
        NETHER("nether");

        public static final Codec<Category> CODEC;
        private static final Map<String, Category> BY_NAME;
        private final String name;

        private Category(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Category byName(String name) {
            return BY_NAME.get(name);
        }

        @Override
        public String getString() {
            return this.name;
        }

        static {
            CODEC = IStringSerializable.createEnumCodec(Category::values, Category::byName);
            BY_NAME = Arrays.stream(Category.values()).collect(Collectors.toMap(Category::getName, category -> category));
        }
    }

    public static enum RainType implements IStringSerializable
    {
        NONE("none"),
        RAIN("rain"),
        SNOW("snow");

        public static final Codec<RainType> CODEC;
        private static final Map<String, RainType> BY_NAME;
        private final String name;

        private RainType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static RainType getRainType(String name) {
            return BY_NAME.get(name);
        }

        @Override
        public String getString() {
            return this.name;
        }

        static {
            CODEC = IStringSerializable.createEnumCodec(RainType::values, RainType::getRainType);
            BY_NAME = Arrays.stream(RainType.values()).collect(Collectors.toMap(RainType::getName, precipitation -> precipitation));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TemperatureModifier implements IStringSerializable
    {
        NONE("none"){

            @Override
            public float getTemperatureAtPosition(BlockPos pos, float temperature) {
                return temperature;
            }
        }
        ,
        FROZEN("frozen"){

            @Override
            public float getTemperatureAtPosition(BlockPos pos, float temperature) {
                double d3;
                double d1;
                double d0 = FROZEN_TEMPERATURE_NOISE.noiseAt((double)pos.getX() * 0.05, (double)pos.getZ() * 0.05, false) * 7.0;
                double d2 = d0 + (d1 = INFO_NOISE.noiseAt((double)pos.getX() * 0.2, (double)pos.getZ() * 0.2, false));
                if (d2 < 0.3 && (d3 = INFO_NOISE.noiseAt((double)pos.getX() * 0.09, (double)pos.getZ() * 0.09, false)) < 0.8) {
                    return 0.2f;
                }
                return temperature;
            }
        };

        private final String name;
        public static final Codec<TemperatureModifier> CODEC;
        private static final Map<String, TemperatureModifier> NAME_TO_MODIFIER_MAP;

        public abstract float getTemperatureAtPosition(BlockPos var1, float var2);

        private TemperatureModifier(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getString() {
            return this.name;
        }

        public static TemperatureModifier byName(String name) {
            return NAME_TO_MODIFIER_MAP.get(name);
        }

        static {
            CODEC = IStringSerializable.createEnumCodec(TemperatureModifier::values, TemperatureModifier::byName);
            NAME_TO_MODIFIER_MAP = Arrays.stream(TemperatureModifier.values()).collect(Collectors.toMap(TemperatureModifier::getName, temperatureModifier -> temperatureModifier));
        }
    }

    public static class Builder {
        @Nullable
        private RainType precipitation;
        @Nullable
        private Category category;
        @Nullable
        private Float depth;
        @Nullable
        private Float scale;
        @Nullable
        private Float temperature;
        private TemperatureModifier temperatureModifier = TemperatureModifier.NONE;
        @Nullable
        private Float downfall;
        @Nullable
        private BiomeAmbience effects;
        @Nullable
        private MobSpawnInfo mobSpawnSettings;
        @Nullable
        private BiomeGenerationSettings generationSettings;

        public Builder precipitation(RainType precipitationIn) {
            this.precipitation = precipitationIn;
            return this;
        }

        public Builder category(Category biomeCategory) {
            this.category = biomeCategory;
            return this;
        }

        public Builder depth(float depthIn) {
            this.depth = Float.valueOf(depthIn);
            return this;
        }

        public Builder scale(float scaleIn) {
            this.scale = Float.valueOf(scaleIn);
            return this;
        }

        public Builder temperature(float temperatureIn) {
            this.temperature = Float.valueOf(temperatureIn);
            return this;
        }

        public Builder downfall(float downfallIn) {
            this.downfall = Float.valueOf(downfallIn);
            return this;
        }

        public Builder setEffects(BiomeAmbience effects) {
            this.effects = effects;
            return this;
        }

        public Builder withMobSpawnSettings(MobSpawnInfo mobSpawnSettings) {
            this.mobSpawnSettings = mobSpawnSettings;
            return this;
        }

        public Builder withGenerationSettings(BiomeGenerationSettings generationSettings) {
            this.generationSettings = generationSettings;
            return this;
        }

        public Builder withTemperatureModifier(TemperatureModifier temperatureSettings) {
            this.temperatureModifier = temperatureSettings;
            return this;
        }

        public Biome build() {
            if (this.precipitation != null && this.category != null && this.depth != null && this.scale != null && this.temperature != null && this.downfall != null && this.effects != null && this.mobSpawnSettings != null && this.generationSettings != null) {
                return new Biome(new Climate(this.precipitation, this.temperature.floatValue(), this.temperatureModifier, this.downfall.floatValue()), this.category, this.depth.floatValue(), this.scale.floatValue(), this.effects, this.generationSettings, this.mobSpawnSettings);
            }
            throw new IllegalStateException("You are missing parameters to build a proper biome\n" + String.valueOf(this));
        }

        public String toString() {
            return "BiomeBuilder{\nprecipitation=" + String.valueOf(this.precipitation) + ",\nbiomeCategory=" + String.valueOf(this.category) + ",\ndepth=" + this.depth + ",\nscale=" + this.scale + ",\ntemperature=" + this.temperature + ",\ntemperatureModifier=" + String.valueOf(this.temperatureModifier) + ",\ndownfall=" + this.downfall + ",\nspecialEffects=" + String.valueOf(this.effects) + ",\nmobSpawnSettings=" + String.valueOf(this.mobSpawnSettings) + ",\ngenerationSettings=" + String.valueOf(this.generationSettings) + ",\n}";
        }
    }

    public static class Attributes {
        public static final Codec<Attributes> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.floatRange((float)-2.0f, (float)2.0f).fieldOf("temperature").forGetter(attributes -> Float.valueOf(attributes.temperature)), (App)Codec.floatRange((float)-2.0f, (float)2.0f).fieldOf("humidity").forGetter(attributes -> Float.valueOf(attributes.humidity)), (App)Codec.floatRange((float)-2.0f, (float)2.0f).fieldOf("altitude").forGetter(attributes -> Float.valueOf(attributes.altitude)), (App)Codec.floatRange((float)-2.0f, (float)2.0f).fieldOf("weirdness").forGetter(attributes -> Float.valueOf(attributes.weirdness)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("offset").forGetter(attributes -> Float.valueOf(attributes.offset))).apply((Applicative)builder, Attributes::new));
        private final float temperature;
        private final float humidity;
        private final float altitude;
        private final float weirdness;
        private final float offset;

        public Attributes(float temperature, float humidity, float altitude, float weirdness, float offset) {
            this.temperature = temperature;
            this.humidity = humidity;
            this.altitude = altitude;
            this.weirdness = weirdness;
            this.offset = offset;
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                Attributes biome$attributes = (Attributes)p_equals_1_;
                if (Float.compare(biome$attributes.temperature, this.temperature) != 0) {
                    return false;
                }
                if (Float.compare(biome$attributes.humidity, this.humidity) != 0) {
                    return false;
                }
                if (Float.compare(biome$attributes.altitude, this.altitude) != 0) {
                    return false;
                }
                return Float.compare(biome$attributes.weirdness, this.weirdness) == 0;
            }
            return false;
        }

        public int hashCode() {
            int i = this.temperature != 0.0f ? Float.floatToIntBits(this.temperature) : 0;
            i = 31 * i + (this.humidity != 0.0f ? Float.floatToIntBits(this.humidity) : 0);
            i = 31 * i + (this.altitude != 0.0f ? Float.floatToIntBits(this.altitude) : 0);
            return 31 * i + (this.weirdness != 0.0f ? Float.floatToIntBits(this.weirdness) : 0);
        }

        public float getAttributeDifference(Attributes attributes) {
            return (this.temperature - attributes.temperature) * (this.temperature - attributes.temperature) + (this.humidity - attributes.humidity) * (this.humidity - attributes.humidity) + (this.altitude - attributes.altitude) * (this.altitude - attributes.altitude) + (this.weirdness - attributes.weirdness) * (this.weirdness - attributes.weirdness) + (this.offset - attributes.offset) * (this.offset - attributes.offset);
        }
    }
}

