/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.jigsaw;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.jigsaw.EmptyJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.FeatureJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.LegacySingleJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.ListJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public abstract class JigsawPiece {
    public static final Codec<JigsawPiece> field_236847_e_ = Registry.STRUCTURE_POOL_ELEMENT.dispatch("element_type", JigsawPiece::getType, IJigsawDeserializer::codec);
    @Nullable
    private volatile JigsawPattern.PlacementBehaviour projection;

    protected static <E extends JigsawPiece> RecordCodecBuilder<E, JigsawPattern.PlacementBehaviour> func_236848_d_() {
        return JigsawPattern.PlacementBehaviour.field_236858_c_.fieldOf("projection").forGetter(JigsawPiece::getPlacementBehaviour);
    }

    protected JigsawPiece(JigsawPattern.PlacementBehaviour projection) {
        this.projection = projection;
    }

    public abstract List<Template.BlockInfo> getJigsawBlocks(TemplateManager var1, BlockPos var2, Rotation var3, Random var4);

    public abstract MutableBoundingBox getBoundingBox(TemplateManager var1, BlockPos var2, Rotation var3);

    public abstract boolean func_230378_a_(TemplateManager var1, ISeedReader var2, StructureManager var3, ChunkGenerator var4, BlockPos var5, BlockPos var6, Rotation var7, MutableBoundingBox var8, Random var9, boolean var10);

    public abstract IJigsawDeserializer<?> getType();

    public void handleDataMarker(IWorld worldIn, Template.BlockInfo p_214846_2_, BlockPos pos, Rotation rotationIn, Random rand, MutableBoundingBox p_214846_6_) {
    }

    public JigsawPiece setPlacementBehaviour(JigsawPattern.PlacementBehaviour placementBehaviour) {
        this.projection = placementBehaviour;
        return this;
    }

    public JigsawPattern.PlacementBehaviour getPlacementBehaviour() {
        JigsawPattern.PlacementBehaviour jigsawpattern$placementbehaviour = this.projection;
        if (jigsawpattern$placementbehaviour == null) {
            throw new IllegalStateException();
        }
        return jigsawpattern$placementbehaviour;
    }

    public int getGroundLevelDelta() {
        return 1;
    }

    public static Function<JigsawPattern.PlacementBehaviour, EmptyJigsawPiece> func_242864_g() {
        return p_242857_0_ -> EmptyJigsawPiece.INSTANCE;
    }

    public static Function<JigsawPattern.PlacementBehaviour, LegacySingleJigsawPiece> func_242849_a(String p_242849_0_) {
        return p_242860_1_ -> new LegacySingleJigsawPiece((Either<ResourceLocation, Template>)Either.left((Object)new ResourceLocation(p_242849_0_)), () -> ProcessorLists.field_244101_a, (JigsawPattern.PlacementBehaviour)p_242860_1_);
    }

    public static Function<JigsawPattern.PlacementBehaviour, LegacySingleJigsawPiece> func_242851_a(String p_242851_0_, StructureProcessorList p_242851_1_) {
        return p_242862_2_ -> new LegacySingleJigsawPiece((Either<ResourceLocation, Template>)Either.left((Object)new ResourceLocation(p_242851_0_)), () -> p_242851_1_, (JigsawPattern.PlacementBehaviour)p_242862_2_);
    }

    public static Function<JigsawPattern.PlacementBehaviour, SingleJigsawPiece> func_242859_b(String p_242859_0_) {
        return p_242850_1_ -> new SingleJigsawPiece((Either<ResourceLocation, Template>)Either.left((Object)new ResourceLocation(p_242859_0_)), () -> ProcessorLists.field_244101_a, (JigsawPattern.PlacementBehaviour)p_242850_1_);
    }

    public static Function<JigsawPattern.PlacementBehaviour, SingleJigsawPiece> func_242861_b(String p_242861_0_, StructureProcessorList p_242861_1_) {
        return p_242852_2_ -> new SingleJigsawPiece((Either<ResourceLocation, Template>)Either.left((Object)new ResourceLocation(p_242861_0_)), () -> p_242861_1_, (JigsawPattern.PlacementBehaviour)p_242852_2_);
    }

    public static Function<JigsawPattern.PlacementBehaviour, FeatureJigsawPiece> func_242845_a(ConfiguredFeature<?, ?> p_242845_0_) {
        return p_242846_1_ -> new FeatureJigsawPiece(() -> p_242845_0_, (JigsawPattern.PlacementBehaviour)p_242846_1_);
    }

    public static Function<JigsawPattern.PlacementBehaviour, ListJigsawPiece> func_242853_a(List<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>> p_242853_0_) {
        return p_242854_1_ -> new ListJigsawPiece(p_242853_0_.stream().map(p_242847_1_ -> (JigsawPiece)p_242847_1_.apply(p_242854_1_)).collect(Collectors.toList()), (JigsawPattern.PlacementBehaviour)p_242854_1_);
    }
}

